/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration;

import info.novatec.inspectit.cmr.property.configuration.AbstractProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.BooleanProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.ByteProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.LongProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.PercentageProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.StringProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidationException;
import info.novatec.inspectit.cmr.property.configuration.validator.ISinglePropertyValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.FullyQualifiedClassNameValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.GreaterOrEqualValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.GreaterValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.LessOrEqualValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.LessValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.NegativeValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.NotEmptyValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.PercentageValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.PositiveValidator;
import info.novatec.inspectit.cmr.property.update.AbstractPropertyUpdate;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import info.novatec.inspectit.cmr.property.update.impl.RestoreDefaultPropertyUpdate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.collections.CollectionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={StringProperty.class, LongProperty.class, BooleanProperty.class, PercentageProperty.class, ByteProperty.class})
public abstract class SingleProperty<T>
extends AbstractProperty {
    @XmlAttribute(name="logical-name", required=true)
    private String logicalName;
    @XmlAttribute(name="advanced", required=true)
    private boolean advanced;
    @XmlAttribute(name="server-restart-required", required=true)
    private boolean serverRestartRequired;
    @XmlElementWrapper(name="validators")
    @XmlElementRefs(value={@XmlElementRef(type=LessValidator.class), @XmlElementRef(type=LessOrEqualValidator.class), @XmlElementRef(type=GreaterValidator.class), @XmlElementRef(type=GreaterOrEqualValidator.class), @XmlElementRef(type=PercentageValidator.class), @XmlElementRef(type=PositiveValidator.class), @XmlElementRef(type=NegativeValidator.class), @XmlElementRef(type=FullyQualifiedClassNameValidator.class), @XmlElementRef(type=NotEmptyValidator.class)})
    private List<ISinglePropertyValidator<? super T>> validators;

    public SingleProperty() {
    }

    public SingleProperty(String name, String description, String logicalName, T defaultValue, boolean advanced, boolean serverRestartRequired) throws IllegalArgumentException {
        super(name, description);
        if (null == logicalName) {
            throw new IllegalArgumentException("Logical name of the property can not be null.");
        }
        if (null == defaultValue) {
            throw new IllegalArgumentException("Default value of the property can not be null.");
        }
        this.logicalName = logicalName;
        this.advanced = advanced;
        this.serverRestartRequired = serverRestartRequired;
        this.setDefaultValue(defaultValue);
    }

    public abstract T getDefaultValue();

    protected abstract void setDefaultValue(T var1);

    protected abstract T getUsedValue();

    protected abstract void setUsedValue(T var1);

    public abstract T parseLiteral(String var1);

    protected abstract AbstractPropertyUpdate<T> createPropertyUpdate(T var1);

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }

    @Override
    public boolean isServerRestartRequired() {
        return this.serverRestartRequired;
    }

    @Override
    protected void validate(PropertyValidation propertyValidation) {
        if (CollectionUtils.isNotEmpty(this.validators)) {
            for (ISinglePropertyValidator<T> validator : this.validators) {
                validator.validate(this, propertyValidation);
            }
        }
    }

    protected PropertyValidation validateForValue(T value) {
        PropertyValidation propertyValidation = PropertyValidation.createFor(this);
        if (CollectionUtils.isNotEmpty(this.validators)) {
            for (ISinglePropertyValidator<T> validator : this.validators) {
                validator.validateForValue(this, propertyValidation, value);
            }
        }
        return propertyValidation;
    }

    @Override
    public void register(Properties properties) {
        properties.setProperty(this.logicalName, this.getValue().toString());
    }

    @Override
    public SingleProperty<?> forLogicalname(String propertyLogicalName) {
        if (this.logicalName.equals(propertyLogicalName)) {
            return this;
        }
        return null;
    }

    public void setToDefaultValue() {
        this.setUsedValue(null);
    }

    public AbstractPropertyUpdate<T> createAndValidatePropertyUpdate(T updateValue) throws PropertyValidationException {
        if (this.getValue().equals(updateValue)) {
            throw new PropertyValidationException("Update value for creating property update can not be same as current property value.");
        }
        PropertyValidation propertyValidation = this.validateForValue(updateValue);
        if (propertyValidation.hasErrors()) {
            throw new PropertyValidationException(propertyValidation);
        }
        return this.createPropertyUpdate(updateValue);
    }

    public RestoreDefaultPropertyUpdate<T> createRestoreDefaultPropertyUpdate() {
        return new RestoreDefaultPropertyUpdate(this);
    }

    public boolean canUpdate(IPropertyUpdate<?> propertyUpdate) {
        if (propertyUpdate.isRestoreDefault()) {
            return true;
        }
        if (!this.logicalName.equals(propertyUpdate.getPropertyLogicalName())) {
            return false;
        }
        Object updateValue = propertyUpdate.getUpdateValue();
        if (!this.getValue().getClass().equals(updateValue.getClass())) {
            return false;
        }
        if (this.getValue().equals(updateValue)) {
            return false;
        }
        PropertyValidation propertyValidation = this.validateForValue(updateValue);
        return !propertyValidation.hasErrors();
    }

    public void addValidator(ISinglePropertyValidator<? super T> validator) {
        if (null == this.validators) {
            this.validators = new ArrayList<ISinglePropertyValidator<? super T>>();
        }
        this.validators.add(validator);
    }

    public boolean isDefaultValueUsed() {
        if (null != this.getUsedValue()) {
            return this.getUsedValue().equals(this.getDefaultValue());
        }
        return true;
    }

    public T getValue() {
        if (null != this.getUsedValue()) {
            return this.getUsedValue();
        }
        return this.getDefaultValue();
    }

    public void setValue(T value) {
        this.setUsedValue(value);
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public String getFormattedValue() {
        return this.getValue().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        result = 31 * result + (this.logicalName == null ? 0 : this.logicalName.hashCode());
        result = 31 * result + (this.getUsedValue() == null ? 0 : this.getUsedValue().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleProperty other = (SingleProperty)obj;
        if (this.getDefaultValue() == null ? other.getDefaultValue() != null : !this.getDefaultValue().equals(other.getDefaultValue())) {
            return false;
        }
        if (this.logicalName == null ? other.logicalName != null : !this.logicalName.equals(other.logicalName)) {
            return false;
        }
        return !(this.getUsedValue() == null ? other.getUsedValue() != null : !this.getUsedValue().equals(other.getUsedValue()));
    }
}

