/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectAgentsWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Selected Agent(s)";
    private List<? extends PlatformIdent> agentList;
    private Table agentSelection;
    private Composite main;
    private Button allAgents;
    private Button specificAgents;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private Collection<PlatformIdent> autoSelectedAgents;

    public SelectAgentsWizardPage() {
        this(DEFAULT_MESSAGE);
    }

    public SelectAgentsWizardPage(String string) {
        this(string, Collections.emptyList());
    }

    public SelectAgentsWizardPage(String string, Collection<PlatformIdent> collection) {
        super("Select Agent(s)");
        this.setTitle("Select Agent(s)");
        this.setMessage(string);
        this.autoSelectedAgents = collection;
    }

    public void createControl(Composite composite) {
        this.main = new Composite(composite, 0);
        this.setControl((Control)this.main);
    }

    public boolean isPageComplete() {
        if (this.allAgents != null && !this.allAgents.isDisposed() && this.allAgents.getSelection()) {
            return true;
        }
        boolean bl = false;
        if (this.agentSelection != null && !this.agentSelection.isDisposed()) {
            TableItem[] tableItemArray = this.agentSelection.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                if (tableItem.getChecked()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public boolean isAllAgents() {
        return this.allAgents.getSelection();
    }

    public List<Long> getSelectedAgents() {
        if (this.allAgents.getSelection()) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (PlatformIdent platformIdent : this.agentList) {
                arrayList.add(platformIdent.getId());
            }
            return arrayList;
        }
        int n = 0;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        TableItem[] tableItemArray = this.agentSelection.getItems();
        int n2 = tableItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TableItem tableItem = tableItemArray[n3];
            if (tableItem.getChecked()) {
                arrayList.add(this.agentList.get(n).getId());
            }
            ++n;
            ++n3;
        }
        return arrayList;
    }

    public void setCmrRepositoryDefinition(final CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)this.cmrRepositoryDefinition)) {
            Object object;
            this.cmrRepositoryDefinition = cmrRepositoryDefinition;
            Control[] controlArray = this.main.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = controlArray[n2];
                object.dispose();
                ++n2;
            }
            if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                object = new Job("Loading agents information.."){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        final Map map = cmrRepositoryDefinition.getGlobalDataAccessService().getAgentsOverview();
                        SelectAgentsWizardPage.this.agentList = new ArrayList(map.keySet());
                        Collections.sort(SelectAgentsWizardPage.this.agentList, new Comparator<PlatformIdent>(){

                            @Override
                            public int compare(PlatformIdent platformIdent, PlatformIdent platformIdent2) {
                                return platformIdent.getAgentName().compareToIgnoreCase(platformIdent2.getAgentName());
                            }
                        });
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Object object2;
                                SelectAgentsWizardPage.this.main.setLayout((Layout)new GridLayout(1, false));
                                SelectAgentsWizardPage.this.allAgents = new Button(SelectAgentsWizardPage.this.main, 16);
                                SelectAgentsWizardPage.this.allAgents.setText("All agent(s)");
                                SelectAgentsWizardPage.this.allAgents.setSelection(true);
                                SelectAgentsWizardPage.this.specificAgents = new Button(SelectAgentsWizardPage.this.main, 16);
                                SelectAgentsWizardPage.this.specificAgents.setText("Select specific Agent(s)");
                                boolean bl = false;
                                SelectAgentsWizardPage.this.agentSelection = new Table(SelectAgentsWizardPage.this.main, 68384);
                                for (Object object2 : SelectAgentsWizardPage.this.agentList) {
                                    AgentStatusData agentStatusData = (AgentStatusData)map.get(object2);
                                    TableItem tableItem = new TableItem(SelectAgentsWizardPage.this.agentSelection, 0);
                                    tableItem.setText(TextFormatter.getAgentDescription(object2, agentStatusData));
                                    tableItem.setImage(ImageFormatter.getAgentImage(agentStatusData));
                                    if (!CollectionUtils.isNotEmpty((Collection)SelectAgentsWizardPage.this.autoSelectedAgents) || !SelectAgentsWizardPage.this.autoSelectedAgents.contains(object2)) continue;
                                    tableItem.setChecked(true);
                                    bl = true;
                                }
                                SelectAgentsWizardPage.this.agentSelection.setLayoutData((Object)new GridData(4, 4, true, true));
                                SelectAgentsWizardPage.this.agentSelection.setEnabled(false);
                                object2 = new Listener(){

                                    public void handleEvent(Event event) {
                                        SelectAgentsWizardPage.this.setPageComplete(SelectAgentsWizardPage.this.isPageComplete());
                                    }
                                };
                                SelectAgentsWizardPage.this.agentSelection.addListener(13, (Listener)object2);
                                SelectAgentsWizardPage.this.allAgents.addListener(13, (Listener)object2);
                                SelectAgentsWizardPage.this.specificAgents.addListener(13, (Listener)object2);
                                Listener listener = new Listener(){

                                    public void handleEvent(Event event) {
                                        if (SelectAgentsWizardPage.this.allAgents.getSelection()) {
                                            SelectAgentsWizardPage.this.agentSelection.setEnabled(false);
                                        } else {
                                            SelectAgentsWizardPage.this.agentSelection.setEnabled(true);
                                        }
                                    }
                                };
                                SelectAgentsWizardPage.this.allAgents.addListener(13, listener);
                                SelectAgentsWizardPage.this.specificAgents.addListener(13, listener);
                                if (bl) {
                                    SelectAgentsWizardPage.this.specificAgents.setSelection(true);
                                    SelectAgentsWizardPage.this.allAgents.setSelection(false);
                                    SelectAgentsWizardPage.this.agentSelection.setEnabled(true);
                                }
                                SelectAgentsWizardPage.this.main.layout();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                object.schedule();
            } else {
                this.main.setLayout((Layout)new GridLayout(2, false));
                new Label(this.main, 0).setImage(Display.getDefault().getSystemImage(1));
                object = new Label(this.main, 64);
                object.setText("Selected repository is currently offline. Action can not be performed.");
                this.main.layout();
            }
        }
    }
}

