/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.progress.IProgressConstants;

public class PreviewCmrDataWizardPage
extends WizardPage {
    private Label name;
    private Label ip;
    private Label description;
    private Label connectionTest;
    private BusyIndicator busyIndicator;
    private Composite main;
    private Job checkCmrJob;
    private Label version;

    public PreviewCmrDataWizardPage() {
        super("Preview CMR Data");
        this.setTitle("Preview CMR Data");
        this.setMessage("Preview the entered CMR Repository data and confirm");
    }

    public void createControl(Composite composite) {
        this.main = new Composite(composite, 0);
        this.main.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(this.main, 16384);
        label.setText("Server name:");
        this.name = new Label(this.main, 0);
        this.name.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label label2 = new Label(this.main, 16384);
        label2.setText("IP Address:");
        this.ip = new Label(this.main, 0);
        this.ip.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.ip.setText("localhost");
        Label label3 = new Label(this.main, 16384);
        label3.setText("Description:");
        label3.setLayoutData((Object)new GridData(4, 128, false, false));
        this.description = new Label(this.main, 64);
        this.description.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        new Label(this.main, 16384).setText("Connection test:");
        this.connectionTest = new Label(this.main, 0);
        this.connectionTest.setLayoutData((Object)new GridData(4, 4, true, false));
        this.busyIndicator = new BusyIndicator(this.main, 0);
        this.busyIndicator.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label(this.main, 16384).setText("Version:");
        this.version = new Label(this.main, 0);
        this.version.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.setControl((Control)this.main);
    }

    public void update(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.name.setText(cmrRepositoryDefinition.getName());
        this.ip.setText(String.valueOf(cmrRepositoryDefinition.getIp()) + ":" + cmrRepositoryDefinition.getPort());
        this.description.setText(cmrRepositoryDefinition.getDescription());
        this.connectionTest.setText("Checking..");
        this.busyIndicator.setBusy(true);
        this.version.setText("");
        this.main.layout();
        this.checkCmrJob = new CheckCmrJob(cmrRepositoryDefinition);
        this.checkCmrJob.schedule();
    }

    public void cancel() {
        if (this.checkCmrJob != null) {
            this.checkCmrJob.cancel();
        }
        this.busyIndicator.setBusy(false);
        this.main.layout();
    }

    private class CheckCmrJob
    extends Job {
        private boolean isCanceled;
        private CmrRepositoryDefinition cmrRepositoryDefinition;

        public CheckCmrJob(CmrRepositoryDefinition cmrRepositoryDefinition) {
            super("Checking online status..");
            this.isCanceled = false;
            this.setUser(false);
            this.setProperty(IProgressConstants.ICON_PROPERTY, InspectIT.getDefault().getImageDescriptor("/icons/selfmade/server_refresh_16x16.png"));
            this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        }

        public IStatus run(IProgressMonitor iProgressMonitor) {
            if (this.cmrRepositoryDefinition == null) {
                return Status.CANCEL_STATUS;
            }
            boolean bl = false;
            try {
                this.cmrRepositoryDefinition.refreshOnlineStatus();
                bl = this.cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE;
            }
            catch (Exception exception) {
                bl = false;
            }
            String string = null;
            if (this.isCanceled) {
                return Status.CANCEL_STATUS;
            }
            if (bl) {
                string = this.cmrRepositoryDefinition.getVersion();
            }
            final boolean bl2 = bl;
            final String string2 = string;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PreviewCmrDataWizardPage.this.main.isDisposed()) {
                        PreviewCmrDataWizardPage.this.busyIndicator.setBusy(false);
                        if (bl2) {
                            PreviewCmrDataWizardPage.this.connectionTest.setText("Succeeded");
                            PreviewCmrDataWizardPage.this.version.setText(string2);
                        } else {
                            PreviewCmrDataWizardPage.this.connectionTest.setText("Failed");
                            PreviewCmrDataWizardPage.this.version.setText("n/a");
                        }
                        PreviewCmrDataWizardPage.this.main.layout();
                    }
                }
            });
            return Status.OK_STATUS;
        }

        protected void canceling() {
            this.isCanceled = true;
        }
    }
}

