/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.label.composite.AbstractStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.BooleanStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.DateStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.NumberStorageLabelComposite;
import info.novatec.inspectit.rcp.storage.label.composite.impl.StringStorageLabelComposite;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.management.AbstractLabelManagementAction;
import info.novatec.inspectit.storage.label.management.impl.AddLabelManagementAction;
import info.novatec.inspectit.storage.label.management.impl.RemoveLabelManagementAction;
import info.novatec.inspectit.storage.label.type.AbstractCustomStorageLabelType;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.CustomBooleanLabelType;
import info.novatec.inspectit.storage.label.type.impl.CustomDateLabelType;
import info.novatec.inspectit.storage.label.type.impl.CustomNumberLabelType;
import info.novatec.inspectit.storage.label.type.impl.CustomStringLabelType;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;

public class ManageLabelWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Add and remove labels that can be used later for labeling storages";
    private static final StyledString EMPTY_STYLED_STRING = new StyledString();
    private List<AbstractStorageLabel<?>> labelList = new ArrayList();
    private List<AbstractStorageLabelType<?>> labelTypeList = new ArrayList();
    private TableViewer labelsTableViewer;
    private Button removeLabels;
    private Button createLabel;
    private TableViewer labelTypeTableViewer;
    private Button createLabelType;
    private Button removeLabelType;
    private Set<AbstractStorageLabel<?>> labelsInStorages = new HashSet();
    private List<AbstractLabelManagementAction> managementActions = new LinkedList<AbstractLabelManagementAction>();
    private CmrRepositoryDefinition cmrRepositoryDefinition;

    public ManageLabelWizardPage(CmrRepositoryDefinition cmrRepositoryDefinition) {
        super("Manage Labels");
        this.setTitle("Manage Labels");
        this.setMessage(DEFAULT_MESSAGE);
        if (cmrRepositoryDefinition != null) {
            this.setMessage("Label management for repository '" + cmrRepositoryDefinition.getName() + "' (" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort() + ")");
        }
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
    }

    public void createControl(Composite composite) {
        SashForm sashForm = new SashForm(composite, 512);
        this.createLabelTypeTable((Composite)sashForm);
        this.createLabelTable((Composite)sashForm);
        sashForm.setWeights(new int[]{1, 1});
        this.setControl((Control)sashForm);
    }

    private void createLabelTypeTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("Existing label types");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Table table = new Table(composite2, 0x10010B00);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true, 1, 2);
        gridData.heightHint = 150;
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(false);
        tableColumn.setResizable(false);
        tableColumn.setWidth(25);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Name");
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setWidth(200);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Value type");
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText("One per storage");
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setWidth(80);
        this.labelTypeTableViewer = new TableViewer(table);
        this.labelTypeTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelTypeTableViewer.setLabelProvider((IBaseLabelProvider)new StyledCellIndexLabelProvider(){

            @Override
            protected StyledString getStyledText(Object object, int n) {
                if (object instanceof AbstractStorageLabelType) {
                    AbstractStorageLabelType abstractStorageLabelType = (AbstractStorageLabelType)object;
                    switch (n) {
                        case 1: {
                            return new StyledString(TextFormatter.getLabelName(abstractStorageLabelType));
                        }
                        case 2: {
                            return new StyledString(TextFormatter.getLabelValueType(abstractStorageLabelType));
                        }
                        case 3: {
                            if (abstractStorageLabelType.isOnePerStorage()) {
                                return new StyledString("Yes");
                            }
                            return new StyledString("No");
                        }
                    }
                }
                return EMPTY_STYLED_STRING;
            }

            @Override
            protected Image getColumnImage(Object object, int n) {
                if (n == 0 && object instanceof AbstractStorageLabelType) {
                    if (ManageLabelWizardPage.this.isLabelTypeExistsInStorage((AbstractStorageLabelType)object, ManageLabelWizardPage.this.labelsInStorages)) {
                        return InspectIT.getDefault().getImage("/icons/eclipse/storage.gif");
                    }
                } else if (n == 1 && object instanceof AbstractStorageLabelType) {
                    return ImageFormatter.getImageForLabel((AbstractStorageLabelType)object);
                }
                return null;
            }
        });
        this.labelTypeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ManageLabelWizardPage.this.manageLabelTypeSlection();
            }
        });
        this.labelTypeTableViewer.setInput(this.labelTypeList);
        this.createLabelType = new Button(composite2, 8);
        this.createLabelType.setText("Add");
        this.createLabelType.setToolTipText("Create New Label Type");
        this.createLabelType.setLayoutData((Object)new GridData(4, 128, false, false));
        this.createLabelType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CreateLabelTypeDialog createLabelTypeDialog = new CreateLabelTypeDialog(ManageLabelWizardPage.this.getShell());
                createLabelTypeDialog.open();
                if (createLabelTypeDialog.getReturnCode() == 0) {
                    AbstractStorageLabelType<?> abstractStorageLabelType = createLabelTypeDialog.getCreatedLabelType();
                    AddLabelManagementAction addLabelManagementAction = new AddLabelManagementAction(abstractStorageLabelType);
                    ManageLabelWizardPage.this.managementActions.add(addLabelManagementAction);
                    ManageLabelWizardPage.this.labelTypeList.add(abstractStorageLabelType);
                    ManageLabelWizardPage.this.labelTypeTableViewer.refresh();
                }
            }
        });
        this.removeLabelType = new Button(composite2, 8);
        this.removeLabelType.setText("Remove");
        this.removeLabelType.setToolTipText("Remove Label Type");
        this.removeLabelType.setEnabled(false);
        this.removeLabelType.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removeLabelType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RemoveLabelManagementAction removeLabelManagementAction;
                AbstractStorageLabelType abstractStorageLabelType = (AbstractStorageLabelType)((StructuredSelection)ManageLabelWizardPage.this.labelTypeTableViewer.getSelection()).getFirstElement();
                boolean bl = false;
                if (ManageLabelWizardPage.this.isLabelTypeExistsInStorage(abstractStorageLabelType, ManageLabelWizardPage.this.labelsInStorages) && (removeLabelManagementAction = new MessageDialog(ManageLabelWizardPage.this.getShell(), "Remove Label Type", null, "Should all labels of selected type be removed also from storages where they are used?", 3, new String[]{"Yes", "No"}, 1)).open() == 0) {
                    bl = true;
                }
                removeLabelManagementAction = new RemoveLabelManagementAction(abstractStorageLabelType, bl);
                ManageLabelWizardPage.this.managementActions.add(removeLabelManagementAction);
                ManageLabelWizardPage.this.labelTypeList.remove(abstractStorageLabelType);
                Iterator iterator = ManageLabelWizardPage.this.labelList.iterator();
                while (iterator.hasNext()) {
                    if (!ObjectUtils.equals((Object)abstractStorageLabelType, (Object)((AbstractStorageLabel)iterator.next()).getStorageLabelType())) continue;
                    iterator.remove();
                }
                ManageLabelWizardPage.this.labelTypeTableViewer.refresh();
            }
        });
        Job job = new Job("Loading Labels Data"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                ManageLabelWizardPage.this.labelsInStorages.addAll(ManageLabelWizardPage.this.cmrRepositoryDefinition.getStorageService().getAllLabelsInStorages());
                ManageLabelWizardPage.this.labelTypeList.addAll(ManageLabelWizardPage.this.cmrRepositoryDefinition.getStorageService().getAllLabelTypes());
                ManageLabelWizardPage.this.labelList.addAll(ManageLabelWizardPage.this.cmrRepositoryDefinition.getStorageService().getAllLabels());
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ManageLabelWizardPage.this.labelsTableViewer.refresh();
                        ManageLabelWizardPage.this.labelTypeTableViewer.refresh();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void createLabelTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Table table = new Table(composite2, 268503810);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true, 1, 2);
        gridData.heightHint = 150;
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(false);
        tableColumn.setResizable(false);
        tableColumn.setWidth(25);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Label");
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setWidth(200);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Value");
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setWidth(100);
        this.labelsTableViewer = new TableViewer(table);
        this.labelsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelsTableViewer.setLabelProvider((IBaseLabelProvider)new StyledCellIndexLabelProvider(){

            @Override
            protected StyledString getStyledText(Object object, int n) {
                if (object instanceof AbstractStorageLabel) {
                    AbstractStorageLabel abstractStorageLabel = (AbstractStorageLabel)object;
                    switch (n) {
                        case 1: {
                            return new StyledString(TextFormatter.getLabelName(abstractStorageLabel));
                        }
                        case 2: {
                            return new StyledString(TextFormatter.getLabelValue(abstractStorageLabel, false));
                        }
                    }
                }
                return EMPTY_STYLED_STRING;
            }

            @Override
            protected Image getColumnImage(Object object, int n) {
                if (n == 0 && object instanceof AbstractStorageLabel && ManageLabelWizardPage.this.isLabelExistsInStorage((AbstractStorageLabel)object, ManageLabelWizardPage.this.labelsInStorages)) {
                    return InspectIT.getDefault().getImage("/icons/eclipse/storage.gif");
                }
                if (n == 1 && object instanceof AbstractStorageLabel) {
                    return ImageFormatter.getImageForLabel(((AbstractStorageLabel)object).getStorageLabelType());
                }
                return null;
            }
        });
        this.labelsTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof AbstractStorageLabel && object2 instanceof AbstractStorageLabel) {
                    return ((AbstractStorageLabel)object).compareTo((AbstractStorageLabel)object2);
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.labelsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (ManageLabelWizardPage.this.labelsTableViewer.getSelection().isEmpty()) {
                    ManageLabelWizardPage.this.removeLabels.setEnabled(false);
                } else {
                    ManageLabelWizardPage.this.removeLabels.setEnabled(true);
                }
            }
        });
        this.createLabel = new Button(composite2, 8);
        this.createLabel.setText("Add");
        this.createLabel.setToolTipText("Create New Label");
        this.createLabel.setLayoutData((Object)new GridData(4, 128, false, false));
        this.createLabel.setEnabled(false);
        this.createLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractStorageLabelType abstractStorageLabelType = (AbstractStorageLabelType)((StructuredSelection)ManageLabelWizardPage.this.labelTypeTableViewer.getSelection()).getFirstElement();
                CreateLabelDialog createLabelDialog = new CreateLabelDialog(ManageLabelWizardPage.this.getShell(), ManageLabelWizardPage.this.labelTypeList, abstractStorageLabelType);
                createLabelDialog.open();
                if (createLabelDialog.getReturnCode() == 0) {
                    AbstractStorageLabel<?> abstractStorageLabel = createLabelDialog.getCreatedLabel();
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(abstractStorageLabel);
                    AddLabelManagementAction addLabelManagementAction = new AddLabelManagementAction(arrayList);
                    ManageLabelWizardPage.this.managementActions.add(addLabelManagementAction);
                    ManageLabelWizardPage.this.labelList.add(abstractStorageLabel);
                    ManageLabelWizardPage.this.manageLabelTypeSlection();
                }
            }
        });
        this.removeLabels = new Button(composite2, 8);
        this.removeLabels.setText("Remove");
        this.removeLabels.setToolTipText("Remove Label(s)");
        this.removeLabels.setEnabled(false);
        this.removeLabels.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removeLabels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List list = ((StructuredSelection)ManageLabelWizardPage.this.labelsTableViewer.getSelection()).toList();
                boolean bl = false;
                RemoveLabelManagementAction removeLabelManagementAction = list.iterator();
                while (removeLabelManagementAction.hasNext()) {
                    AbstractStorageLabel abstractStorageLabel = (AbstractStorageLabel)removeLabelManagementAction.next();
                    if (!ManageLabelWizardPage.this.isLabelExistsInStorage(abstractStorageLabel, ManageLabelWizardPage.this.labelsInStorages)) continue;
                    bl = true;
                    break;
                }
                boolean bl2 = false;
                if (bl && (removeLabelManagementAction = new MessageDialog(ManageLabelWizardPage.this.getShell(), "Remove Label(s)", null, "Should all selected labels be removed also from storages where they are used?", 3, new String[]{"Yes", "No"}, 1)).open() == 0) {
                    bl2 = true;
                    ManageLabelWizardPage.this.labelsInStorages.removeAll(list);
                }
                removeLabelManagementAction = new RemoveLabelManagementAction((Collection)list, bl2);
                ManageLabelWizardPage.this.managementActions.add(removeLabelManagementAction);
                ManageLabelWizardPage.this.labelList.removeAll(list);
                ManageLabelWizardPage.this.manageLabelTypeSlection();
                ManageLabelWizardPage.this.labelTypeTableViewer.refresh(true);
            }
        });
        FormText formText = new FormText(composite2, 0);
        formText.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        formText.setImage("storage", InspectIT.getDefault().getImage("/icons/eclipse/storage.gif"));
        formText.setText("<form><p>The icon <img href=\"storage\"/> denotes that label type or label is currently used in one or more storages.</p></form>", true, false);
    }

    private boolean isLabelTypeExistsInStorage(AbstractStorageLabelType<?> abstractStorageLabelType, Set<AbstractStorageLabel<?>> set) {
        for (AbstractStorageLabel<?> abstractStorageLabel : set) {
            if (!ObjectUtils.equals((Object)abstractStorageLabel.getStorageLabelType(), abstractStorageLabelType)) continue;
            return true;
        }
        return false;
    }

    private boolean isLabelExistsInStorage(AbstractStorageLabel<?> abstractStorageLabel, Set<AbstractStorageLabel<?>> set) {
        for (AbstractStorageLabel<?> abstractStorageLabel2 : set) {
            if (!ObjectUtils.equals(abstractStorageLabel, abstractStorageLabel2)) continue;
            return true;
        }
        return false;
    }

    private void manageLabelTypeSlection() {
        if (!this.labelTypeTableViewer.getSelection().isEmpty()) {
            AbstractStorageLabelType abstractStorageLabelType = (AbstractStorageLabelType)((StructuredSelection)this.labelTypeTableViewer.getSelection()).getFirstElement();
            ArrayList arrayList = new ArrayList();
            for (AbstractStorageLabel<?> abstractStorageLabel : this.labelList) {
                if (!ObjectUtils.equals((Object)abstractStorageLabel.getStorageLabelType(), (Object)abstractStorageLabelType)) continue;
                arrayList.add(abstractStorageLabel);
            }
            if (abstractStorageLabelType.isValueReusable()) {
                this.createLabel.setEnabled(true);
                this.labelsTableViewer.getTable().setEnabled(true);
            } else {
                this.createLabel.setEnabled(false);
                this.labelsTableViewer.getTable().setEnabled(false);
            }
            this.removeLabelType.setEnabled(AbstractCustomStorageLabelType.class.isAssignableFrom(abstractStorageLabelType.getClass()));
            this.labelsTableViewer.setInput(arrayList);
            this.labelsTableViewer.refresh();
        } else {
            this.removeLabelType.setEnabled(false);
            this.createLabel.setEnabled(true);
            this.labelsTableViewer.getTable().setEnabled(true);
            this.labelsTableViewer.setInput(null);
            this.labelsTableViewer.refresh();
        }
    }

    public boolean isShouldRefreshStorages() {
        return !this.managementActions.isEmpty();
    }

    public List<AbstractLabelManagementAction> getManagementActions() {
        return this.managementActions;
    }

    private static class CreateLabelDialog
    extends TitleAreaDialog {
        private List<AbstractStorageLabelType<?>> labelTypes;
        private AbstractStorageLabelType<?> suggestedType;
        private Combo typeSelection;
        private AbstractStorageLabelComposite storageLabelComposite;
        private Button okButton;
        private Composite main;
        private AbstractStorageLabel<?> createdLabel;

        public CreateLabelDialog(Shell shell, List<AbstractStorageLabelType<?>> list, AbstractStorageLabelType<?> abstractStorageLabelType) {
            super(shell);
            this.labelTypes = list;
            this.suggestedType = abstractStorageLabelType;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Create Label");
        }

        public void create() {
            super.create();
            this.setTitle("Create Label");
            this.setMessage("Selected wanted label type and define label value", 1);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, true);
            this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(this.isInputValid());
        }

        protected void buttonPressed(int n) {
            if (n == 0) {
                this.createdLabel = this.storageLabelComposite.getStorageLabel();
            }
            super.buttonPressed(n);
        }

        protected Control createDialogArea(Composite composite) {
            Object object2;
            this.main = new Composite(composite, 0);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 350;
            this.main.setLayoutData((Object)gridData);
            this.main.setLayout((Layout)new GridLayout(2, false));
            new Label(this.main, 0).setText("Label type:");
            this.typeSelection = new Combo(this.main, 12);
            int n = -1;
            int n2 = 0;
            for (Object object2 : this.labelTypes) {
                this.typeSelection.add(TextFormatter.getLabelName(object2));
                if (ObjectUtils.equals(object2, this.suggestedType)) {
                    n = n2;
                }
                ++n2;
            }
            this.typeSelection.select(n);
            this.typeSelection.setLayoutData((Object)new GridData(4, 4, true, false));
            this.typeSelection.setEnabled(false);
            object2 = new Listener(){

                public void handleEvent(Event event) {
                    CreateLabelDialog.this.okButton.setEnabled(CreateLabelDialog.this.isInputValid());
                }
            };
            this.typeSelection.addListener(13, object2);
            this.typeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CreateLabelDialog.this.updateStorageLabelComposite();
                }
            });
            new Label(this.main, 0).setText("Label value:");
            this.updateStorageLabelComposite();
            this.typeSelection.forceFocus();
            return this.main;
        }

        public AbstractStorageLabel<?> getCreatedLabel() {
            return this.createdLabel;
        }

        private void updateStorageLabelComposite() {
            AbstractStorageLabelType<?> abstractStorageLabelType;
            if (this.storageLabelComposite != null && !this.storageLabelComposite.isDisposed()) {
                this.storageLabelComposite.dispose();
            }
            if ((abstractStorageLabelType = this.labelTypes.get(this.typeSelection.getSelectionIndex())).getValueClass().equals(Boolean.class)) {
                this.storageLabelComposite = new BooleanStorageLabelComposite(this.main, 0, abstractStorageLabelType, false);
            } else if (abstractStorageLabelType.getValueClass().equals(Date.class)) {
                this.storageLabelComposite = new DateStorageLabelComposite(this.main, 0, abstractStorageLabelType, false);
            } else if (abstractStorageLabelType.getValueClass().equals(Number.class)) {
                this.storageLabelComposite = new NumberStorageLabelComposite(this.main, 0, abstractStorageLabelType, false);
            } else if (abstractStorageLabelType.getValueClass().equals(String.class)) {
                this.storageLabelComposite = new StringStorageLabelComposite(this.main, 0, abstractStorageLabelType, false);
            }
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    CreateLabelDialog.this.okButton.setEnabled(CreateLabelDialog.this.isInputValid());
                }
            };
            this.storageLabelComposite.setLayoutData(new GridData(4, 4, true, false));
            this.storageLabelComposite.addListener(listener);
            this.main.layout();
        }

        private boolean isInputValid() {
            if (this.typeSelection.getSelectionIndex() == -1) {
                return false;
            }
            return this.storageLabelComposite != null && this.storageLabelComposite.isInputValid();
        }
    }

    private static class CreateLabelTypeDialog
    extends TitleAreaDialog {
        private final AbstractCustomStorageLabelType<?>[] availableTypes = new AbstractCustomStorageLabelType[]{new CustomBooleanLabelType(), new CustomDateLabelType(), new CustomNumberLabelType(), new CustomStringLabelType()};
        private AbstractStorageLabelType<?> createdLabelType;
        private final String[] imageKeys = ImageFormatter.LABEL_ICONS;
        private int selectedImageKeyIndex = -1;
        private Button[] imageButtons;
        private Button okButton;
        private Composite main;
        private Text name;
        private Combo valueTypeSelection;
        private Button yesButton;
        private Button noButton;

        public CreateLabelTypeDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Create Label Type");
        }

        public void create() {
            super.create();
            this.setTitle("Create Label Type");
            this.setMessage("Define properties for the new label type", 1);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, true);
            this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(false);
        }

        protected void buttonPressed(int n) {
            if (n == 0) {
                this.createdLabelType = this.ensureLabelType();
            }
            super.buttonPressed(n);
        }

        protected Control createDialogArea(Composite composite) {
            Object object;
            Label label;
            this.main = new Composite(composite, 0);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 350;
            this.main.setLayoutData((Object)gridData);
            this.main.setLayout((Layout)new GridLayout(3, false));
            new Label(this.main, 0).setText("Name:");
            this.name = new Text(this.main, 2048);
            this.name.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            new Label(this.main, 0).setText("Value type:");
            this.valueTypeSelection = new Combo(this.main, 12);
            this.valueTypeSelection.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            Object object2 = this.availableTypes;
            int n = this.availableTypes.length;
            int n2 = 0;
            while (n2 < n) {
                label = object2[n2];
                this.valueTypeSelection.add(TextFormatter.getLabelValueType(label));
                ++n2;
            }
            new Label(this.main, 0).setText("One per storage:");
            this.yesButton = new Button(this.main, 16);
            this.yesButton.setText("Yes");
            this.yesButton.setSelection(true);
            this.noButton = new Button(this.main, 16);
            this.noButton.setText("No");
            label = new Label(this.main, 0);
            label.setText("Icon:");
            label.setLayoutData((Object)new GridData(4, 128, false, false));
            final ScrolledComposite scrolledComposite = new ScrolledComposite(this.main, 2560);
            gridData = new GridData(4, 4, false, false, 2, 1);
            gridData.widthHint = 1;
            gridData.heightHint = 120;
            scrolledComposite.setLayoutData((Object)gridData);
            final Composite composite2 = new Composite((Composite)scrolledComposite, 0);
            composite2.setBackground(Display.getDefault().getSystemColor(1));
            object2 = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = 0;
                    while (n < CreateLabelTypeDialog.this.imageButtons.length) {
                        if (Objects.equals(CreateLabelTypeDialog.this.imageButtons[n], selectionEvent.widget)) {
                            if (CreateLabelTypeDialog.this.selectedImageKeyIndex == n) {
                                CreateLabelTypeDialog.this.selectedImageKeyIndex = -1;
                            } else {
                                CreateLabelTypeDialog.this.selectedImageKeyIndex = n;
                            }
                        } else {
                            CreateLabelTypeDialog.this.imageButtons[n].setSelection(false);
                        }
                        ++n;
                    }
                }
            };
            this.imageButtons = new Button[this.imageKeys.length];
            int n3 = 0;
            while (n3 < this.imageKeys.length) {
                object = new Button(composite2, 2);
                object.setImage(InspectIT.getDefault().getImage(this.imageKeys[n3]));
                object.setBackground(Display.getDefault().getSystemColor(1));
                object.addSelectionListener(object2);
                this.imageButtons[n3] = object;
                ++n3;
            }
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.wrap = true;
            rowLayout.fill = true;
            rowLayout.justify = true;
            rowLayout.spacing = 7;
            composite2.setLayout((Layout)rowLayout);
            scrolledComposite.setContent((Control)composite2);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    Rectangle rectangle = scrolledComposite.getClientArea();
                    scrolledComposite.setMinSize(composite2.computeSize(rectangle.width, -1));
                }
            });
            object = new Listener(){

                public void handleEvent(Event event) {
                    CreateLabelTypeDialog.this.okButton.setEnabled(CreateLabelTypeDialog.this.isInputValid());
                }
            };
            this.name.addListener(24, (Listener)object);
            this.valueTypeSelection.addListener(13, (Listener)object);
            this.yesButton.addListener(13, (Listener)object);
            this.noButton.addListener(13, (Listener)object);
            this.name.forceFocus();
            return this.main;
        }

        private boolean isInputValid() {
            if (this.name.getText().trim().isEmpty()) {
                return false;
            }
            return this.valueTypeSelection.getSelectionIndex() != -1;
        }

        private AbstractStorageLabelType<?> ensureLabelType() {
            AbstractCustomStorageLabelType<?> abstractCustomStorageLabelType = this.availableTypes[this.valueTypeSelection.getSelectionIndex()];
            abstractCustomStorageLabelType.setName(this.name.getText().trim());
            abstractCustomStorageLabelType.setOnePerStorage(this.yesButton.getSelection());
            if (this.selectedImageKeyIndex >= 0 && this.selectedImageKeyIndex < this.imageKeys.length) {
                abstractCustomStorageLabelType.setImageKey(this.imageKeys[this.selectedImageKeyIndex]);
            }
            return abstractCustomStorageLabelType;
        }

        public AbstractStorageLabelType<?> getCreatedLabelType() {
            return this.createdLabelType;
        }
    }
}

