/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.composite.StorageInfoComposite;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageFileType;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportStorageWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Select where to export storage";
    private IStorageData storageData;
    private Text fileText;

    public ExportStorageWizardPage(IStorageData iStorageData) {
        super("Export Storage");
        this.setTitle("Export Storage");
        this.setMessage(DEFAULT_MESSAGE);
        this.storageData = iStorageData;
    }

    public void createControl(Composite composite) {
        boolean bl;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        new Label(composite2, 0).setText("File:");
        this.fileText = new Text(composite2, 2056);
        this.fileText.setLayoutData((Object)new GridData(4, 4, true, false));
        Button button = new Button(composite2, 8);
        button.setText("Select");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(ExportStorageWizardPage.this.getShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText("Select File for Export");
                fileDialog.setFilterExtensions(new String[]{"*" + StorageFileType.ZIP_STORAGE_FILE.getExtension()});
                fileDialog.setFileName(ExportStorageWizardPage.this.storageData.getName());
                String string = fileDialog.open();
                if (string != null) {
                    ExportStorageWizardPage.this.fileText.setText(string);
                }
                ExportStorageWizardPage.this.setPageComplete(ExportStorageWizardPage.this.isPageComplete());
                if (ExportStorageWizardPage.this.fileText.getText().isEmpty()) {
                    ExportStorageWizardPage.this.setMessage("No file selected", 3);
                } else {
                    ExportStorageWizardPage.this.setMessage(ExportStorageWizardPage.DEFAULT_MESSAGE);
                }
            }
        });
        button.forceFocus();
        StorageInfoComposite storageInfoComposite = new StorageInfoComposite(composite2, 0, true, this.storageData);
        storageInfoComposite.setLayoutData(new GridData(4, 4, true, false, 3, 1));
        LocalStorageData localStorageData = null;
        if (this.storageData instanceof LocalStorageData) {
            localStorageData = (LocalStorageData)this.storageData;
        } else if (this.storageData instanceof StorageData) {
            localStorageData = InspectIT.getDefault().getInspectITStorageManager().getLocalDataForStorage((StorageData)this.storageData);
        }
        boolean bl2 = bl = localStorageData == null || !localStorageData.isFullyDownloaded();
        if (bl) {
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new GridLayout(2, false));
            composite3.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
            new Label(composite3, 0).setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
            new Label(composite3, 64).setText("The not downloaded storage will have to be downloaded prior to export operation.");
        }
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        return !this.fileText.getText().isEmpty();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

