/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.StorageData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DefineNewStorageWizzardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Enter storage data and select the repository where it will be created";
    private List<CmrRepositoryDefinition> cmrRepositories;
    private Combo cmrRepositoryCombo;
    private Text nameBox;
    private Text descriptionBox;
    private Button autoFinalize;
    private CmrRepositoryDefinition proposedCmrRepositoryDefinition;
    private boolean autoFinalizeSelected;

    public DefineNewStorageWizzardPage() {
        super("Define New Storage");
        this.setTitle("Define New Storage");
        this.setDescription(DEFAULT_MESSAGE);
        this.cmrRepositories = new ArrayList<CmrRepositoryDefinition>();
        this.cmrRepositories.addAll(InspectIT.getDefault().getCmrRepositoryManager().getCmrRepositoryDefinitions());
    }

    public DefineNewStorageWizzardPage(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this(cmrRepositoryDefinition, true);
    }

    public DefineNewStorageWizzardPage(CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
        this();
        this.proposedCmrRepositoryDefinition = cmrRepositoryDefinition;
        this.autoFinalizeSelected = bl;
    }

    public void createControl(Composite composite) {
        CmrRepositoryDefinition cmrRepositoryDefinition2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 16384);
        label.setText("Repository:");
        this.cmrRepositoryCombo = new Combo(composite2, 8);
        this.cmrRepositoryCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        int n = 0;
        int n2 = -1;
        for (CmrRepositoryDefinition cmrRepositoryDefinition2 : this.cmrRepositories) {
            this.cmrRepositoryCombo.add(String.valueOf(cmrRepositoryDefinition2.getName()) + " (" + cmrRepositoryDefinition2.getIp() + ":" + cmrRepositoryDefinition2.getPort() + ")");
            if (cmrRepositoryDefinition2.equals(this.proposedCmrRepositoryDefinition)) {
                n2 = n;
            }
            ++n;
        }
        if (n2 != -1) {
            this.cmrRepositoryCombo.select(n2);
            this.cmrRepositoryCombo.setEnabled(false);
        }
        cmrRepositoryDefinition2 = new Label(composite2, 16384);
        cmrRepositoryDefinition2.setText("Storage name:");
        this.nameBox = new Text(composite2, 2048);
        this.nameBox.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label2 = new Label(composite2, 16384);
        label2.setText("Description:");
        label2.setLayoutData((Object)new GridData(4, 128, false, false));
        this.descriptionBox = new Text(composite2, 2626);
        this.descriptionBox.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(composite2, 16384);
        this.autoFinalize = new Button(composite2, 32);
        this.autoFinalize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.autoFinalize.setText("Auto-finalize storage");
        this.autoFinalize.setToolTipText("If selected the storage will be automatically finalized after the action completes");
        this.autoFinalize.setSelection(this.autoFinalizeSelected);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                DefineNewStorageWizzardPage.this.setPageComplete(DefineNewStorageWizzardPage.this.isPageComplete());
                if (event.widget.equals(DefineNewStorageWizzardPage.this.cmrRepositoryCombo) && DefineNewStorageWizzardPage.this.cmrRepositoryCombo.getSelectionIndex() == -1) {
                    DefineNewStorageWizzardPage.this.setMessage("Repository must be selected", 3);
                } else if (event.widget.equals(DefineNewStorageWizzardPage.this.cmrRepositoryCombo) && DefineNewStorageWizzardPage.this.getSelectedRepository().getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    DefineNewStorageWizzardPage.this.setMessage("Selected repository is currently unavailable", 3);
                } else if (event.widget.equals(DefineNewStorageWizzardPage.this.nameBox) && DefineNewStorageWizzardPage.this.nameBox.getText().isEmpty()) {
                    DefineNewStorageWizzardPage.this.setMessage("Storage name can not be empty", 3);
                } else {
                    DefineNewStorageWizzardPage.this.setMessage(DefineNewStorageWizzardPage.DEFAULT_MESSAGE);
                }
            }
        };
        this.cmrRepositoryCombo.addListener(13, listener);
        this.nameBox.addListener(24, listener);
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        if (this.cmrRepositoryCombo.getSelectionIndex() == -1) {
            return false;
        }
        if (this.getSelectedRepository().getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            return false;
        }
        return !this.nameBox.getText().isEmpty();
    }

    public CmrRepositoryDefinition getSelectedRepository() {
        if (this.cmrRepositoryCombo.getSelectionIndex() != -1) {
            return this.cmrRepositories.get(this.cmrRepositoryCombo.getSelectionIndex());
        }
        return null;
    }

    public StorageData getStorageData() {
        StorageData storageData = new StorageData();
        storageData.setName(this.nameBox.getText().trim());
        storageData.setDescription(this.descriptionBox.getText().trim());
        return storageData;
    }

    public boolean isAutoFinalize() {
        return this.autoFinalize.getSelection();
    }
}

