/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.page.StorageCompressionWizardPage;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class DownloadStorageWizard
extends Wizard
implements INewWizard {
    private Collection<IStorageDataProvider> storageDataProviders;
    private StorageCompressionWizardPage storageCompressionWizardPage;

    public DownloadStorageWizard(Collection<IStorageDataProvider> collection) {
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(collection));
        this.storageDataProviders = collection;
        if (collection.size() == 1) {
            this.setWindowTitle("Download Storage");
        } else {
            this.setWindowTitle("Download " + collection.size() + " Storages");
        }
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/download_wiz.png"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        String string = this.getWindowTitle();
        long l = 0L;
        for (IStorageDataProvider object2 : this.storageDataProviders) {
            l += object2.getStorageData().getDiskSize();
        }
        StringBuilder stringBuilder = new StringBuilder("Options for downloading ");
        if (this.storageDataProviders.size() == 1) {
            StorageData storageData = this.storageDataProviders.iterator().next().getStorageData();
            stringBuilder.append("the storage '");
            stringBuilder.append(storageData.getName());
            stringBuilder.append("' (size: ");
            stringBuilder.append(NumberFormatter.formatBytesToMBytes(storageData.getDiskSize()));
            stringBuilder.append(')');
        } else {
            stringBuilder.append(this.storageDataProviders.size());
            stringBuilder.append(" storages (total size: ");
            stringBuilder.append(NumberFormatter.formatBytesToMBytes(l));
            stringBuilder.append(')');
        }
        this.storageCompressionWizardPage = new StorageCompressionWizardPage(string, stringBuilder.toString());
        this.addPage((IWizardPage)this.storageCompressionWizardPage);
    }

    public boolean performFinish() {
        boolean bl = this.storageCompressionWizardPage.isCompressBefore();
        new DownloadStorageJob(this.storageDataProviders, bl).schedule();
        return true;
    }

    private static class DownloadStorageJob
    extends Job {
        private boolean compress;
        private Collection<IStorageDataProvider> storageDataProviders;

        public DownloadStorageJob(Collection<IStorageDataProvider> collection, boolean bl) {
            super("Download Storages");
            this.compress = bl;
            this.storageDataProviders = collection;
            this.setUser(true);
            this.setProperty(IProgressConstants.ICON_PROPERTY, InspectIT.getDefault().getImageDescriptor("/icons/eclipse/storage_download.gif"));
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
            ArrayList<Status> arrayList = new ArrayList<Status>();
            int n = 0;
            for (IStorageDataProvider iStorageDataProvider : this.storageDataProviders) {
                n += (int)(iStorageDataProvider.getStorageData().getDiskSize() / 1000L);
            }
            subMonitor.setWorkRemaining(n);
            for (IStorageDataProvider iStorageDataProvider : this.storageDataProviders) {
                StorageData storageData = iStorageDataProvider.getStorageData();
                CmrRepositoryDefinition cmrRepositoryDefinition = iStorageDataProvider.getCmrRepositoryDefinition();
                if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    arrayList.add(new Status(2, "info.novatec.inspectit.rcp", "Storage '" + storageData.getName() + "'can not be downloaded because the CMR it is located on is offline."));
                    continue;
                }
                try {
                    InspectIT.getDefault().getInspectITStorageManager().fullyDownloadStorage(storageData, cmrRepositoryDefinition, this.compress, subMonitor.newChild((int)(storageData.getDiskSize() / 1000L)));
                }
                catch (BusinessException | SerializationException | IOException throwable) {
                    arrayList.add(new Status(4, "info.novatec.inspectit.rcp", "Storage '" + storageData.getName() + "'was not downloaded due to the exception", throwable));
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.novatec.inspectit.rcp.view.storageManager");
                    if (iViewPart instanceof StorageManagerView) {
                        ((StorageManagerView)iViewPart).refreshWithoutCmrCall();
                    }
                }
            });
            iProgressMonitor.done();
            if (CollectionUtils.isNotEmpty(arrayList)) {
                if (1 == arrayList.size()) {
                    return (IStatus)arrayList.iterator().next();
                }
                return new MultiStatus("info.novatec.inspectit.rcp", 0, (IStatus[])arrayList.toArray(new Status[arrayList.size()]), "Download of several storages failed.", null);
            }
            return Status.OK_STATUS;
        }
    }
}

