/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.view.impl;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.action.MenuAction;
import info.novatec.inspectit.rcp.filter.FilterComposite;
import info.novatec.inspectit.rcp.form.StorageDataPropertyForm;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.Component;
import info.novatec.inspectit.rcp.model.GroupedLabelsComposite;
import info.novatec.inspectit.rcp.model.storage.LocalStorageLeaf;
import info.novatec.inspectit.rcp.model.storage.LocalStorageTreeModelManager;
import info.novatec.inspectit.rcp.model.storage.StorageLeaf;
import info.novatec.inspectit.rcp.model.storage.StorageTreeModelManager;
import info.novatec.inspectit.rcp.provider.ILocalStorageDataProvider;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.CmrRepositoryManager;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.InspectITStorageManager;
import info.novatec.inspectit.rcp.storage.listener.StorageChangeListener;
import info.novatec.inspectit.rcp.view.IRefreshableView;
import info.novatec.inspectit.rcp.view.tree.StorageManagerTreeContentProvider;
import info.novatec.inspectit.rcp.view.tree.StorageManagerTreeLabelProvider;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.util.ObjectUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class StorageManagerView
extends ViewPart
implements CmrRepositoryChangeListener,
StorageChangeListener,
IRefreshableView {
    public static final String VIEW_ID = "info.novatec.inspectit.rcp.view.storageManager";
    public static final String MENU_ID = "info.novatec.inspectit.rcp.view.storageManager.storageTree";
    private CmrRepositoryManager cmrRepositoryManager;
    private InspectITStorageManager storageManager;
    private Map<StorageData, CmrRepositoryDefinition> storageRepositoryMap = new ConcurrentHashMap<StorageData, CmrRepositoryDefinition>();
    private ConcurrentHashMap<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus> cachedOnlineStatus = new ConcurrentHashMap();
    private Set<LocalStorageData> downloadedStorages = Collections.newSetFromMap(new ConcurrentHashMap());
    private FormToolkit toolkit;
    private Form mainForm;
    private TreeViewer treeViewer;
    private TreeFilter treeFilter = new TreeFilter();
    private Composite cmrMessageComposite;
    private AbstractStorageLabelType<?> orderingLabelType = null;
    private MenuManager filterByRepositoryMenu;
    private MenuManager groupByLabelMenu;
    private MenuManager filterByStateMenu;
    private StorageDataPropertyForm storagePropertyForm;
    private StorageLeaf lastSelectedLeaf = null;
    private LocalStorageLeaf lastSelectedLocalStorageLeaf = null;
    private boolean verticaLayout = true;
    private SashForm mainComposite;
    private Composite upperComposite;
    private FilterStorageComposite filterStorageComposite;
    private Button remoteStorageSelection;
    private Button localStorageSelection;

    public StorageManagerView() {
        this.cmrRepositoryManager = InspectIT.getDefault().getCmrRepositoryManager();
        this.cmrRepositoryManager.addCmrRepositoryChangeListener(this);
        this.storageManager = InspectIT.getDefault().getInspectITStorageManager();
        this.storageManager.addStorageChangeListener(this);
        this.updateStorageList(null);
        this.updateDownloadedStorages();
    }

    public void createPartControl(Composite composite) {
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.createViewToolbar();
        this.mainComposite = new SashForm(composite, 512);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        this.mainForm = this.toolkit.createForm((Composite)this.mainComposite);
        this.mainForm.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout2 = new GridLayout(1, true);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        this.mainForm.getBody().setLayout((Layout)gridLayout2);
        this.toolkit.decorateFormHeading(this.mainForm);
        this.createHeadClient();
        this.upperComposite = this.toolkit.createComposite(this.mainForm.getBody());
        gridLayout2 = new GridLayout(1, true);
        gridLayout2.marginHeight = 0;
        this.upperComposite.setLayout((Layout)gridLayout2);
        this.upperComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        int n = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        Tree tree = this.toolkit.createTree(this.upperComposite, 770);
        this.toolkit.setBorderStyle(n);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new StorageManagerTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new StorageManagerTreeLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof GroupedLabelsComposite && object2 instanceof GroupedLabelsComposite) {
                    return ObjectUtils.compare((Comparable)((GroupedLabelsComposite)object), (Object)((GroupedLabelsComposite)object2));
                }
                if (object instanceof Component && object2 instanceof Component) {
                    return ((Component)object).getName().compareToIgnoreCase(((Component)object2).getName());
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.treeViewer.addFilter((ViewerFilter)this.treeFilter);
        this.treeViewer.addFilter(this.filterStorageComposite.getFilter());
        this.treeViewer.getTree().setVisible(false);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.storagePropertyForm = new StorageDataPropertyForm((Composite)this.mainComposite);
        this.storagePropertyForm.setLayoutData(new GridData(4, 4, true, true));
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.storagePropertyForm);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                if (structuredSelection.getFirstElement() instanceof StorageLeaf) {
                    StorageManagerView.this.lastSelectedLeaf = (StorageLeaf)structuredSelection.getFirstElement();
                } else if (structuredSelection.getFirstElement() instanceof LocalStorageLeaf) {
                    StorageManagerView.this.lastSelectedLocalStorageLeaf = (LocalStorageLeaf)structuredSelection.getFirstElement();
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StorageManagerView.this.updateViewToolbar();
            }
        });
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(MENU_ID, menuManager, (ISelectionProvider)this.treeViewer);
        Control control = this.treeViewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        this.mainComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                int n = ((StorageManagerView)StorageManagerView.this).mainComposite.getBounds().width;
                int n2 = ((StorageManagerView)StorageManagerView.this).mainComposite.getBounds().height;
                if (n > n2 && StorageManagerView.this.verticaLayout) {
                    StorageManagerView.this.verticaLayout = false;
                    StorageManagerView.this.mainComposite.setOrientation(256);
                } else if (n < n2 && !StorageManagerView.this.verticaLayout) {
                    StorageManagerView.this.verticaLayout = true;
                    StorageManagerView.this.mainComposite.setOrientation(512);
                }
                StorageManagerView.this.mainComposite.layout();
            }
        });
        this.updateFormBody();
        this.updateViewToolbar();
        this.mainComposite.setWeights(new int[]{2, 3});
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void createHeadClient() {
        Composite composite = new Composite(this.mainForm.getHead(), 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        new Label(composite, 0).setText("Show available:");
        this.remoteStorageSelection = new Button(composite, 16);
        this.remoteStorageSelection.setText("Online");
        this.remoteStorageSelection.setSelection(true);
        this.localStorageSelection = new Button(composite, 16);
        this.localStorageSelection.setText("Local");
        this.remoteStorageSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StorageManagerView.this.updateViewToolbar();
                StorageManagerView.this.updateFormBody();
            }
        });
        this.filterStorageComposite = new FilterStorageComposite(composite, 0);
        this.filterStorageComposite.setLayoutData(new GridData(4, 4, true, false, 3, 1));
        this.mainForm.setHeadClient((Control)composite);
    }

    private void createViewToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)new ShowPropertiesAction());
        MenuAction menuAction = new MenuAction();
        menuAction.setText("Group and Filter");
        menuAction.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/filter_ps.gif"));
        this.groupByLabelMenu = new MenuManager("Group Storages By");
        menuAction.addContributionItem((IContributionItem)this.groupByLabelMenu);
        this.filterByRepositoryMenu = new MenuManager("Filter By Repository");
        menuAction.addContributionItem((IContributionItem)this.filterByRepositoryMenu);
        this.filterByStateMenu = new MenuManager("Filter By Storage State");
        this.filterByStateMenu.add((IAction)new FilterStatesAction("Writable", StorageData.StorageState.OPENED));
        this.filterByStateMenu.add((IAction)new FilterStatesAction("Recording", StorageData.StorageState.RECORDING));
        this.filterByStateMenu.add((IAction)new FilterStatesAction("Readable", StorageData.StorageState.CLOSED));
        menuAction.addContributionItem((IContributionItem)this.filterByStateMenu);
        iToolBarManager.add((IAction)menuAction);
        iToolBarManager.add((IContributionItem)new Separator());
    }

    private void updateStorageList(IJobChangeListener iJobChangeListener) {
        Job job = new Job("Update Storages"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                StorageManagerView.this.storageRepositoryMap.clear();
                for (CmrRepositoryDefinition cmrRepositoryDefinition : StorageManagerView.this.cmrRepositoryManager.getCmrRepositoryDefinitions()) {
                    Object object;
                    boolean bl = false;
                    if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                        bl = true;
                    } else {
                        object = (CmrRepositoryDefinition.OnlineStatus)((Object)StorageManagerView.this.cachedOnlineStatus.get(cmrRepositoryDefinition));
                        if (CmrRepositoryDefinition.OnlineStatus.ONLINE.equals(object)) {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    try {
                        object = cmrRepositoryDefinition.getStorageService().getExistingStorages();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            StorageData storageData = (StorageData)iterator.next();
                            StorageManagerView.this.storageRepositoryMap.put(storageData, cmrRepositoryDefinition);
                        }
                    }
                    catch (Exception exception) {}
                }
                return Status.OK_STATUS;
            }
        };
        if (iJobChangeListener != null) {
            job.addJobChangeListener(iJobChangeListener);
        }
        job.schedule();
    }

    private void updateStorageList(final CmrRepositoryDefinition cmrRepositoryDefinition, final boolean bl, IJobChangeListener iJobChangeListener) {
        Job job = new Job("Updating Storages"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                while (StorageManagerView.this.storageRepositoryMap.values().remove(cmrRepositoryDefinition)) {
                }
                if (!bl) {
                    Object object;
                    boolean bl2 = false;
                    if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                        bl2 = true;
                    } else {
                        object = (CmrRepositoryDefinition.OnlineStatus)((Object)StorageManagerView.this.cachedOnlineStatus.get(cmrRepositoryDefinition));
                        if (CmrRepositoryDefinition.OnlineStatus.ONLINE.equals(object)) {
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        object = cmrRepositoryDefinition.getStorageService().getExistingStorages();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            StorageData storageData = (StorageData)iterator.next();
                            StorageManagerView.this.storageRepositoryMap.put(storageData, cmrRepositoryDefinition);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        if (iJobChangeListener != null) {
            job.addJobChangeListener(iJobChangeListener);
        }
        job.schedule();
    }

    private void updateDownloadedStorages() {
        this.downloadedStorages.clear();
        this.downloadedStorages.addAll(InspectIT.getDefault().getInspectITStorageManager().getDownloadedStorages());
    }

    private void updateFormBody() {
        this.clearFormBody();
        if (this.remoteStorageSelection.getSelection()) {
            if (!this.storageRepositoryMap.isEmpty()) {
                this.treeViewer.getTree().setVisible(true);
                this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
                this.treeViewer.setInput((Object)new StorageTreeModelManager(this.storageRepositoryMap, this.orderingLabelType));
                this.treeViewer.expandToLevel(-1);
                if (this.lastSelectedLeaf != null && this.storageRepositoryMap.keySet().contains(this.lastSelectedLeaf.getStorageData())) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)this.lastSelectedLeaf);
                    this.treeViewer.setSelection((ISelection)structuredSelection, true);
                }
                this.filterStorageComposite.setEnabled(true);
            } else {
                this.displayMessage("No storage information available on currently available CMR repositories.", Display.getDefault().getSystemImage(2));
                this.filterStorageComposite.setEnabled(false);
            }
        } else if (!this.downloadedStorages.isEmpty()) {
            this.treeViewer.getTree().setVisible(true);
            this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
            this.treeViewer.setInput((Object)new LocalStorageTreeModelManager(this.downloadedStorages, this.orderingLabelType));
            this.treeViewer.expandToLevel(-1);
            if (this.lastSelectedLocalStorageLeaf != null && this.downloadedStorages.contains(this.lastSelectedLocalStorageLeaf.getLocalStorageData())) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)this.lastSelectedLocalStorageLeaf);
                this.treeViewer.setSelection((ISelection)structuredSelection, true);
            }
            this.filterStorageComposite.setEnabled(true);
        } else {
            this.displayMessage("No downloaded storage is available on the local machine.", Display.getDefault().getSystemImage(2));
            this.filterStorageComposite.setEnabled(false);
        }
        this.upperComposite.layout();
    }

    private void clearFormBody() {
        if (this.cmrMessageComposite != null && !this.cmrMessageComposite.isDisposed()) {
            this.cmrMessageComposite.dispose();
        }
        this.treeViewer.setInput(Collections.emptyList());
        this.treeViewer.getTree().setVisible(false);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(16384, 128, false, false));
    }

    private void displayMessage(String string, Image image) {
        if (this.cmrMessageComposite == null || this.cmrMessageComposite.isDisposed()) {
            this.cmrMessageComposite = this.toolkit.createComposite(this.upperComposite);
        } else {
            Control[] controlArray = this.cmrMessageComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++n2;
            }
        }
        this.cmrMessageComposite.setLayout((Layout)new GridLayout(2, false));
        this.cmrMessageComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.toolkit.createLabel(this.cmrMessageComposite, null).setImage(image);
        this.toolkit.createLabel(this.cmrMessageComposite, string, 64).setLayoutData((Object)new GridData(4, 0x1000000, true, true));
    }

    private void updateViewToolbar() {
        boolean bl = this.remoteStorageSelection.getSelection();
        this.filterByRepositoryMenu.removeAll();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryManager.getCmrRepositoryDefinitions()) {
            this.filterByRepositoryMenu.add((IAction)new FilterRepositoriesAction(cmrRepositoryDefinition));
        }
        this.filterByRepositoryMenu.getParent().update(false);
        this.filterByRepositoryMenu.setVisible(bl);
        this.filterByStateMenu.setVisible(bl);
        HashSet<AbstractStorageLabelType> hashSet = new HashSet<AbstractStorageLabelType>();
        if (bl) {
            for (StorageData storageData : this.storageRepositoryMap.keySet()) {
                for (AbstractStorageLabel abstractStorageLabel : storageData.getLabelList()) {
                    hashSet.add(abstractStorageLabel.getStorageLabelType());
                }
            }
        } else {
            for (LocalStorageData localStorageData : this.downloadedStorages) {
                for (AbstractStorageLabel abstractStorageLabel : localStorageData.getLabelList()) {
                    hashSet.add(abstractStorageLabel.getStorageLabelType());
                }
            }
        }
        this.groupByLabelMenu.removeAll();
        if (bl) {
            this.groupByLabelMenu.add((IAction)new LabelOrderAction("CMR Repository", InspectIT.getDefault().getImageDescriptor("/icons/selfmade/server_online_16x16.png"), null, this.orderingLabelType == null));
        } else {
            this.groupByLabelMenu.add((IAction)new LabelOrderAction("None", InspectIT.getDefault().getImageDescriptor("/icons/eclipse/storage_download.gif"), null, this.orderingLabelType == null));
        }
        for (AbstractStorageLabelType abstractStorageLabelType : hashSet) {
            if (!abstractStorageLabelType.isGroupingEnabled()) continue;
            this.groupByLabelMenu.add((IAction)new LabelOrderAction(TextFormatter.getLabelName(abstractStorageLabelType), ImageFormatter.getImageDescriptorForLabel(abstractStorageLabelType), abstractStorageLabelType, ObjectUtils.equals((Object)abstractStorageLabelType, this.orderingLabelType)));
        }
    }

    private void performUpdate(boolean bl) {
        this.updateDownloadedStorages();
        if (bl) {
            this.updateStorageList((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            StorageManagerView.this.mainForm.setBusy(true);
                            StorageManagerView.this.updateFormBody();
                            StorageManagerView.this.updateViewToolbar();
                            StorageManagerView.this.mainForm.setBusy(false);
                            StorageManagerView.this.mainForm.layout();
                        }
                    });
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StorageManagerView.this.mainForm.setBusy(true);
                    StorageManagerView.this.updateFormBody();
                    StorageManagerView.this.updateViewToolbar();
                    StorageManagerView.this.mainForm.setBusy(false);
                    StorageManagerView.this.mainForm.layout();
                }
            });
        }
    }

    public void setFocus() {
        if (this.treeViewer.getTree().isVisible()) {
            this.treeViewer.getTree().setFocus();
        } else {
            this.mainForm.setFocus();
        }
    }

    @Override
    public void repositoryOnlineStatusUpdated(CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
        if (onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
            CmrRepositoryDefinition.OnlineStatus onlineStatus3 = this.cachedOnlineStatus.get(cmrRepositoryDefinition);
            if (onlineStatus3 == null || CmrRepositoryDefinition.OnlineStatus.OFFLINE.equals((Object)onlineStatus3) || CmrRepositoryDefinition.OnlineStatus.UNKNOWN.equals((Object)onlineStatus3)) {
                this.updateStorageList(cmrRepositoryDefinition, false, (IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                StorageManagerView.this.updateFormBody();
                            }
                        });
                    }
                });
            }
            this.cachedOnlineStatus.put(cmrRepositoryDefinition, onlineStatus2);
        } else if (onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            CmrRepositoryDefinition.OnlineStatus onlineStatus4 = this.cachedOnlineStatus.get(cmrRepositoryDefinition);
            if (onlineStatus4 == null || CmrRepositoryDefinition.OnlineStatus.ONLINE.equals((Object)onlineStatus4)) {
                this.updateStorageList(cmrRepositoryDefinition, true, (IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                StorageManagerView.this.updateFormBody();
                            }
                        });
                    }
                });
            }
            this.cachedOnlineStatus.put(cmrRepositoryDefinition, onlineStatus2);
        }
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.cachedOnlineStatus.put(cmrRepositoryDefinition, cmrRepositoryDefinition.getOnlineStatus());
        this.updateStorageList(cmrRepositoryDefinition, false, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                StorageManagerView.this.performUpdate(false);
            }
        });
    }

    @Override
    public void repositoryRemoved(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.cachedOnlineStatus.remove(cmrRepositoryDefinition);
        this.updateStorageList(cmrRepositoryDefinition, true, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                StorageManagerView.this.performUpdate(false);
            }
        });
    }

    @Override
    public void repositoryDataUpdated(CmrRepositoryDefinition cmrRepositoryDefinition) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StorageManagerView.this.updateFormBody();
                StorageManagerView.this.updateViewToolbar();
            }
        });
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
    }

    @Override
    public void refresh() {
        this.performUpdate(true);
    }

    @Override
    public boolean canRefresh() {
        return !this.storageRepositoryMap.isEmpty() || !this.cmrRepositoryManager.getCmrRepositoryDefinitions().isEmpty();
    }

    public void refresh(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.updateStorageList(cmrRepositoryDefinition, false, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                StorageManagerView.this.performUpdate(false);
            }
        });
    }

    public void setShowProperties(boolean bl) {
        if (bl) {
            StructuredSelection structuredSelection = (StructuredSelection)this.treeViewer.getSelection();
            if (!structuredSelection.isEmpty()) {
                if (structuredSelection.getFirstElement() instanceof StorageLeaf) {
                    StorageLeaf storageLeaf = (StorageLeaf)structuredSelection.getFirstElement();
                    this.storagePropertyForm = new StorageDataPropertyForm((Composite)this.mainComposite, storageLeaf);
                    this.storagePropertyForm.setLayoutData(new GridData(4, 4, true, true));
                } else if (structuredSelection.getFirstElement() instanceof LocalStorageLeaf) {
                    LocalStorageData localStorageData = ((LocalStorageLeaf)structuredSelection.getFirstElement()).getLocalStorageData();
                    this.storagePropertyForm = new StorageDataPropertyForm((Composite)this.mainComposite, null, (IStorageData)localStorageData);
                    this.storagePropertyForm.setLayoutData(new GridData(4, 4, true, true));
                } else {
                    this.storagePropertyForm = new StorageDataPropertyForm((Composite)this.mainComposite);
                    this.storagePropertyForm.setLayoutData(new GridData(4, 4, true, true));
                }
            }
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.storagePropertyForm);
            this.mainComposite.setWeights(new int[]{2, 3});
            this.mainComposite.layout();
        } else {
            if (this.storagePropertyForm != null && !this.storagePropertyForm.isDisposed()) {
                this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.storagePropertyForm);
                this.storagePropertyForm.dispose();
                this.storagePropertyForm = null;
            }
            this.mainComposite.setWeights(new int[]{1});
            this.mainComposite.layout();
        }
    }

    public void refreshWithoutCmrCall() {
        this.performUpdate(false);
    }

    @Override
    public void storageDataUpdated(IStorageData iStorageData) {
        CmrRepositoryDefinition cmrRepositoryDefinition = this.storageRepositoryMap.get(iStorageData);
        if (cmrRepositoryDefinition != null) {
            this.refresh(cmrRepositoryDefinition);
        }
    }

    @Override
    public void storageRemotelyDeleted(IStorageData iStorageData) {
        Iterator<Map.Entry<StorageData, CmrRepositoryDefinition>> iterator = this.storageRepositoryMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(iterator.next().getKey().getId(), iStorageData.getId())) continue;
            iterator.remove();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StorageManagerView.this.remoteStorageSelection.getSelection()) {
                        StorageManagerView.this.refreshWithoutCmrCall();
                    }
                }
            });
            break;
        }
    }

    @Override
    public void storageLocallyDeleted(IStorageData iStorageData) {
        Iterator<LocalStorageData> iterator = this.downloadedStorages.iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(iterator.next().getId(), iStorageData.getId())) continue;
            iterator.remove();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StorageManagerView.this.localStorageSelection.getSelection()) {
                        StorageManagerView.this.refreshWithoutCmrCall();
                    }
                }
            });
            break;
        }
    }

    public void dispose() {
        this.cmrRepositoryManager.removeCmrRepositoryChangeListener(this);
        this.storageManager.removeStorageChangeListener(this);
        super.dispose();
    }

    private class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            UIJob uIJob = new UIJob("Opening Data Explorer.."){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    DoubleClickListener.this.process();
                    return Status.OK_STATUS;
                }
            };
            uIJob.setUser(true);
            uIJob.schedule();
        }

        private void process() {
            StructuredSelection structuredSelection = (StructuredSelection)StorageManagerView.this.treeViewer.getSelection();
            if (structuredSelection.getFirstElement() instanceof IStorageDataProvider) {
                this.showStorage((IStorageDataProvider)structuredSelection.getFirstElement(), InspectIT.getDefault().getInspectITStorageManager());
            } else if (structuredSelection.getFirstElement() instanceof ILocalStorageDataProvider) {
                this.showStorage((ILocalStorageDataProvider)structuredSelection.getFirstElement(), InspectIT.getDefault().getInspectITStorageManager());
            } else {
                TreeSelection treeSelection = (TreeSelection)structuredSelection;
                TreePath treePath = treeSelection.getPaths()[0];
                if (treePath != null) {
                    boolean bl = StorageManagerView.this.treeViewer.getExpandedState((Object)treePath);
                    if (bl) {
                        StorageManagerView.this.treeViewer.collapseToLevel((Object)treePath, 1);
                    } else {
                        StorageManagerView.this.treeViewer.expandToLevel((Object)treePath, 1);
                    }
                }
            }
        }

        private void executeShowRepositoryCommand(RepositoryDefinition repositoryDefinition) {
            try {
                IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.showRepository");
                ExecutionEvent executionEvent = iHandlerService.createExecutionEvent(command, new Event());
                IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
                iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.showRepository.repository", (Object)repositoryDefinition);
                command.executeWithChecks(executionEvent);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        private void showStorage(IStorageDataProvider iStorageDataProvider, final InspectITStorageManager inspectITStorageManager) {
            block11: {
                final StorageData storageData = iStorageDataProvider.getStorageData();
                final CmrRepositoryDefinition cmrRepositoryDefinition = iStorageDataProvider.getCmrRepositoryDefinition();
                try {
                    if (inspectITStorageManager.isStorageMounted(storageData)) {
                        LocalStorageData localStorageData = inspectITStorageManager.getLocalDataForStorage(storageData);
                        StorageRepositoryDefinition storageRepositoryDefinition = inspectITStorageManager.getStorageRepositoryDefinition(localStorageData);
                        this.executeShowRepositoryCommand(storageRepositoryDefinition);
                        break block11;
                    }
                    if (storageData.getState() == StorageData.StorageState.CLOSED) {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
                                    inspectITStorageManager.mountStorage(storageData, cmrRepositoryDefinition, subMonitor);
                                    iProgressMonitor.done();
                                }
                                catch (Exception exception) {
                                    throw new InvocationTargetException(exception);
                                }
                            }
                        });
                        LocalStorageData localStorageData = inspectITStorageManager.getLocalDataForStorage(storageData);
                        StorageRepositoryDefinition storageRepositoryDefinition = inspectITStorageManager.getStorageRepositoryDefinition(localStorageData);
                        this.executeShowRepositoryCommand(storageRepositoryDefinition);
                        break block11;
                    }
                    if (storageData.getState() == StorageData.StorageState.OPENED) {
                        String string = "Storages that are in writable mode can not be explored. Do you want to finalize selected storage first and then open it?";
                        MessageDialog messageDialog = new MessageDialog(StorageManagerView.this.getSite().getShell(), "Opening Writable Storage", null, string, 3, new String[]{"Yes", "No"}, 0);
                        if (messageDialog.open() == 0) {
                            StorageManagerView.this.treeViewer.setSelection(StorageManagerView.this.treeViewer.getSelection());
                            IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                            ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                            Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.closeAndShowStorage");
                            ExecutionEvent executionEvent = iHandlerService.createExecutionEvent(command, new Event());
                            IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
                            iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.closeAndShowStorage.param", (Object)iStorageDataProvider);
                            iEvaluationContext.addVariable("activeSite", (Object)StorageManagerView.this.getSite());
                            try {
                                command.executeWithChecks(executionEvent);
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                        return;
                    }
                    if (storageData.getState() == StorageData.StorageState.RECORDING) {
                        InspectIT.getDefault().createInfoDialog("Selected storage is currently used for recording, it can not be explored.", -1);
                    }
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    InspectIT.getDefault().createErrorDialog("Exception occurred trying to mount the storage", exception, -1);
                }
                catch (SerializationException serializationException) {
                    String string = "Data in the remote storage " + storageData + " can not be read with this version of inspectIT.";
                    string = storageData.getCmrVersion() != null ? String.valueOf(string) + " Version of the CMR where storage was created is " + storageData.getCmrVersion() + "." : String.valueOf(string) + " Version of the CMR where storage was created is unknown";
                    InspectIT.getDefault().createErrorDialog(string, serializationException, -1);
                }
                catch (BusinessException | IOException throwable) {
                    InspectIT.getDefault().createErrorDialog("Exception occurred trying to display the remote storage", throwable, -1);
                }
            }
        }

        private void showStorage(ILocalStorageDataProvider iLocalStorageDataProvider, InspectITStorageManager inspectITStorageManager) {
            LocalStorageData localStorageData = iLocalStorageDataProvider.getLocalStorageData();
            try {
                if (localStorageData.isFullyDownloaded()) {
                    StorageRepositoryDefinition storageRepositoryDefinition = inspectITStorageManager.getStorageRepositoryDefinition(localStorageData);
                    this.executeShowRepositoryCommand(storageRepositoryDefinition);
                }
            }
            catch (SerializationException serializationException) {
                String string = "Data in the remote storage " + localStorageData + " can not be read with this version of inspectIT.";
                string = localStorageData.getCmrVersion() != null ? String.valueOf(string) + " Version of the CMR where storage was created is " + localStorageData.getCmrVersion() + "." : String.valueOf(string) + " Version of the CMR where storage was created is unknown";
                InspectIT.getDefault().createErrorDialog(string, serializationException, -1);
            }
            catch (BusinessException | IOException throwable) {
                InspectIT.getDefault().createErrorDialog("Exception occurred trying to display the downloaded storage", throwable, -1);
            }
        }
    }

    private class FilterRepositoriesAction
    extends Action {
        private CmrRepositoryDefinition cmrRepositoryDefinition;

        public FilterRepositoriesAction(CmrRepositoryDefinition cmrRepositoryDefinition) {
            this.cmrRepositoryDefinition = cmrRepositoryDefinition;
            this.setText(cmrRepositoryDefinition.getName());
            this.setChecked(!StorageManagerView.this.treeFilter.getFilteredRespositories().contains(cmrRepositoryDefinition));
        }

        public void run() {
            if (this.isChecked()) {
                StorageManagerView.this.treeFilter.getFilteredRespositories().remove(this.cmrRepositoryDefinition);
            } else {
                StorageManagerView.this.treeFilter.getFilteredRespositories().add(this.cmrRepositoryDefinition);
            }
            StorageManagerView.this.treeViewer.refresh();
            StorageManagerView.this.treeViewer.expandToLevel(-1);
            if (StorageManagerView.this.lastSelectedLeaf != null && StorageManagerView.this.storageRepositoryMap.keySet().contains(StorageManagerView.this.lastSelectedLeaf.getStorageData())) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)StorageManagerView.this.lastSelectedLeaf);
                StorageManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
            }
        }
    }

    private class FilterStatesAction
    extends Action {
        private StorageData.StorageState state;

        public FilterStatesAction(String string, StorageData.StorageState storageState) {
            this.state = storageState;
            this.setText(string);
            this.setChecked(!StorageManagerView.this.treeFilter.getFilteredStates().contains(storageState));
        }

        public void run() {
            if (this.isChecked()) {
                StorageManagerView.this.treeFilter.getFilteredStates().remove(this.state);
            } else {
                StorageManagerView.this.treeFilter.getFilteredStates().add(this.state);
            }
            StorageManagerView.this.treeViewer.refresh();
            StorageManagerView.this.treeViewer.expandToLevel(-1);
            if (StorageManagerView.this.lastSelectedLeaf != null && StorageManagerView.this.storageRepositoryMap.keySet().contains(StorageManagerView.this.lastSelectedLeaf.getStorageData())) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)StorageManagerView.this.lastSelectedLeaf);
                StorageManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
            }
        }
    }

    private final class FilterStorageComposite
    extends FilterComposite {
        private String filterString;
        private ViewerFilter filter;

        public FilterStorageComposite(Composite composite, int n) {
            super(composite, n, "Filter storages");
            this.filterString = "";
            this.filter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object object, Object object2) {
                    if (Objects.equals("", FilterStorageComposite.this.filterString)) {
                        return true;
                    }
                    if (object2 instanceof IStorageDataProvider) {
                        return this.select((IStorageData)((IStorageDataProvider)object2).getStorageData());
                    }
                    if (object2 instanceof ILocalStorageDataProvider) {
                        return this.select((IStorageData)((ILocalStorageDataProvider)object2).getLocalStorageData());
                    }
                    return true;
                }

                private boolean select(IStorageData iStorageData) {
                    if (StringUtils.containsIgnoreCase((String)iStorageData.getName(), (String)FilterStorageComposite.this.filterString)) {
                        return true;
                    }
                    if (StringUtils.containsIgnoreCase((String)iStorageData.getDescription(), (String)FilterStorageComposite.this.filterString)) {
                        return true;
                    }
                    for (AbstractStorageLabel abstractStorageLabel : iStorageData.getLabelList()) {
                        if (!StringUtils.containsIgnoreCase((String)TextFormatter.getLabelValue(abstractStorageLabel, false), (String)FilterStorageComposite.this.filterString)) continue;
                        return true;
                    }
                    return iStorageData instanceof StorageData && StringUtils.containsIgnoreCase((String)((StorageData)iStorageData).getState().toString(), (String)FilterStorageComposite.this.filterString);
                }
            };
            ((GridLayout)this.getLayout()).marginWidth = 0;
        }

        @Override
        protected void executeCancel() {
            this.filterString = "";
            StorageManagerView.this.treeViewer.refresh();
            StorageManagerView.this.treeViewer.expandToLevel(-1);
            if (StorageManagerView.this.remoteStorageSelection.getSelection()) {
                if (StorageManagerView.this.lastSelectedLeaf != null && StorageManagerView.this.storageRepositoryMap.keySet().contains(StorageManagerView.this.lastSelectedLeaf.getStorageData())) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)StorageManagerView.this.lastSelectedLeaf);
                    StorageManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
                }
            } else if (StorageManagerView.this.lastSelectedLocalStorageLeaf != null && StorageManagerView.this.downloadedStorages.contains(StorageManagerView.this.lastSelectedLocalStorageLeaf.getLocalStorageData())) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)StorageManagerView.this.lastSelectedLocalStorageLeaf);
                StorageManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
            }
        }

        @Override
        protected void executeFilter(String string) {
            this.filterString = string;
            StorageManagerView.this.treeViewer.refresh();
            StorageManagerView.this.treeViewer.expandToLevel(-1);
            if (StorageManagerView.this.remoteStorageSelection.getSelection()) {
                if (StorageManagerView.this.lastSelectedLeaf != null && StorageManagerView.this.storageRepositoryMap.keySet().contains(StorageManagerView.this.lastSelectedLeaf.getStorageData())) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)StorageManagerView.this.lastSelectedLeaf);
                    StorageManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
                }
            } else if (StorageManagerView.this.lastSelectedLocalStorageLeaf != null && StorageManagerView.this.downloadedStorages.contains(StorageManagerView.this.lastSelectedLocalStorageLeaf.getLocalStorageData())) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)StorageManagerView.this.lastSelectedLocalStorageLeaf);
                StorageManagerView.this.treeViewer.setSelection((ISelection)structuredSelection, true);
            }
        }

        public ViewerFilter getFilter() {
            return this.filter;
        }
    }

    private class LabelOrderAction
    extends Action {
        private AbstractStorageLabelType<?> labelType;

        public LabelOrderAction(String string, ImageDescriptor imageDescriptor, AbstractStorageLabelType<?> abstractStorageLabelType, boolean bl) {
            super(string, 8);
            this.labelType = abstractStorageLabelType;
            this.setChecked(bl);
            this.setImageDescriptor(imageDescriptor);
        }

        public void run() {
            if (this.isChecked()) {
                StorageManagerView.this.orderingLabelType = this.labelType;
                StorageManagerView.this.updateFormBody();
            }
        }
    }

    private class ShowPropertiesAction
    extends Action {
        public ShowPropertiesAction() {
            super(null, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/properties.gif"));
            this.setChecked(true);
            this.setToolTipText("Hide Properties");
        }

        public void run() {
            if (this.isChecked()) {
                StorageManagerView.this.setShowProperties(true);
                this.setToolTipText("Hide Properties");
            } else {
                StorageManagerView.this.setShowProperties(false);
                this.setToolTipText("Show Properties");
            }
        }
    }

    private static class TreeFilter
    extends ViewerFilter {
        private Set<CmrRepositoryDefinition> filteredRespositories = new HashSet<CmrRepositoryDefinition>();
        private Set<StorageData.StorageState> filteredStates = new HashSet<StorageData.StorageState>();

        private TreeFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof StorageLeaf) {
                StorageLeaf storageLeaf = (StorageLeaf)object2;
                if (this.filteredRespositories.contains(storageLeaf.getCmrRepositoryDefinition())) {
                    return false;
                }
                if (this.filteredStates.contains(storageLeaf.getStorageData().getState())) {
                    return false;
                }
            }
            return true;
        }

        public Set<CmrRepositoryDefinition> getFilteredRespositories() {
            return this.filteredRespositories;
        }

        public Set<StorageData.StorageState> getFilteredStates() {
            return this.filteredStates;
        }
    }
}

