/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.validation;

import info.novatec.inspectit.rcp.validation.IControlValidationListener;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IMessageManager;

public abstract class ValidationControlDecoration<T extends Control> {
    private final T control;
    private IMessageManager messageManager;
    private ControlDecoration controlDecoration;
    private String descriptionText;
    private final Color controlBackground;
    private final Color nonValidBackground;
    private boolean valid = true;
    private boolean alterControlBackround = true;
    private Collection<IControlValidationListener> validationListeners = new HashSet<IControlValidationListener>();
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            ValidationControlDecoration.this.executeValidation();
        }
    };

    public ValidationControlDecoration(T t, IMessageManager iMessageManager) {
        this(t, iMessageManager, true);
    }

    public ValidationControlDecoration(T t, IControlValidationListener iControlValidationListener) {
        this(t, (IMessageManager)null);
        this.addControlValidationListener(iControlValidationListener);
    }

    public ValidationControlDecoration(T t, IMessageManager iMessageManager, boolean bl) {
        this.control = t;
        this.messageManager = iMessageManager;
        this.alterControlBackround = bl;
        this.controlBackground = t.getBackground();
        this.nonValidBackground = new Color((Device)t.getDisplay(), 255, 200, 200);
        if (iMessageManager == null) {
            this.controlDecoration = new ControlDecoration(t, 17408);
            this.controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        }
        this.startupValidation();
    }

    public ValidationControlDecoration(T t, IMessageManager iMessageManager, IControlValidationListener iControlValidationListener) {
        this(t, iMessageManager);
        this.addControlValidationListener(iControlValidationListener);
    }

    public ValidationControlDecoration(T t, IMessageManager iMessageManager, boolean bl, IControlValidationListener iControlValidationListener) {
        this(t, iMessageManager, bl);
        this.addControlValidationListener(iControlValidationListener);
    }

    protected final void startupValidation() {
        boolean bl = this.valid = !this.controlActive() || this.validate(this.control);
        if (this.valid) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected abstract boolean validate(T var1);

    public void executeValidation() {
        boolean bl = this.valid;
        this.valid = this.controlActive() ? this.validate(this.control) : true;
        if (bl != this.valid) {
            if (this.valid) {
                this.hide();
            } else {
                this.show();
            }
            for (IControlValidationListener iControlValidationListener : this.validationListeners) {
                iControlValidationListener.validationStateChanged(this.valid, this);
            }
        }
    }

    private void show() {
        if (this.controlDecoration != null) {
            this.controlDecoration.show();
        } else if (this.messageManager != null) {
            this.messageManager.addMessage((Object)this, this.descriptionText, null, 3, this.control);
        }
        if (this.alterControlBackround) {
            this.control.setBackground(this.nonValidBackground);
        }
    }

    private void hide() {
        if (this.controlDecoration != null) {
            this.controlDecoration.hide();
        } else if (this.messageManager != null) {
            this.messageManager.removeMessage((Object)this, this.control);
        }
        if (this.alterControlBackround) {
            this.control.setBackground(this.controlBackground);
        }
    }

    public void registerListener(int n) {
        this.registerListener((Control)this.control, n);
    }

    public void registerListener(Control control, int n) {
        Assert.isNotNull((Object)control);
        control.addListener(n, this.listener);
    }

    public void addControlValidationListener(IControlValidationListener iControlValidationListener) {
        if (iControlValidationListener != null) {
            this.validationListeners.add(iControlValidationListener);
        }
    }

    private boolean controlActive() {
        return this.control.isEnabled();
    }

    public boolean isValid() {
        return this.valid;
    }

    public T getControl() {
        return this.control;
    }

    public String getDescriptionText() {
        return this.descriptionText;
    }

    public void setDescriptionText(String string) {
        this.descriptionText = string;
        if (this.controlDecoration != null) {
            this.controlDecoration.setDescriptionText(string);
        }
    }

    public void dispose() {
        this.nonValidBackground.dispose();
        if (this.controlDecoration != null) {
            this.controlDecoration.dispose();
        }
    }
}

