/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.util.data;

import info.novatec.inspectit.communication.data.SqlStatementData;
import org.apache.commons.lang.StringUtils;

public class DatabaseInfoHelper {
    private String databaseUrl;
    private String databaseProductName;
    private String databaseProductVersion;

    public DatabaseInfoHelper(SqlStatementData sqlStatementData) {
        this.databaseProductName = sqlStatementData.getDatabaseProductName();
        this.databaseProductVersion = sqlStatementData.getDatabaseProductVersion();
        this.databaseUrl = sqlStatementData.getDatabaseUrl();
    }

    public String getDatabaseUrl() {
        if (StringUtils.isNotBlank((String)this.databaseUrl)) {
            return this.databaseUrl;
        }
        return "Unknown";
    }

    public String getLongText() {
        if (StringUtils.isNotEmpty((String)this.databaseProductName)) {
            StringBuilder stringBuilder = new StringBuilder(this.databaseProductName);
            if (StringUtils.isNotEmpty((String)this.databaseProductVersion)) {
                stringBuilder.append(" v. ");
                stringBuilder.append(this.databaseProductVersion);
            }
            if (StringUtils.isNotEmpty((String)this.databaseUrl)) {
                stringBuilder.append(" (URL: ");
                stringBuilder.append(this.databaseUrl);
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.databaseProductName == null ? 0 : this.databaseProductName.hashCode());
        n = 31 * n + (this.databaseProductVersion == null ? 0 : this.databaseProductVersion.hashCode());
        n = 31 * n + (this.databaseUrl == null ? 0 : this.databaseUrl.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DatabaseInfoHelper databaseInfoHelper = (DatabaseInfoHelper)object;
        if (this.databaseProductName == null ? databaseInfoHelper.databaseProductName != null : !this.databaseProductName.equals(databaseInfoHelper.databaseProductName)) {
            return false;
        }
        if (this.databaseProductVersion == null ? databaseInfoHelper.databaseProductVersion != null : !this.databaseProductVersion.equals(databaseInfoHelper.databaseProductVersion)) {
            return false;
        }
        return !(this.databaseUrl == null ? databaseInfoHelper.databaseUrl != null : !this.databaseUrl.equals(databaseInfoHelper.databaseUrl));
    }
}

