/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ListenerList<E>
implements Iterable<E> {
    private final E[] emptyArray = new Object[0];
    private final boolean identity;
    private volatile E[] listeners = this.emptyArray;

    public ListenerList() {
        this(Mode.EQUALITY);
    }

    public ListenerList(Mode mode) {
        this.identity = Mode.IDENTITY.equals((Object)mode);
    }

    public synchronized void add(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            E e2 = this.listeners[n2];
            if (this.identity ? e == e2 : e.equals(e2)) {
                return;
            }
            ++n2;
        }
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.listeners, 0, objectArray, 0, n);
        objectArray[n] = e;
        this.listeners = objectArray;
    }

    public E[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            E e2 = this.listeners[n2];
            if (this.identity ? e == e2 : e.equals(e2)) {
                if (n == 1) {
                    this.listeners = this.emptyArray;
                } else {
                    Object[] objectArray = new Object[n - 1];
                    System.arraycopy(this.listeners, 0, objectArray, 0, n2);
                    System.arraycopy(this.listeners, n2 + 1, objectArray, n2, n - n2 - 1);
                    this.listeners = objectArray;
                }
                return;
            }
            ++n2;
        }
    }

    public int size() {
        return this.listeners.length;
    }

    public synchronized void clear() {
        this.listeners = this.emptyArray;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.listeners);
    }

    private class Itr
    implements Iterator<E> {
        private int cursor = 0;
        private E[] listeners;

        public Itr(E[] EArray) {
            this.listeners = EArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.listeners.length;
        }

        @Override
        public E next() {
            try {
                Object e = this.listeners[this.cursor];
                ++this.cursor;
                return e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Mode {
        EQUALITY,
        IDENTITY;

    }
}

