/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class AccessibleArrowImage
extends CompositeImageDescriptor {
    private static final int ARROW_SIZE = 5;
    private final boolean fLTR;

    public AccessibleArrowImage(boolean bl) {
        this.fLTR = bl;
    }

    protected void drawCompositeImage(int n, int n2) {
        int n3;
        Display display = Display.getDefault();
        Image image = new Image((Device)display, 5, 10);
        GC gC = new GC((Drawable)image);
        Color color = this.createColor(24, 25, 20, display);
        Color color2 = this.createColor(24, 25, 30, display);
        gC.setBackground(color);
        if (this.fLTR) {
            int[] nArray = new int[6];
            nArray[0] = this.mirror(0);
            nArray[2] = this.mirror(5);
            nArray[3] = 5;
            nArray[4] = this.mirror(0);
            nArray[5] = 10;
            gC.fillPolygon(nArray);
        } else {
            int[] nArray = new int[6];
            nArray[0] = 5;
            nArray[3] = 5;
            nArray[4] = 5;
            nArray[5] = 10;
            gC.fillPolygon(nArray);
        }
        gC.setForeground(color2);
        gC.drawLine(this.mirror(0), 1, this.mirror(4), 5);
        gC.drawLine(this.mirror(4), 5, this.mirror(0), 9);
        gC.dispose();
        color.dispose();
        color2.dispose();
        ImageData imageData = image.getImageData();
        int n4 = 1;
        while (n4 < 5) {
            n3 = 0;
            while (n3 < n4) {
                imageData.setAlpha(this.mirror(n3), n4, 255);
                ++n3;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < 5) {
            n3 = 0;
            while (n3 <= n4) {
                imageData.setAlpha(this.mirror(n3), 10 - n4 - 1, 255);
                ++n3;
            }
            ++n4;
        }
        n4 = 0;
        if (!this.fLTR) {
            n4 = -1;
        }
        this.drawImage(imageData, n / 2 - 2 + n4, n2 / 2 - 5 - 1);
        image.dispose();
    }

    private int mirror(int n) {
        if (this.fLTR) {
            return n;
        }
        return 5 - n - 1;
    }

    protected Point getSize() {
        return new Point(10, 16);
    }

    private Color createColor(int n, int n2, int n3, Display display) {
        RGB rGB = display.getSystemColor(n).getRGB();
        RGB rGB2 = display.getSystemColor(n2).getRGB();
        RGB rGB3 = FormColors.blend((RGB)rGB2, (RGB)rGB, (int)n3);
        return new Color((Device)display, rGB3);
    }
}

