/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.storage.http;

import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.progress.UIJob;

public class TransferDataMonitor {
    private static final long DISPLAY_MESSAGE_RATE = 1000L;
    private static final double GZIP_FILE_SIZE_RATIO = 0.15;
    private static final long MIN_GZIP_FILE_SIZE = 0x100000L;
    private long totalBytesTransfered;
    private long downloadStartTime;
    private SubMonitor subMonitor;
    private Map<String, Long> files;
    private boolean gzipCompression;
    private int filesCount = 0;
    private long totalSize;
    private long finishedFilesSize;
    private long currentFileSize;
    private long currentFileReal;
    private DisplayMessageJob displayMessageJob = new DisplayMessageJob();

    public TransferDataMonitor(SubMonitor subMonitor, Map<String, Long> map) {
        this(subMonitor, map, false);
    }

    public TransferDataMonitor(SubMonitor subMonitor, Map<String, Long> map, boolean bl) {
        this.subMonitor = subMonitor;
        this.files = map;
        this.gzipCompression = bl;
        this.totalSize = 0L;
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            this.totalSize += this.getFileSize(entry.getValue());
        }
        subMonitor.setWorkRemaining((int)this.totalSize);
        this.displayMessageJob.schedule();
    }

    public void startTransfer(String string) {
        if (this.filesCount == 0) {
            this.downloadStartTime = System.currentTimeMillis();
        }
        this.currentFileReal = 0L;
        this.currentFileSize = this.getFileSize(this.files.get(string));
    }

    public void endTransfer(String string) {
        ++this.filesCount;
        long l = this.currentFileSize - this.currentFileReal;
        if (l > 0L) {
            this.subMonitor.worked((int)l);
        }
        long l2 = this.files.get(string);
        this.finishedFilesSize += this.getFileSize(l2);
        if (this.files.size() == this.filesCount) {
            this.displayMessageJob.cancel();
            this.subMonitor.subTask("");
            this.subMonitor.done();
        }
    }

    public void addSample(long l) {
        this.totalBytesTransfered += l;
        long l2 = this.currentFileSize - this.currentFileReal;
        if (l2 > 0L) {
            l2 = Math.min(l2, l);
            this.subMonitor.worked((int)l2);
        }
        this.currentFileReal += l;
    }

    private void displayMessageOnMonitor() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File ");
        stringBuilder.append(this.filesCount + 1);
        stringBuilder.append('/');
        stringBuilder.append(this.files.size());
        stringBuilder.append(" (");
        stringBuilder.append(NumberFormatter.humanReadableByteCount(this.totalBytesTransfered));
        if (!this.gzipCompression) {
            stringBuilder.append(" out of ");
            stringBuilder.append(NumberFormatter.humanReadableByteCount(this.totalSize));
        }
        stringBuilder.append(" @ ");
        stringBuilder.append(NumberFormatter.humanReadableByteCount((long)this.getAverageTransferRate()));
        stringBuilder.append("/s) Remaining time: ");
        if (this.gzipCompression) {
            stringBuilder.append("app. ");
        }
        long l = this.totalSize - this.finishedFilesSize;
        l = this.currentFileReal < this.currentFileSize ? (l -= this.currentFileReal) : (l -= this.currentFileSize);
        long l2 = this.getMillisLeft(l);
        l2 += l2 % 1000L;
        stringBuilder.append(NumberFormatter.humanReadableMillisCount(l2, true));
        this.subMonitor.subTask(stringBuilder.toString());
    }

    private double getAverageTransferRate() {
        return (double)this.totalBytesTransfered / ((double)(System.currentTimeMillis() - this.downloadStartTime) / 1000.0);
    }

    private long getMillisLeft(long l) {
        return (long)((double)l * 1000.0 / this.getAverageTransferRate());
    }

    private long getFileSize(long l) {
        if (this.gzipCompression && l > 0x100000L) {
            return (long)((double)l * 0.15);
        }
        return l;
    }

    private class DisplayMessageJob
    extends UIJob {
        public DisplayMessageJob() {
            super("Display Message");
            this.setUser(false);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            TransferDataMonitor.this.displayMessageOnMonitor();
            if (!iProgressMonitor.isCanceled()) {
                this.schedule(1000L);
            }
            return Status.OK_STATUS;
        }
    }
}

