/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.storage;

import info.novatec.inspectit.cmr.service.IJmxDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.indexing.query.provider.impl.StorageIndexQueryProvider;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.rcp.repository.service.storage.AbstractStorageService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class StorageJmxDataAccessService
extends AbstractStorageService<JmxSensorValueData>
implements IJmxDataAccessService {
    private IStorageTreeComponent<JmxSensorValueData> indexingTree;
    private StorageIndexQueryProvider storageIndexQueryProvider;

    private List<JmxSensorValueData> queryJmxData(JmxSensorValueData jmxSensorValueData, Date date, Date date2, boolean bl) {
        StorageIndexQuery storageIndexQuery = this.storageIndexQueryProvider.createNewStorageIndexQuery();
        storageIndexQuery.setObjectClasses(Arrays.asList(JmxSensorValueData.class));
        if (jmxSensorValueData.getPlatformIdent() > 0L) {
            storageIndexQuery.setPlatformIdent(jmxSensorValueData.getPlatformIdent());
        }
        if (jmxSensorValueData.getSensorTypeIdent() > 0L) {
            storageIndexQuery.setSensorTypeIdent(jmxSensorValueData.getSensorTypeIdent());
        }
        if (date != null) {
            storageIndexQuery.setFromDate(new Timestamp(date.getTime()));
        }
        if (date2 != null) {
            storageIndexQuery.setToDate(new Timestamp(date2.getTime()));
        }
        if (jmxSensorValueData.getJmxSensorDefinitionDataIdentId() > 0L) {
            storageIndexQuery.addIndexingRestriction(IndexQueryRestrictionFactory.equal((String)"jmxSensorDefinitionDataIdentId", (Object)jmxSensorValueData.getJmxSensorDefinitionDataIdentId()));
        }
        List<JmxSensorValueData> list = this.executeQuery(storageIndexQuery);
        if (bl) {
            HashMap<Long, JmxSensorValueData> hashMap = new HashMap<Long, JmxSensorValueData>();
            for (DefaultData defaultData : list) {
                JmxSensorValueData jmxSensorValueData2 = (JmxSensorValueData)defaultData;
                if (hashMap.containsKey(jmxSensorValueData2.getJmxSensorDefinitionDataIdentId())) {
                    if (((JmxSensorValueData)hashMap.get(jmxSensorValueData2.getJmxSensorDefinitionDataIdentId())).getTimeStamp().getTime() >= defaultData.getTimeStamp().getTime()) continue;
                    hashMap.put(jmxSensorValueData2.getJmxSensorDefinitionDataIdentId(), (JmxSensorValueData)defaultData);
                    continue;
                }
                hashMap.put(jmxSensorValueData2.getJmxSensorDefinitionDataIdentId(), (JmxSensorValueData)defaultData);
            }
            return new ArrayList<JmxSensorValueData>(hashMap.values());
        }
        return list;
    }

    @Override
    protected IStorageTreeComponent<JmxSensorValueData> getIndexingTree() {
        return this.indexingTree;
    }

    public List<JmxSensorValueData> getJmxDataOverview(JmxSensorValueData jmxSensorValueData) {
        return this.queryJmxData(jmxSensorValueData, new Date(0L), new Date(), true);
    }

    public List<JmxSensorValueData> getJmxDataOverview(JmxSensorValueData jmxSensorValueData, Date date, Date date2) {
        if (date.after(date2)) {
            return Collections.emptyList();
        }
        return this.queryJmxData(jmxSensorValueData, date, date2, true);
    }

    public void setIndexingTree(IStorageTreeComponent<JmxSensorValueData> iStorageTreeComponent) {
        this.indexingTree = iStorageTreeComponent;
    }

    public void setStorageIndexQueryProvider(StorageIndexQueryProvider storageIndexQueryProvider) {
        this.storageIndexQueryProvider = storageIndexQueryProvider;
    }
}

