/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.storage;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.AgentManagementErrorCodeEnum;
import info.novatec.inspectit.indexing.query.provider.impl.StorageIndexQueryProvider;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.rcp.repository.service.storage.AbstractStorageService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class StorageGlobalDataAccessService
extends AbstractStorageService<DefaultData>
implements IGlobalDataAccessService {
    private List<PlatformIdent> agents;
    private IStorageTreeComponent<DefaultData> indexingTree;
    private StorageIndexQueryProvider storageIndexQueryProvider;

    public Map<PlatformIdent, AgentStatusData> getAgentsOverview() {
        HashMap<PlatformIdent, AgentStatusData> hashMap = new HashMap<PlatformIdent, AgentStatusData>();
        for (PlatformIdent platformIdent : this.agents) {
            hashMap.put(platformIdent, null);
        }
        return hashMap;
    }

    public PlatformIdent getCompleteAgent(long l) throws BusinessException {
        for (PlatformIdent platformIdent : this.agents) {
            if (platformIdent.getId() != l) continue;
            return platformIdent;
        }
        throw new BusinessException("Load the agent with the ID=" + l + ".", (IErrorCode)AgentManagementErrorCodeEnum.AGENT_DOES_NOT_EXIST);
    }

    public void deleteAgent(long l) throws BusinessException {
    }

    public List<DefaultData> getLastDataObjects(DefaultData defaultData, long l) {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        Timestamp timestamp2 = new Timestamp(timestamp.getTime() - l);
        return this.getDataObjectsInInterval(defaultData, timestamp2, timestamp);
    }

    public DefaultData getLastDataObject(DefaultData defaultData) {
        StorageIndexQuery storageIndexQuery = this.storageIndexQueryProvider.createNewStorageIndexQuery();
        storageIndexQuery.setMinId(defaultData.getId());
        ArrayList arrayList = new ArrayList();
        arrayList.add(defaultData.getClass());
        storageIndexQuery.setObjectClasses(arrayList);
        storageIndexQuery.setPlatformIdent(defaultData.getPlatformIdent());
        storageIndexQuery.setSensorTypeIdent(defaultData.getSensorTypeIdent());
        List list = super.executeQuery(storageIndexQuery);
        if (CollectionUtils.isNotEmpty(list)) {
            Iterator iterator = list.iterator();
            DefaultData defaultData2 = (DefaultData)iterator.next();
            while (iterator.hasNext()) {
                DefaultData defaultData3 = (DefaultData)iterator.next();
                if (!defaultData3.getTimeStamp().after(defaultData2.getTimeStamp())) continue;
                defaultData2 = defaultData3;
            }
            return defaultData2;
        }
        return null;
    }

    public List<DefaultData> getDataObjectsSinceId(DefaultData defaultData) {
        StorageIndexQuery storageIndexQuery = this.storageIndexQueryProvider.createNewStorageIndexQuery();
        storageIndexQuery.setMinId(defaultData.getId());
        ArrayList arrayList = new ArrayList();
        arrayList.add(defaultData.getClass());
        storageIndexQuery.setObjectClasses(arrayList);
        storageIndexQuery.setPlatformIdent(defaultData.getPlatformIdent());
        storageIndexQuery.setSensorTypeIdent(defaultData.getSensorTypeIdent());
        if (defaultData instanceof MethodSensorData) {
            storageIndexQuery.setMethodIdent(((MethodSensorData)defaultData).getMethodIdent());
            if (defaultData instanceof InvocationSequenceData) {
                storageIndexQuery.setOnlyInvocationsWithoutChildren(true);
            }
        }
        return super.executeQuery(storageIndexQuery);
    }

    public List<DefaultData> getDataObjectsSinceIdIgnoreMethodId(DefaultData defaultData) {
        StorageIndexQuery storageIndexQuery = this.storageIndexQueryProvider.createNewStorageIndexQuery();
        storageIndexQuery.setMinId(defaultData.getId());
        ArrayList arrayList = new ArrayList();
        arrayList.add(defaultData.getClass());
        storageIndexQuery.setObjectClasses(arrayList);
        storageIndexQuery.setPlatformIdent(defaultData.getPlatformIdent());
        return super.executeQuery(storageIndexQuery);
    }

    public List<? extends DefaultData> getDataObjectsFromToDate(DefaultData defaultData, Date date, Date date2) {
        if (date.after(date2)) {
            return Collections.emptyList();
        }
        return this.getDataObjectsInInterval(defaultData, new Timestamp(date.getTime()), new Timestamp(date2.getTime()));
    }

    public List<? extends DefaultData> getTemplatesDataObjectsFromToDate(Collection<DefaultData> collection, Date date, Date date2) {
        if (date.after(date2)) {
            return Collections.emptyList();
        }
        ArrayList<? extends DefaultData> arrayList = new ArrayList<DefaultData>();
        for (DefaultData defaultData : collection) {
            arrayList.addAll(this.getDataObjectsFromToDate(defaultData, date, date2));
        }
        return arrayList;
    }

    private List<DefaultData> getDataObjectsInInterval(DefaultData defaultData, Timestamp timestamp, Timestamp timestamp2) {
        StorageIndexQuery storageIndexQuery = this.storageIndexQueryProvider.createNewStorageIndexQuery();
        ArrayList arrayList = new ArrayList();
        arrayList.add(defaultData.getClass());
        storageIndexQuery.setObjectClasses(arrayList);
        storageIndexQuery.setPlatformIdent(defaultData.getPlatformIdent());
        storageIndexQuery.setSensorTypeIdent(defaultData.getSensorTypeIdent());
        storageIndexQuery.setToDate(timestamp2);
        storageIndexQuery.setFromDate(timestamp);
        if (defaultData instanceof MethodSensorData) {
            storageIndexQuery.setMethodIdent(((MethodSensorData)defaultData).getMethodIdent());
            if (defaultData instanceof InvocationSequenceData) {
                storageIndexQuery.setOnlyInvocationsWithoutChildren(true);
            }
        }
        if (defaultData instanceof JmxSensorValueData) {
            storageIndexQuery.addIndexingRestriction(IndexQueryRestrictionFactory.equal((String)"jmxSensorDefinitionDataIdentId", (Object)((JmxSensorValueData)defaultData).getJmxSensorDefinitionDataIdentId()));
        }
        List<DefaultData> list = super.executeQuery(storageIndexQuery);
        Collections.sort(list, new Comparator<DefaultData>(){

            @Override
            public int compare(DefaultData defaultData, DefaultData defaultData2) {
                return defaultData.getTimeStamp().compareTo(defaultData2.getTimeStamp());
            }
        });
        return list;
    }

    public void setAgents(List<PlatformIdent> list) {
        this.agents = list;
    }

    @Override
    protected IStorageTreeComponent<DefaultData> getIndexingTree() {
        return this.indexingTree;
    }

    public void setIndexingTree(IStorageTreeComponent<DefaultData> iStorageTreeComponent) {
        this.indexingTree = iStorageTreeComponent;
    }

    public void setStorageIndexQueryProvider(StorageIndexQueryProvider storageIndexQueryProvider) {
        this.storageIndexQueryProvider = storageIndexQueryProvider;
    }
}

