/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.cmr.proxy;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.service.cmr.proxy.InterceptorUtils;
import java.net.ConnectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.RemoteConnectFailureException;

public class ServiceMethodInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        try {
            Object object = methodInvocation.proceed();
            CmrRepositoryDefinition cmrRepositoryDefinition = InterceptorUtils.getRepositoryDefinition(methodInvocation);
            if (cmrRepositoryDefinition != null && InterceptorUtils.isServiceMethod(methodInvocation)) {
                if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    InspectIT.getDefault().getCmrRepositoryManager().forceCmrRepositoryOnlineStatusUpdate(cmrRepositoryDefinition);
                }
            } else if (cmrRepositoryDefinition == null) {
                throw new RuntimeException("Service proxy not bounded to the CMR repository definition");
            }
            return object;
        }
        catch (ConnectException | RemoteConnectFailureException throwable) {
            this.handleConnectionFailure(methodInvocation, throwable);
            if (InterceptorUtils.isReturnDefaultReturnValue(methodInvocation)) {
                return InterceptorUtils.getDefaultReturnValue(methodInvocation);
            }
            throw throwable;
        }
    }

    private void handleConnectionFailure(MethodInvocation methodInvocation, Throwable throwable) {
        CmrRepositoryDefinition cmrRepositoryDefinition = InterceptorUtils.getRepositoryDefinition(methodInvocation);
        if (cmrRepositoryDefinition != null) {
            if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                InspectIT.getDefault().getCmrRepositoryManager().forceCmrRepositoryOnlineStatusUpdate(cmrRepositoryDefinition);
                InspectIT.getDefault().log(2, "The server: '" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort() + "' is currently unavailable.");
            }
        } else {
            throw new RuntimeException("Service proxy not bounded to the CMR repository definition", throwable);
        }
    }
}

