/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.property.control.impl;

import info.novatec.inspectit.cmr.property.configuration.impl.StringProperty;
import info.novatec.inspectit.rcp.property.IPropertyUpdateListener;
import info.novatec.inspectit.rcp.property.control.AbstractPropertyControl;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class StringPropertyControl
extends AbstractPropertyControl<StringProperty, String> {
    private Text text;

    public StringPropertyControl(StringProperty stringProperty, IPropertyUpdateListener iPropertyUpdateListener) {
        super(stringProperty, iPropertyUpdateListener);
    }

    @Override
    public Control createControl(Composite composite) {
        this.text = new Text(composite, 2048);
        this.text.setText((String)((StringProperty)this.property).getValue());
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = StringPropertyControl.this.text.getText();
                if (!string.isEmpty()) {
                    StringPropertyControl.this.sendPropertyUpdateEvent(string);
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = StringPropertyControl.this.text.getText();
                if (string.isEmpty()) {
                    StringPropertyControl.this.text.setText((String)StringPropertyControl.this.getLastCorrectValue());
                }
            }
        });
        return this.text;
    }

    @Override
    protected void showDefaultValue() {
        this.text.setText(((StringProperty)this.property).getDefaultValue());
    }
}

