/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.property.control.impl;

import info.novatec.inspectit.cmr.property.configuration.impl.ByteProperty;
import info.novatec.inspectit.rcp.property.IPropertyUpdateListener;
import info.novatec.inspectit.rcp.property.control.AbstractPropertyControl;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BytePropertyControl
extends AbstractPropertyControl<ByteProperty, Long> {
    private Combo unitCombo;
    private Text valueText;
    private boolean modifyMarker;

    public BytePropertyControl(ByteProperty byteProperty, IPropertyUpdateListener iPropertyUpdateListener) {
        super(byteProperty, iPropertyUpdateListener);
    }

    @Override
    protected Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.valueText = new Text(composite2, 133120);
        this.valueText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.valueText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                String string = BytePropertyControl.this.valueText.getText();
                String string2 = verifyEvent.text;
                String string3 = String.valueOf(string.substring(0, verifyEvent.start)) + string2 + string.substring(verifyEvent.end, string.length());
                if (StringUtils.isNotBlank((String)string3)) {
                    try {
                        Double.parseDouble(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        verifyEvent.doit = false;
                        return;
                    }
                }
            }
        });
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!BytePropertyControl.this.modifyMarker) {
                    String string = BytePropertyControl.this.valueText.getText();
                    if (!(string.isEmpty() || string.charAt(0) == '-' && string.length() <= 1)) {
                        long l = BytePropertyControl.this.getCurrentSize();
                        BytePropertyControl.this.sendPropertyUpdateEvent(l);
                    }
                } else {
                    BytePropertyControl.this.modifyMarker = false;
                }
            }
        });
        this.valueText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = BytePropertyControl.this.valueText.getText();
                if (string.isEmpty()) {
                    BytePropertyControl.this.displayValue((Long)BytePropertyControl.this.getLastCorrectValue());
                }
            }
        });
        this.unitCombo = new Combo(composite2, 2048);
        this.unitCombo.setItems(new String[]{"B", "KB", "MB", "GB"});
        GridData gridData = new GridData(131072, 4, false, false);
        gridData.widthHint = 60;
        this.unitCombo.setLayoutData((Object)gridData);
        this.unitCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                long l = (Long)BytePropertyControl.this.getLastCorrectValue();
                int n = BytePropertyControl.this.unitCombo.getSelectionIndex();
                BytePropertyControl.this.displayValue(l, n);
            }
        });
        this.displayValue((Long)((ByteProperty)this.property).getValue());
        return composite2;
    }

    @Override
    protected void showDefaultValue() {
        this.displayValue(((ByteProperty)this.property).getDefaultValue());
    }

    private long getCurrentSize() {
        return (long)(Double.parseDouble(this.valueText.getText()) * Math.pow(1024.0, this.unitCombo.getSelectionIndex()));
    }

    private void displayValue(long l) {
        int n = this.getUnit(l);
        this.unitCombo.select(n);
        this.displayValue(l, n);
    }

    private void displayValue(long l, int n) {
        int n2 = 1024;
        double d = (double)l / Math.pow(n2, n);
        this.modifyMarker = true;
        this.valueText.setText(String.format(Locale.ENGLISH, "%.2f", d));
    }

    private int getUnit(long l) {
        int n;
        if ((l = Math.abs(l)) < (long)(n = 1024)) {
            return 0;
        }
        int n2 = (int)(Math.log(l) / Math.log(n));
        if (n2 < 4) {
            return n2;
        }
        return 3;
    }
}

