/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.property;

import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.ValidationError;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import info.novatec.inspectit.rcp.property.IPropertyUpdateListener;
import info.novatec.inspectit.rcp.property.control.AbstractPropertyControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;

public class PropertyPreferencePage
extends PreferencePage
implements IPropertyUpdateListener {
    private static final Comparator<SingleProperty<?>> PROPERTIES_COMPARATOR = new Comparator<SingleProperty<?>>(){

        @Override
        public int compare(SingleProperty<?> singleProperty, SingleProperty<?> singleProperty2) {
            if (singleProperty.isAdvanced() && !singleProperty2.isAdvanced()) {
                return 1;
            }
            if (singleProperty.isAdvanced() && !singleProperty2.isAdvanced()) {
                return -1;
            }
            return 0;
        }
    };
    private List<SingleProperty<?>> properties;
    private Collection<AbstractPropertyControl<?, ?>> propertyControls = new ArrayList();
    protected Map<SingleProperty<?>, IPropertyUpdate<?>> correctUpdateMap = new HashMap();
    private Map<SingleProperty<?>, PropertyValidation> validationMap = new HashMap();
    private boolean allAdvancedProperties = true;
    private boolean advancedVisible;
    private Button restoreDefaults;
    private Composite mainComposite;
    private FormText advancedText;

    public PropertyPreferencePage(String string, Collection<SingleProperty<?>> collection) {
        super(string);
        this.properties = new ArrayList(collection);
        this.noDefaultAndApplyButton();
        for (SingleProperty<?> singleProperty : this.properties) {
            if (singleProperty.isAdvanced()) continue;
            this.allAdvancedProperties = false;
        }
        Collections.sort(this.properties, PROPERTIES_COMPARATOR);
    }

    @Override
    public void propertyUpdated(SingleProperty<?> singleProperty, IPropertyUpdate<?> iPropertyUpdate) {
        this.validationMap.remove(singleProperty);
        if (!iPropertyUpdate.isRestoreDefault() || !singleProperty.isDefaultValueUsed()) {
            this.correctUpdateMap.put(singleProperty, iPropertyUpdate);
        } else {
            this.correctUpdateMap.remove(singleProperty);
        }
        this.updatePage();
    }

    @Override
    public void propertyUpdateCanceled(SingleProperty<?> singleProperty) {
        this.validationMap.remove(singleProperty);
        this.correctUpdateMap.remove(singleProperty);
        this.updatePage();
    }

    @Override
    public void propertyValidationFailed(SingleProperty<?> singleProperty, PropertyValidation propertyValidation) {
        if (propertyValidation.hasErrors()) {
            this.validationMap.put(singleProperty, propertyValidation);
            this.correctUpdateMap.remove(singleProperty);
        }
        this.updatePage();
    }

    public boolean isValid() {
        return this.getValidationErrorsCount() == 0;
    }

    public Collection<IPropertyUpdate<?>> getPropertyUpdates() {
        if (this.isValid()) {
            return this.correctUpdateMap.values();
        }
        return Collections.emptySet();
    }

    public boolean isServerRestartRequired() {
        if (this.isValid()) {
            for (SingleProperty<?> singleProperty : this.correctUpdateMap.keySet()) {
                if (!singleProperty.isServerRestartRequired()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void updatePage() {
        this.setValid(this.isValid());
        this.updateMessage();
        this.updateValidationMessages();
    }

    public int getValidationErrorsCount() {
        if (MapUtils.isEmpty(this.validationMap)) {
            return 0;
        }
        int n = 0;
        for (PropertyValidation propertyValidation : this.validationMap.values()) {
            n += propertyValidation.getErrorCount();
        }
        return n;
    }

    public Collection<ValidationError> getValidationErrors() {
        if (MapUtils.isEmpty(this.validationMap)) {
            return Collections.emptyList();
        }
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        for (PropertyValidation propertyValidation : this.validationMap.values()) {
            arrayList.addAll(propertyValidation.getErrors());
        }
        return arrayList;
    }

    public void showAdvanced(boolean bl) {
        this.advancedVisible = bl;
        if (this.advancedText != null) {
            this.advancedText.setVisible(bl);
        }
        if (CollectionUtils.isNotEmpty(this.propertyControls)) {
            for (AbstractPropertyControl<?, ?> abstractPropertyControl : this.propertyControls) {
                abstractPropertyControl.showIfAdvanced(bl);
            }
            this.mainComposite.layout();
            this.mainComposite.update();
            if (this.allAdvancedProperties && !this.advancedVisible) {
                this.setMessage("This page contains only advanced properties.", 1);
            } else {
                this.updateMessage();
            }
        }
    }

    private void updateMessage() {
        int n = this.getValidationErrorsCount();
        if (n == 0) {
            this.setMessage(null);
        } else {
            String string = String.valueOf(n) + " validation error" + (n > 1 ? "s" : "") + " detected";
            this.setMessage(string, 3);
        }
    }

    private void updateValidationMessages() {
        if (!this.mainComposite.isDisposed()) {
            for (AbstractPropertyControl<?, ?> abstractPropertyControl : this.propertyControls) {
                abstractPropertyControl.displayValidationErrors(this.getValidationErrors());
            }
        }
    }

    protected void performDefaults() {
        for (AbstractPropertyControl<?, ?> abstractPropertyControl : this.propertyControls) {
            abstractPropertyControl.restoreDefault();
        }
    }

    protected void contributeButtons(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        this.restoreDefaults = new Button(composite, 8);
        this.restoreDefaults.setText("Restore Defaults");
        this.restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PropertyPreferencePage.this.performDefaults();
            }
        });
    }

    protected Control createContents(Composite composite) {
        this.mainComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        boolean bl = false;
        for (SingleProperty<?> singleProperty : this.properties) {
            if (!bl && singleProperty.isAdvanced()) {
                this.advancedText = new FormText(this.mainComposite, 64);
                this.advancedText.setText("<form><p><b>Advanced properties:</b></p></form>", true, false);
                this.advancedText.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
                bl = true;
            }
            this.createSinglePropertyContents(singleProperty, this.mainComposite);
        }
        Dialog.applyDialogFont((Control)this.mainComposite);
        this.showAdvanced(this.advancedVisible);
        this.mainComposite.layout();
        return this.mainComposite;
    }

    private void createSinglePropertyContents(SingleProperty<?> singleProperty, Composite composite) {
        AbstractPropertyControl<?, ?> abstractPropertyControl = AbstractPropertyControl.createFor(singleProperty, this);
        abstractPropertyControl.create(composite);
        this.propertyControls.add(abstractPropertyControl);
    }

    public boolean isAllAdvancedProperties() {
        return this.allAdvancedProperties;
    }
}

