/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.property;

import info.novatec.inspectit.cmr.property.configuration.GroupedProperty;
import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidationException;
import info.novatec.inspectit.cmr.property.configuration.validation.ValidationError;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import info.novatec.inspectit.rcp.property.PropertyPreferencePage;
import java.util.ArrayList;
import java.util.Collection;

public class GroupedPropertyPreferencePage
extends PropertyPreferencePage {
    private GroupedProperty groupedProperty;
    private PropertyValidation propertyValidation;

    public GroupedPropertyPreferencePage(GroupedProperty groupedProperty) {
        super(groupedProperty.getName(), groupedProperty.getSingleProperties());
        this.setDescription(groupedProperty.getDescription());
        this.groupedProperty = groupedProperty;
    }

    @Override
    public void propertyUpdated(SingleProperty<?> singleProperty, IPropertyUpdate<?> iPropertyUpdate) {
        super.propertyUpdated(singleProperty, iPropertyUpdate);
        this.executeGroupValidation();
        this.updatePage();
    }

    @Override
    public void propertyUpdateCanceled(SingleProperty<?> singleProperty) {
        super.propertyUpdateCanceled(singleProperty);
        this.executeGroupValidation();
        this.updatePage();
    }

    @Override
    public void propertyValidationFailed(SingleProperty<?> singleProperty, PropertyValidation propertyValidation) {
        super.propertyValidationFailed(singleProperty, propertyValidation);
        this.executeGroupValidation();
        this.updatePage();
    }

    @Override
    public int getValidationErrorsCount() {
        int n = super.getValidationErrorsCount();
        if (this.propertyValidation != null) {
            n += this.propertyValidation.getErrorCount();
        }
        return n;
    }

    @Override
    public Collection<ValidationError> getValidationErrors() {
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        arrayList.addAll(super.getValidationErrors());
        if (this.propertyValidation != null) {
            arrayList.addAll(this.propertyValidation.getErrors());
        }
        return arrayList;
    }

    private void executeGroupValidation() {
        try {
            this.groupedProperty.validateForPropertiesUpdate(this.correctUpdateMap.values());
            this.propertyValidation = null;
        }
        catch (PropertyValidationException propertyValidationException) {
            this.propertyValidation = propertyValidationException.getPropertyValidation();
        }
    }
}

