/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences.valueproviders;

import info.novatec.inspectit.rcp.preferences.PreferenceException;
import info.novatec.inspectit.rcp.preferences.valueproviders.ClassCollectionPreferenceValueProvider;
import info.novatec.inspectit.rcp.preferences.valueproviders.CmrRepositoryPreferenceValueProvider;
import info.novatec.inspectit.rcp.preferences.valueproviders.CollectionPreferenceValueProvider;
import info.novatec.inspectit.rcp.preferences.valueproviders.ColumnOrderPreferenceValueProvider;
import info.novatec.inspectit.rcp.preferences.valueproviders.LastSelectedRepositoryPreferenceValueProvider;
import info.novatec.inspectit.rcp.preferences.valueproviders.MapPreferenceValueProvider;
import java.util.HashMap;
import java.util.Map;

public final class PreferenceValueProviderFactory {
    private static Map<String, PreferenceValueProvider<?>> preferenceValueProviders = new HashMap();

    static {
        preferenceValueProviders.put("CMR_REPOSITORY_DEFINITIONS", new CmrRepositoryPreferenceValueProvider());
        preferenceValueProviders.put("TABLE_COLUMN_SIZE_CACHE", new MapPreferenceValueProvider());
        preferenceValueProviders.put("HIDDEN_TABLE_COLUMN_CACHE", new CollectionPreferenceValueProvider());
        preferenceValueProviders.put("TABLE_COLUMN_ORDER_CACHE", new ColumnOrderPreferenceValueProvider());
        preferenceValueProviders.put("LAST_SELECTED_REPOSITORY", new LastSelectedRepositoryPreferenceValueProvider());
        preferenceValueProviders.put("INVOCATION_FILTER_DATA_TYPES", new ClassCollectionPreferenceValueProvider());
        preferenceValueProviders.put("JMX_PLOT_DATA_SOLVER", new MapPreferenceValueProvider());
    }

    private PreferenceValueProviderFactory() {
    }

    public static <E> String getValueForObject(String string, E e) throws PreferenceException {
        PreferenceValueProvider<?> preferenceValueProvider = preferenceValueProviders.get(string);
        if (preferenceValueProvider != null) {
            if (preferenceValueProvider.isObjectValid(e)) {
                return preferenceValueProvider.getValueForObject(e);
            }
            throw new PreferenceException("Preference value for key " + string + " could  not be obtained because the supplied object is not valid.");
        }
        throw new PreferenceException("Preference value provider was not found for preference key: " + string);
    }

    public static <E> E getObjectFromValue(String string, String string2) throws PreferenceException {
        PreferenceValueProvider<?> preferenceValueProvider = preferenceValueProviders.get(string);
        if (preferenceValueProvider != null) {
            return (E)preferenceValueProvider.getObjectFromValue(string2);
        }
        throw new PreferenceException("Preference value provider was not found for preference key: " + string);
    }

    static abstract class PreferenceValueProvider<E> {
        PreferenceValueProvider() {
        }

        public abstract boolean isObjectValid(Object var1);

        public abstract String getValueForObject(E var1) throws PreferenceException;

        public abstract E getObjectFromValue(String var1) throws PreferenceException;
    }
}

