/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences.valueproviders;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.preferences.PreferenceException;
import info.novatec.inspectit.rcp.preferences.valueproviders.PreferenceValueProviderFactory;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.storage.LocalStorageData;
import java.util.Objects;

public class LastSelectedRepositoryPreferenceValueProvider
extends PreferenceValueProviderFactory.PreferenceValueProvider<RepositoryDefinition> {
    @Override
    public boolean isObjectValid(Object object) {
        return object instanceof RepositoryDefinition;
    }

    @Override
    public String getValueForObject(RepositoryDefinition repositoryDefinition) throws PreferenceException {
        StringBuilder stringBuilder = new StringBuilder();
        if (repositoryDefinition instanceof CmrRepositoryDefinition) {
            stringBuilder.append(CmrRepositoryDefinition.class.getName());
            stringBuilder.append("#");
            stringBuilder.append(((CmrRepositoryDefinition)repositoryDefinition).getIp());
            stringBuilder.append("#");
            stringBuilder.append(((CmrRepositoryDefinition)repositoryDefinition).getPort());
            stringBuilder.append("#");
        } else if (repositoryDefinition instanceof StorageRepositoryDefinition) {
            stringBuilder.append(StorageRepositoryDefinition.class.getName());
            stringBuilder.append("#");
            stringBuilder.append(((StorageRepositoryDefinition)repositoryDefinition).getLocalStorageData().getId());
            stringBuilder.append("#");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RepositoryDefinition getObjectFromValue(String string) throws PreferenceException {
        String[] stringArray = string.split("#");
        if (stringArray.length <= 0) return null;
        String string2 = stringArray[0];
        if (Objects.equals(string2, CmrRepositoryDefinition.class.getName())) {
            if (stringArray.length != 3) throw new PreferenceException("Error trying to create last selected repository and agent from preference store.");
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            for (CmrRepositoryDefinition cmrRepositoryDefinition : InspectIT.getDefault().getCmrRepositoryManager().getCmrRepositoryDefinitions()) {
                if (!Objects.equals(cmrRepositoryDefinition.getIp(), string3) || !Objects.equals(String.valueOf(cmrRepositoryDefinition.getPort()), string4)) continue;
                return cmrRepositoryDefinition;
            }
            return null;
        } else {
            if (!Objects.equals(string2, StorageRepositoryDefinition.class.getName())) return null;
            if (stringArray.length != 2) throw new PreferenceException("Error trying to create last selected repository and agent from preference store.");
            String string5 = stringArray[1];
            for (LocalStorageData localStorageData : InspectIT.getDefault().getInspectITStorageManager().getMountedAvailableStorages()) {
                if (!Objects.equals(localStorageData.getId(), string5)) continue;
                try {
                    return InspectIT.getDefault().getInspectITStorageManager().getStorageRepositoryDefinition(localStorageData);
                }
                catch (Exception exception) {
                    throw new PreferenceException("Error trying to create a Storage repository definition from preference store.", exception);
                }
            }
        }
        return null;
    }
}

