/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences.valueproviders;

import info.novatec.inspectit.rcp.preferences.PreferenceException;
import info.novatec.inspectit.rcp.preferences.valueproviders.PreferenceValueProviderFactory;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;

class CmrRepositoryPreferenceValueProvider
extends PreferenceValueProviderFactory.PreferenceValueProvider<List<CmrRepositoryDefinition>> {
    private static final String EMPTY_LIST = "EMPTY_LIST";

    CmrRepositoryPreferenceValueProvider() {
    }

    @Override
    public boolean isObjectValid(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            for (Object e : list) {
                if (e.getClass().equals(CmrRepositoryDefinition.class)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getValueForObject(List<CmrRepositoryDefinition> list) {
        if (CollectionUtils.isEmpty(list)) {
            return EMPTY_LIST;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : list) {
            stringBuilder.append(String.valueOf(cmrRepositoryDefinition.getIp()) + "#" + cmrRepositoryDefinition.getPort() + "#" + cmrRepositoryDefinition.getName() + "#");
            if (cmrRepositoryDefinition.getDescription() != null) {
                stringBuilder.append(cmrRepositoryDefinition.getDescription());
            }
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    @Override
    public List<CmrRepositoryDefinition> getObjectFromValue(String string) throws PreferenceException {
        if (EMPTY_LIST.equals(string)) {
            return Collections.emptyList();
        }
        ArrayList<CmrRepositoryDefinition> arrayList = new ArrayList<CmrRepositoryDefinition>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = string2.split("#");
            CmrRepositoryDefinition cmrRepositoryDefinition = null;
            if (stringArray.length == 2) {
                try {
                    cmrRepositoryDefinition = new CmrRepositoryDefinition(stringArray[0], Integer.parseInt(stringArray[1]));
                }
                catch (Exception exception) {
                    throw new PreferenceException("Error trying to create a CMR repository definition from preference store.", exception);
                }
            } else if (stringArray.length > 2) {
                try {
                    cmrRepositoryDefinition = new CmrRepositoryDefinition(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2]);
                }
                catch (Exception exception) {
                    throw new PreferenceException("Error trying to create a CMR repository definition from preference store.", exception);
                }
            } else {
                throw new PreferenceException("CMR repository definition values saved in the preference store are not correct. Received values via the string '" + string2 + "' are " + Arrays.asList(stringArray) + ". Definition will be skipped.");
            }
            if (cmrRepositoryDefinition != null && stringArray.length > 3) {
                cmrRepositoryDefinition.setDescription(stringArray[3]);
            }
            arrayList.add(cmrRepositoryDefinition);
        }
        return arrayList;
    }
}

