/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.preferences;

import info.novatec.inspectit.rcp.preferences.PreferenceException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public final class StringToPrimitiveTransformUtil {
    private StringToPrimitiveTransformUtil() {
    }

    public static <E> void transformStringCollection(Collection<String> collection, Collection<E> collection2, Class<E> clazz) throws PreferenceException {
        Method method = StringToPrimitiveTransformUtil.findParseMethod(clazz);
        if (method != null) {
            for (String string : collection) {
                try {
                    Object object = method.invoke(null, string);
                    if (!clazz.isAssignableFrom(object.getClass())) continue;
                    collection2.add(object);
                }
                catch (Exception exception) {
                    throw new PreferenceException("Error transforming Collection<java.lang.String> to Collection<" + clazz.getName() + ">.", exception);
                }
            }
        } else {
            throw new PreferenceException("Error transforming Collection<java.lang.String> to Collection<" + clazz.getName() + ">. Parsing method can not be found in class " + clazz.getName() + ".");
        }
    }

    public static <K, V> void transformStringMap(Map<String, String> map, Map<K, V> map2, Class<K> clazz, Class<V> clazz2) throws PreferenceException {
        Method method = StringToPrimitiveTransformUtil.findParseMethod(clazz);
        Method method2 = StringToPrimitiveTransformUtil.findParseMethod(clazz2);
        if (method != null && method2 != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                try {
                    Object object = method.invoke(null, entry.getKey());
                    Object object2 = method2.invoke(null, entry.getValue());
                    if (!clazz.isAssignableFrom(object.getClass()) || !clazz2.isAssignableFrom(object2.getClass())) continue;
                    map2.put(object, object2);
                }
                catch (Exception exception) {
                    throw new PreferenceException("Error transforming Map<java.lang.String, java.lang.String> to Map<" + clazz.getName() + ", " + clazz2.getName() + ">.", exception);
                }
            }
        } else {
            if (method == null) {
                throw new PreferenceException("Error transforming Map<java.lang.String, java.lang.String> to Map<" + clazz.getName() + ", " + clazz2.getName() + ">." + "Parsing method can not be found in class " + clazz.getName() + ".");
            }
            throw new PreferenceException("Error transforming Map<java.lang.String, java.lang.String> to Map<" + clazz.getName() + ", " + clazz2.getName() + ">." + "Parsing method can not be found in class " + clazz2.getName() + ".");
        }
    }

    private static Method findParseMethod(Class<?> clazz) {
        Method[] methodArray;
        Method[] methodArray2 = methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] classArray;
            Method method = methodArray2[n2];
            if (method.getName().startsWith("parse") && (classArray = method.getParameterTypes()).length == 1 && classArray[0].equals(String.class)) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

