/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model.storage;

import com.google.common.base.Objects;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.model.Leaf;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.StorageData;
import org.eclipse.core.runtime.Assert;

public class StorageLeaf
extends Leaf
implements IStorageDataProvider {
    private StorageData storageData;
    private CmrRepositoryDefinition cmrRepositoryDefinition;

    public StorageLeaf(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition) {
        Assert.isNotNull((Object)storageData);
        Assert.isNotNull((Object)cmrRepositoryDefinition);
        this.storageData = storageData;
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.setName(storageData.getName());
        this.setImage(ImageFormatter.getImageForStorageLeaf(storageData));
        this.setTooltip(storageData.getName());
    }

    @Override
    public StorageData getStorageData() {
        return this.storageData;
    }

    @Override
    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        return this.cmrRepositoryDefinition;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.storageData, this.cmrRepositoryDefinition});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StorageLeaf storageLeaf = (StorageLeaf)object;
        return Objects.equal((Object)this.storageData, (Object)storageLeaf.storageData) && Objects.equal((Object)this.cmrRepositoryDefinition, (Object)storageLeaf.cmrRepositoryDefinition);
    }
}

