/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.model.SensorTypeIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.model.DeferredJmxPackageComposite;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredJmxBrowserComposite
extends DeferredComposite {
    private PlatformIdent platformIdent;
    private SensorTypeIdent sensorTypeIdent;
    private RepositoryDefinition repositoryDefinition;

    public void setSensorTypeIdent(SensorTypeIdent sensorTypeIdent) {
        this.sensorTypeIdent = sensorTypeIdent;
    }

    public void setPlatformIdent(PlatformIdent platformIdent) {
        this.platformIdent = platformIdent;
    }

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        try {
            Composite composite = (Composite)object;
            Set set = this.platformIdent.getJmxDefinitionDataIdents();
            iProgressMonitor.beginTask("Loading monitored JMX-Packages...", -1);
            HashMap<String, DeferredJmxPackageComposite> hashMap = new HashMap<String, DeferredJmxPackageComposite>(set.size());
            for (JmxDefinitionDataIdent jmxDefinitionDataIdent : set) {
                DeferredJmxPackageComposite deferredJmxPackageComposite;
                String string = jmxDefinitionDataIdent.getDerivedDomainName();
                if (!hashMap.containsKey(string)) {
                    deferredJmxPackageComposite = this.getNewChild();
                    deferredJmxPackageComposite.setRepositoryDefinition(this.repositoryDefinition);
                    deferredJmxPackageComposite.setName(string);
                    iElementCollector.add((Object)deferredJmxPackageComposite, iProgressMonitor);
                    composite.addChild(deferredJmxPackageComposite);
                    hashMap.put(string, deferredJmxPackageComposite);
                }
                deferredJmxPackageComposite = (DeferredJmxPackageComposite)hashMap.get(string);
                deferredJmxPackageComposite.setSensorTypeIdent(this.sensorTypeIdent);
                deferredJmxPackageComposite.addJmxDataToDisplay(jmxDefinitionDataIdent);
                if (!iProgressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    protected DeferredJmxPackageComposite getNewChild() {
        return new DeferredJmxPackageComposite();
    }

    @Override
    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    @Override
    public Image getImage() {
        return InspectIT.getDefault().getImage("/icons/fugue/blue-document-tree.png");
    }
}

