/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import com.google.common.base.Objects;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.rcp.model.AgentFolderFactory;
import info.novatec.inspectit.rcp.model.Component;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredComposite;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredAgentsComposite
extends DeferredComposite
implements ICmrRepositoryProvider {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private final boolean showOldAgents;

    public DeferredAgentsComposite(CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
        this.showOldAgents = bl;
        this.setRepositoryDefinition(cmrRepositoryDefinition);
    }

    @Override
    public synchronized void fetchDeferredChildren(Object object, IElementCollector iElementCollector, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("Loading agents..", -1);
        try {
            Map map;
            if (this.cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE && (map = this.cmrRepositoryDefinition.getGlobalDataAccessService().getAgentsOverview()) != null) {
                HashMap<PlatformIdent, AgentStatusData> hashMap = new HashMap<PlatformIdent, AgentStatusData>(map.size());
                for (Map.Entry object22 : map.entrySet()) {
                    PlatformIdent platformIdent = (PlatformIdent)object22.getKey();
                    AgentStatusData agentStatusData = (AgentStatusData)object22.getValue();
                    if (!this.showOldAgents && (this.showOldAgents || agentStatusData == null)) continue;
                    hashMap.put(platformIdent, agentStatusData);
                }
                List<Component> list = AgentFolderFactory.getAgentFolderTree(hashMap, this.cmrRepositoryDefinition);
                for (Object component : list) {
                    iElementCollector.add(component, iProgressMonitor);
                    ((Composite)object).addChild((Component)component);
                }
            }
        }
        finally {
            iElementCollector.done();
            iProgressMonitor.done();
        }
    }

    @Override
    public final void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        if (repositoryDefinition instanceof CmrRepositoryDefinition) {
            this.cmrRepositoryDefinition = (CmrRepositoryDefinition)repositoryDefinition;
        }
    }

    @Override
    public RepositoryDefinition getRepositoryDefinition() {
        return this.cmrRepositoryDefinition;
    }

    @Override
    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        return this.cmrRepositoryDefinition;
    }

    @Override
    public String getName() {
        return this.cmrRepositoryDefinition.getName();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.cmrRepositoryDefinition});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DeferredAgentsComposite deferredAgentsComposite = (DeferredAgentsComposite)object;
        return Objects.equal((Object)this.cmrRepositoryDefinition, (Object)deferredAgentsComposite.cmrRepositoryDefinition);
    }
}

