/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.model.AgentLeaf;
import info.novatec.inspectit.rcp.model.Component;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class AgentFolderFactory {
    private static final String FOLDER_SPLIT_REGEX = "/";

    private AgentFolderFactory() {
    }

    public static List<Component> getAgentFolderTree(Map<PlatformIdent, AgentStatusData> map, CmrRepositoryDefinition cmrRepositoryDefinition) {
        Composite composite = new Composite();
        for (Map.Entry<PlatformIdent, AgentStatusData> entry : map.entrySet()) {
            PlatformIdent platformIdent = entry.getKey();
            AgentStatusData agentStatusData = entry.getValue();
            AgentFolderFactory.addToFolder(composite, 0, platformIdent, agentStatusData, cmrRepositoryDefinition);
        }
        return composite.getChildren();
    }

    private static void addToFolder(Composite composite, int n, PlatformIdent platformIdent, AgentStatusData agentStatusData, CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!AgentFolderFactory.accessibleForLevel(platformIdent.getAgentName(), n)) {
            AgentLeaf agentLeaf = new AgentLeaf(platformIdent, agentStatusData, cmrRepositoryDefinition, n != 0);
            composite.addChild(agentLeaf);
        } else {
            boolean bl = false;
            String string = AgentFolderFactory.getFolderNameFromAgent(platformIdent.getAgentName(), n);
            for (Component component : composite.getChildren()) {
                if (!(component instanceof Composite) || !ObjectUtils.equals((Object)component.getName(), (Object)string)) continue;
                AgentFolderFactory.addToFolder((Composite)component, n + 1, platformIdent, agentStatusData, cmrRepositoryDefinition);
                bl = true;
            }
            if (!bl) {
                Component component;
                component = AgentFolderFactory.createFolder(string);
                AgentFolderFactory.addToFolder((Composite)component, n + 1, platformIdent, agentStatusData, cmrRepositoryDefinition);
                composite.addChild(component);
            }
        }
    }

    private static Composite createFolder(String string) {
        Composite composite = new Composite();
        composite.setName(string);
        composite.setImage(InspectIT.getDefault().getImage("/icons/eclipse/prj_obj.gif"));
        return composite;
    }

    public static boolean accessibleForFolder(String string) {
        return AgentFolderFactory.accessibleForLevel(string, 0);
    }

    public static String getAgentDisplayNameInFolder(String string) {
        String[] stringArray = AgentFolderFactory.getSplittedAgentName(string);
        return stringArray[stringArray.length - 1];
    }

    private static boolean accessibleForLevel(String string, int n) {
        String[] stringArray = AgentFolderFactory.getSplittedAgentName(string);
        if (stringArray.length > n + 1) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                if (StringUtils.isEmpty((String)string2)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private static String getFolderNameFromAgent(String string, int n) {
        String[] stringArray = AgentFolderFactory.getSplittedAgentName(string);
        if (stringArray.length > n) {
            return stringArray[n];
        }
        return null;
    }

    private static String[] getSplittedAgentName(String string) {
        if (string != null) {
            return string.split(FOLDER_SPLIT_REGEX);
        }
        return new String[0];
    }
}

