/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.job;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.version.InvalidVersionException;
import info.novatec.inspectit.version.Version;
import info.novatec.inspectit.version.VersionRelease;
import info.novatec.inspectit.version.VersionService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class CheckNewVersionJob
extends Job {
    private static final String GITHUB_RELEASES_API = "https://api.github.com/repos/inspectIT/inspectIT/releases";
    private boolean userTriggered;

    public CheckNewVersionJob(boolean bl) {
        super("Checking for new inspectIT version");
        this.userTriggered = bl;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        DefaultHttpClient defaultHttpClient;
        Version version;
        boolean bl = PreferencesUtils.getBooleanValue("AUTO_CHECK_NEW_VERSION");
        if (!this.userTriggered && !bl) {
            return Status.OK_STATUS;
        }
        VersionService versionService = InspectIT.getService(VersionService.class);
        try {
            version = versionService.getVersion();
        }
        catch (InvalidVersionException invalidVersionException) {
            return new Status(4, "info.novatec.inspectit.rcp", "Can not read the inspectIT version.", (Throwable)invalidVersionException);
        }
        VersionRelease versionRelease = null;
        try {
            defaultHttpClient = new DefaultHttpClient();
            HttpGet httpGet = new HttpGet(GITHUB_RELEASES_API);
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = httpResponse.getEntity();
            Throwable throwable = null;
            Object var11_14 = null;
            try (InputStream inputStream = httpEntity.getContent();){
                Gson gson = new GsonBuilder().create();
                JsonArray jsonArray = (JsonArray)gson.fromJson((Reader)new InputStreamReader(inputStream), JsonArray.class);
                versionRelease = this.getHighestVersionFromJson(jsonArray);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InvalidVersionException | IOException throwable) {
            if (this.userTriggered) {
                return new Status(4, "info.novatec.inspectit.rcp", "Error occurred reading the existing versions from GitHub during check for new version job.", throwable);
            }
            return new Status(2, "info.novatec.inspectit.rcp", "Error occurred reading the existing versions from GitHub during check for new version job.", throwable);
        }
        if (versionRelease.getVersion().compareTo(version) > 0) {
            defaultHttpClient = versionRelease;
            Display.getDefault().asyncExec(new Runnable((VersionRelease)defaultHttpClient, bl){
                private final /* synthetic */ VersionRelease val$highestVersionFinal;
                private final /* synthetic */ boolean val$isAutoCheck;
                {
                    this.val$highestVersionFinal = versionRelease;
                    this.val$isAutoCheck = bl;
                }

                @Override
                public void run() {
                    NewVersionDialog newVersionDialog = new NewVersionDialog(this.val$highestVersionFinal, Display.getCurrent().getActiveShell(), this.val$isAutoCheck);
                    newVersionDialog.open();
                    Boolean bl = newVersionDialog.getToggleState();
                    PreferencesUtils.saveBooleanValue("AUTO_CHECK_NEW_VERSION", bl, false);
                }
            });
        } else if (this.userTriggered) {
            defaultHttpClient = version;
            Display.getDefault().asyncExec(new Runnable((Version)defaultHttpClient){
                private final /* synthetic */ Version val$currentVersionFinal;
                {
                    this.val$currentVersionFinal = version;
                }

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Check for new Version", (String)("There is no newer version of inspectIT available. Currently running version " + this.val$currentVersionFinal.toString() + " is the latest officially released version."));
                }
            });
        }
        return Status.OK_STATUS;
    }

    private VersionRelease getHighestVersionFromJson(JsonArray jsonArray) throws InvalidVersionException {
        Version version = new Version(0, 0, 0);
        VersionRelease versionRelease = new VersionRelease(version);
        int n = 0;
        int n2 = jsonArray.size();
        while (n < n2) {
            JsonObject jsonObject = (JsonObject)jsonArray.get(n);
            String string = jsonObject.get("tag_name").getAsString();
            Version version2 = Version.verifyAndCreate((String)string);
            if (version2.compareTo(version) > 0) {
                version = version2;
                versionRelease = new VersionRelease(version2);
                boolean bl = jsonObject.get("prerelease").getAsBoolean();
                versionRelease.setPreRelease(bl);
                String string2 = jsonObject.get("html_url").getAsString();
                versionRelease.setLink(string2);
            }
            ++n;
        }
        return versionRelease;
    }

    private static class NewVersionDialog
    extends MessageDialogWithToggle {
        private VersionRelease versionRelease;

        public NewVersionDialog(VersionRelease versionRelease, Shell shell, boolean bl) {
            super(shell, "Check for New Version", null, "", 2, new String[]{IDialogConstants.OK_LABEL}, 0, "Enable auto check for the new version on startup", bl);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
            this.versionRelease = versionRelease;
        }

        protected Control createMessageArea(Composite composite) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
            }
            if (this.versionRelease != null) {
                String string = this.versionRelease.isPreRelease() ? "preview" : "stable";
                String string2 = "There is a newer version of inspectIT available. The version " + this.versionRelease.getVersion().toString() + " is the latest officially released " + string + " version and can be downloaded from the GitHub: " + this.versionRelease.getLink();
                FormText formText = new FormText(composite, 524288);
                formText.setText(string2, false, true);
                formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                        IWorkbenchBrowserSupport iWorkbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        try {
                            IWebBrowser iWebBrowser = iWorkbenchBrowserSupport.createBrowser(null);
                            URL uRL = new URL((String)hyperlinkEvent.getHref());
                            iWebBrowser.openURL(uRL);
                        }
                        catch (Exception exception) {
                            InspectIT.getDefault().createErrorDialog(exception.getMessage(), exception, -1);
                        }
                    }
                });
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)formText);
            }
            return composite;
        }
    }
}

