/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryAndAgentProvider;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.view.impl.RepositoryManagerView;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.StartRecordingWizard;
import info.novatec.inspectit.storage.recording.RecordingProperties;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressConstants;

public class StartRecordingHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        String string;
        Object object;
        CmrRepositoryDefinition cmrRepositoryDefinition = null;
        List<PlatformIdent> list = Collections.emptyList();
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection) {
            object = ((StructuredSelection)iSelection).getFirstElement();
            if (object instanceof ICmrRepositoryProvider) {
                cmrRepositoryDefinition = ((ICmrRepositoryProvider)object).getCmrRepositoryDefinition();
            } else if (object instanceof ICmrRepositoryAndAgentProvider) {
                cmrRepositoryDefinition = ((ICmrRepositoryAndAgentProvider)object).getCmrRepositoryDefinition();
                list = Collections.singletonList(((ICmrRepositoryAndAgentProvider)object).getPlatformIdent());
            }
        }
        if (cmrRepositoryDefinition != null) {
            try {
                object = cmrRepositoryDefinition.getCmrManagementService().getCmrStatusData();
                if (object.isWarnSpaceLeftActive()) {
                    string = NumberFormatter.humanReadableByteCount(object.getStorageDataSpaceLeft());
                    if (!MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (String)"Confirm", (String)("For selected CMR there is an active warning about insufficient storage space left. Only " + string + " are left on the target server, are you sure you want to continue?"))) {
                        return null;
                    }
                }
            }
            catch (Exception exception) {}
        }
        object = new StartRecordingWizard(cmrRepositoryDefinition, list);
        string = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), (IWizard)object);
        string.open();
        if (string.getReturnCode() == 0) {
            RecordingProperties recordingProperties;
            IViewPart iViewPart;
            final IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart iViewPart2 = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.repositoryManager");
            if (iViewPart2 instanceof RepositoryManagerView) {
                ((RepositoryManagerView)iViewPart2).refresh();
            }
            if ((iViewPart = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.storageManager")) instanceof StorageManagerView) {
                if (cmrRepositoryDefinition != null) {
                    ((StorageManagerView)iViewPart).refresh(cmrRepositoryDefinition);
                } else {
                    ((StorageManagerView)iViewPart).refresh();
                }
            }
            if ((recordingProperties = ((StartRecordingWizard)((Object)object)).getRecordingProperties()) != null && recordingProperties.getRecordDuration() > 0L) {
                Job job = new Job("Recording Auto-Stop Updates"){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        IViewPart iViewPart = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.storageManager");
                        if (iViewPart instanceof StorageManagerView) {
                            ((StorageManagerView)iViewPart).refresh();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(false);
                job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImage("/icons/eclipse/record_term.gif"));
                long l = 5000L + recordingProperties.getRecordDuration() + recordingProperties.getStartDelay();
                job.schedule(l);
            }
        }
        return null;
    }
}

