/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;

public class ShowHideColumnsHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "info.novatec.inspectit.rcp.commands.showHideColumn";
    public static final String COLUMN_PARAM = "info.novatec.inspectit.rcp.commands.showHideColumn.Column";
    public static final String VISIBLE_PARAM = "info.novatec.inspectit.rcp.commands.showHideColumn.Visible";
    public static final String CONTROLLER_CLASS_PARAM = "info.novatec.inspectit.rcp.commands.showHideColumn.ControllerClass";
    private static Map<Integer, Integer> columnSizeCache;
    private static Set<Integer> hiddenColumnsCache;
    private static Map<Integer, int[]> columnOrderCache;

    static {
        ShowHideColumnsHandler.startUp();
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
        Item item = (Item)iEvaluationContext.getVariable(COLUMN_PARAM);
        Boolean bl = (Boolean)iEvaluationContext.getVariable(VISIBLE_PARAM);
        Class clazz = (Class)iEvaluationContext.getVariable(CONTROLLER_CLASS_PARAM);
        this.showHideColumn(item, item.getText(), bl, clazz);
        return null;
    }

    private void showHideColumn(Item item, String string, boolean bl, Class<?> clazz) {
        int n = ShowHideColumnsHandler.getColumnHash(clazz, string);
        if (bl) {
            Integer n2 = columnSizeCache.get(n);
            hiddenColumnsCache.remove(n);
            if (n2 != null) {
                this.setColumnWidth(item, n2);
            } else {
                this.setColumnWidth(item, 100);
            }
            this.setColumnResizable(item, true);
        } else {
            int n3 = this.getColumnWidth(item);
            hiddenColumnsCache.add(n);
            columnSizeCache.put(n, n3);
            this.setColumnWidth(item, 0);
            this.setColumnResizable(item, false);
        }
    }

    private void setColumnWidth(Item item, int n) {
        if (item instanceof TableColumn) {
            ((TableColumn)item).setWidth(n);
        } else if (item instanceof TreeColumn) {
            ((TreeColumn)item).setWidth(n);
        }
    }

    private int getColumnWidth(Item item) {
        if (item instanceof TableColumn) {
            return ((TableColumn)item).getWidth();
        }
        if (item instanceof TreeColumn) {
            return ((TreeColumn)item).getWidth();
        }
        return -1;
    }

    private void setColumnResizable(Item item, boolean bl) {
        if (item instanceof TableColumn) {
            ((TableColumn)item).setResizable(bl);
        } else if (item instanceof TreeColumn) {
            ((TreeColumn)item).setResizable(bl);
        }
    }

    public static Integer getRememberedColumnWidth(Class<?> clazz, String string) {
        int n = ShowHideColumnsHandler.getColumnHash(clazz, string);
        return columnSizeCache.get(n);
    }

    public static boolean isColumnHidden(Class<?> clazz, String string) {
        return hiddenColumnsCache.contains(ShowHideColumnsHandler.getColumnHash(clazz, string));
    }

    public static void setColumnOrder(Class<?> clazz, int[] nArray) {
        Integer n = clazz.getName().hashCode();
        columnOrderCache.remove(n);
        columnOrderCache.put(n, nArray);
    }

    public static int[] getColumnOrder(Class<?> clazz) {
        Integer n = clazz.getName().hashCode();
        return columnOrderCache.get(n);
    }

    public static void registerNewColumnWidth(Class<?> clazz, String string, int n) {
        if (n > 0) {
            int n2 = ShowHideColumnsHandler.getColumnHash(clazz, string);
            columnSizeCache.put(n2, n);
        }
    }

    private static int getColumnHash(Class<?> clazz, String string) {
        int n = 0;
        n = 31 * n + (clazz.getName() == null ? 0 : clazz.getName().hashCode());
        n = 31 * n + (string == null ? 0 : string.hashCode());
        return n;
    }

    private static synchronized void startUp() {
        columnSizeCache = new HashMap<Integer, Integer>();
        PreferencesUtils.loadPrimitiveMap("TABLE_COLUMN_SIZE_CACHE", columnSizeCache, Integer.class, Integer.class);
        hiddenColumnsCache = new HashSet<Integer>();
        PreferencesUtils.loadPrimitiveCollection("HIDDEN_TABLE_COLUMN_CACHE", hiddenColumnsCache, Integer.class);
        columnOrderCache = (Map)PreferencesUtils.getObject("TABLE_COLUMN_ORDER_CACHE");
        if (columnOrderCache == null) {
            columnOrderCache = new HashMap<Integer, int[]>();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ShowHideColumnsHandler.saveChanges();
            }
        });
    }

    private static void saveChanges() {
        PreferencesUtils.saveObject("TABLE_COLUMN_SIZE_CACHE", columnSizeCache, false);
        PreferencesUtils.saveObject("HIDDEN_TABLE_COLUMN_CACHE", hiddenColumnsCache, false);
        PreferencesUtils.saveObject("TABLE_COLUMN_ORDER_CACHE", columnOrderCache, false);
    }
}

