/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.ModifiersImageFactory;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class NavigateToAggregatedTimerDataHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        AbstractRootEditor abstractRootEditor = (AbstractRootEditor)HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        RepositoryDefinition repositoryDefinition = abstractRootEditor.getInputDefinition().getRepositoryDefinition();
        Object object = structuredSelection.getFirstElement();
        TimerData timerData = null;
        if (object instanceof TimerData) {
            timerData = (TimerData)object;
        } else if (object instanceof InvocationSequenceData) {
            timerData = ((InvocationSequenceData)object).getTimerData();
        }
        if (timerData != null) {
            MethodIdent methodIdent = repositoryDefinition.getCachedDataService().getMethodIdentForId(timerData.getMethodIdent());
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.TIMER);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorName(SensorTypeEnum.TIMER.getDisplayName());
            editorPropertiesData.setSensorImage(SensorTypeEnum.TIMER.getImage());
            editorPropertiesData.setViewName(TextFormatter.getMethodString(methodIdent));
            editorPropertiesData.setViewImage(ModifiersImageFactory.getImage(methodIdent.getModifiers()));
            editorPropertiesData.setPartNameFlag(EditorPropertiesData.PartType.SENSOR);
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(timerData.getPlatformIdent());
            idDefinition.setMethodId(timerData.getMethodIdent());
            inputDefinition.setIdDefinition(idDefinition);
            IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.openView");
            ExecutionEvent executionEvent2 = iHandlerService.createExecutionEvent(command, new Event());
            IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent2.getApplicationContext();
            iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.openView.input", (Object)inputDefinition);
            try {
                command.executeWithChecks(executionEvent2);
            }
            catch (NotEnabledException | NotHandledException | NotDefinedException throwable) {
                throw new ExecutionException("Error opening the aggregated timer data view.", throwable);
            }
        }
        return null;
    }
}

