/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.SqlStatementInputDefinitionExtra;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class NavigateToAggregatedSqlDataHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        AbstractRootEditor abstractRootEditor = (AbstractRootEditor)HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        RepositoryDefinition repositoryDefinition = abstractRootEditor.getInputDefinition().getRepositoryDefinition();
        Object object = structuredSelection.getFirstElement();
        SqlStatementData sqlStatementData = null;
        if (object instanceof SqlStatementData) {
            sqlStatementData = (SqlStatementData)object;
        } else if (object instanceof InvocationSequenceData) {
            sqlStatementData = ((InvocationSequenceData)object).getSqlStatementData();
        }
        if (sqlStatementData != null) {
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.SQL);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(SensorTypeEnum.SQL.getImage());
            editorPropertiesData.setSensorName("Aggregated SQL Statements");
            editorPropertiesData.setViewName(sqlStatementData.getSql());
            editorPropertiesData.setPartNameFlag(EditorPropertiesData.PartType.SENSOR);
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(sqlStatementData.getPlatformIdent());
            inputDefinition.setIdDefinition(idDefinition);
            SqlStatementInputDefinitionExtra sqlStatementInputDefinitionExtra = new SqlStatementInputDefinitionExtra();
            sqlStatementInputDefinitionExtra.setSql(sqlStatementData.getSql());
            inputDefinition.addInputDefinitonExtra(InputDefinitionExtrasMarkerFactory.SQL_STATEMENT_EXTRAS_MARKER, sqlStatementInputDefinitionExtra);
            IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.openView");
            ExecutionEvent executionEvent2 = iHandlerService.createExecutionEvent(command, new Event());
            IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent2.getApplicationContext();
            iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.openView.input", (Object)inputDefinition);
            try {
                command.executeWithChecks(executionEvent2);
            }
            catch (NotEnabledException | NotHandledException | NotDefinedException throwable) {
                throw new ExecutionException("Error opening the aggregated SQL data view.", throwable);
            }
        }
        return null;
    }
}

