/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.composite.AbstractCompositeSubView;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import info.novatec.inspectit.rcp.editor.search.ISearchExecutor;
import info.novatec.inspectit.rcp.editor.search.OpenedSearchControlCache;
import info.novatec.inspectit.rcp.editor.search.SearchControl;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class FindHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        if (iEditorPart instanceof AbstractRootEditor) {
            AbstractRootEditor abstractRootEditor = (AbstractRootEditor)iEditorPart;
            ISearchExecutor iSearchExecutor = null;
            ISubView iSubView = null;
            if (abstractRootEditor.getActiveSubView() instanceof ISearchExecutor) {
                iSubView = abstractRootEditor.getActiveSubView();
                iSearchExecutor = (ISearchExecutor)((Object)abstractRootEditor.getActiveSubView());
            } else {
                iSubView = this.findSearchExecutorView(abstractRootEditor.getSubView());
                iSearchExecutor = (ISearchExecutor)((Object)iSubView);
            }
            if (iSearchExecutor != null && iSubView != null) {
                this.ensureNoSearchOpened(abstractRootEditor.getSubView());
                new SearchControl(iSearchExecutor, HandlerUtil.getActiveShellChecked((ExecutionEvent)executionEvent), iSubView.getControl(), iEditorPart);
            }
        }
        return null;
    }

    private void ensureNoSearchOpened(ISubView iSubView) {
        if (iSubView instanceof ISearchExecutor) {
            SearchControl searchControl = OpenedSearchControlCache.getSearchControl((ISearchExecutor)((Object)iSubView));
            if (searchControl != null) {
                searchControl.closeControl();
            }
        } else if (iSubView instanceof AbstractCompositeSubView) {
            AbstractCompositeSubView abstractCompositeSubView = (AbstractCompositeSubView)iSubView;
            for (ISubView iSubView2 : abstractCompositeSubView.getSubViews()) {
                this.ensureNoSearchOpened(iSubView2);
            }
        }
    }

    private ISubView findSearchExecutorView(ISubView iSubView) {
        if (iSubView instanceof ISearchExecutor) {
            return iSubView;
        }
        if (iSubView instanceof AbstractCompositeSubView) {
            AbstractCompositeSubView abstractCompositeSubView = (AbstractCompositeSubView)iSubView;
            for (ISubView iSubView2 : abstractCompositeSubView.getSubViews()) {
                ISubView iSubView3 = this.findSearchExecutorView(iSubView2);
                if (iSubView3 == null) continue;
                return iSubView3;
            }
        }
        return null;
    }
}

