/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.viewers;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public abstract class AbstractViewerComparator<T extends DefaultData>
extends ViewerComparator {
    private ResultComparator<T> comparator;
    private SortState sortState = SortState.UP;

    protected void toggleSortColumn(ResultComparator<T> resultComparator) {
        if (this.comparator == resultComparator) {
            switch (this.sortState) {
                case NONE: {
                    this.sortState = SortState.UP;
                    this.comparator.setAscending(true);
                    break;
                }
                case UP: {
                    this.sortState = SortState.DOWN;
                    this.comparator.setAscending(false);
                    break;
                }
                case DOWN: {
                    this.sortState = SortState.NONE;
                    break;
                }
            }
        } else {
            this.comparator = resultComparator;
            this.sortState = SortState.UP;
            this.comparator.setAscending(true);
        }
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        if (this.comparator == null) {
            return 0;
        }
        if (SortState.NONE.equals((Object)this.sortState)) {
            return 0;
        }
        DefaultData defaultData = (DefaultData)object;
        DefaultData defaultData2 = (DefaultData)object2;
        return this.comparator.compare(defaultData, defaultData2);
    }

    protected SortState getSortState() {
        return this.sortState;
    }

    protected static enum SortState {
        NONE(0),
        UP(128),
        DOWN(1024);

        private int swtDirection;

        private SortState(int n2) {
            this.swtDirection = n2;
        }

        public int getSwtDirection() {
            return this.swtDirection;
        }
    }
}

