/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree.input;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.SqlStatementDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.TimerDataComparatorEnum;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.AggregationPerformer;
import info.novatec.inspectit.indexing.aggregation.impl.SqlStatementDataAggregator;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.tree.input.AbstractTreeInputController;
import info.novatec.inspectit.rcp.editor.tree.util.DatabaseSqlTreeComparator;
import info.novatec.inspectit.rcp.editor.viewers.RawAggregatedResultComparator;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.handlers.ShowHideColumnsHandler;
import info.novatec.inspectit.rcp.util.data.DatabaseInfoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;

public class SqlInvocInputController
extends AbstractTreeInputController {
    public static final String ID = "inspectit.subview.tree.sqlinvoc";
    private ICachedDataService cachedDataService;
    private List<SqlStatementData> sqlStatementDataList;
    private Map<DatabaseInfoHelper, List<SqlStatementData>> databaseSqlMap;
    private final StyledString emptyStyledString = new StyledString();
    private boolean rawMode = false;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TreeViewer treeViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
            treeViewerColumn.getColumn().setMoveable(true);
            treeViewerColumn.getColumn().setResizable(true);
            treeViewerColumn.getColumn().setText(column.name);
            if (column.showInAggregatedMode) {
                treeViewerColumn.getColumn().setWidth(column.width);
            } else {
                treeViewerColumn.getColumn().setWidth(0);
            }
            if (column.image != null) {
                treeViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTreeViewerColumn(column, treeViewerColumn);
            ++n2;
        }
    }

    @Override
    public boolean canAlterColumnWidth(TreeColumn treeColumn) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            if (Objects.equals(this.getMappedTreeViewerColumn(column).getColumn(), treeColumn)) {
                return column.showInRawMode && this.rawMode || column.showInAggregatedMode && !this.rawMode;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        enumSet.add(PreferenceId.INVOCATION_SUBVIEW_MODE);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        Map<IPreferenceGroup, Object> map;
        if (PreferenceId.INVOCATION_SUBVIEW_MODE.equals((Object)preferenceEvent.getPreferenceId()) && (map = preferenceEvent.getPreferenceMap()) != null && map.containsKey(PreferenceId.InvocationSubviewMode.RAW)) {
            Boolean bl = (Boolean)map.get(PreferenceId.InvocationSubviewMode.RAW);
            this.handleRawAggregatedColumnVisibility(bl);
            this.rawMode = bl;
        }
    }

    private void handleRawAggregatedColumnVisibility(boolean bl) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer n3;
            Column column = columnArray[n2];
            if (bl) {
                if (column.showInRawMode && !column.showInAggregatedMode && !ShowHideColumnsHandler.isColumnHidden(this.getClass(), column.name)) {
                    n3 = ShowHideColumnsHandler.getRememberedColumnWidth(this.getClass(), column.name);
                    this.getMappedTreeViewerColumn(column).getColumn().setWidth(n3 != null ? n3 : column.width);
                } else if (!column.showInRawMode && column.showInAggregatedMode) {
                    this.getMappedTreeViewerColumn(column).getColumn().setWidth(0);
                }
            } else if (!column.showInRawMode && column.showInAggregatedMode && !ShowHideColumnsHandler.isColumnHidden(this.getClass(), column.name)) {
                n3 = ShowHideColumnsHandler.getRememberedColumnWidth(this.getClass(), column.name);
                this.getMappedTreeViewerColumn(column).getColumn().setWidth(n3 != null ? n3 : column.width);
            } else if (column.showInRawMode && !column.showInAggregatedMode) {
                this.getMappedTreeViewerColumn(column).getColumn().setWidth(0);
            }
            ++n2;
        }
    }

    @Override
    public IContentProvider getContentProvider() {
        return new SqlInvocContentProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        DatabaseSqlTreeComparator databaseSqlTreeComparator = new DatabaseSqlTreeComparator();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            RawAggregatedResultComparator<SqlStatementData> rawAggregatedResultComparator = new RawAggregatedResultComparator<SqlStatementData>(column.dataComparator, this.cachedDataService, column.showInRawMode, column.showInAggregatedMode){

                @Override
                protected boolean isRawMode() {
                    return SqlInvocInputController.this.rawMode;
                }
            };
            databaseSqlTreeComparator.addColumn(this.getMappedTreeViewerColumn(column).getColumn(), rawAggregatedResultComparator);
            ++n2;
        }
        return databaseSqlTreeComparator;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new SqlInvocLabelProvider();
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        if (list.get(0) instanceof InvocationSequenceData) {
            return true;
        }
        return list.get(0) instanceof SqlStatementData;
    }

    public void update(IProgressMonitor iProgressMonitor) {
    }

    private StyledString getStyledTextForColumn(SqlStatementData sqlStatementData, Column column) {
        switch (column) {
            case DATABASE_URL: {
                if (this.rawMode) {
                    if (StringUtils.isNotEmpty((String)sqlStatementData.getDatabaseUrl())) {
                        return new StyledString(sqlStatementData.getDatabaseUrl());
                    }
                    return new StyledString("Unknown");
                }
                return this.emptyStyledString;
            }
            case TIMESTAMP: {
                if (this.rawMode) {
                    return new StyledString(NumberFormatter.formatTimeWithMillis(sqlStatementData.getTimeStamp()));
                }
                return this.emptyStyledString;
            }
            case STATEMENT: {
                if (this.rawMode) {
                    String string = TextFormatter.clearLineBreaks(sqlStatementData.getSqlWithParameterValues());
                    return new StyledString(string);
                }
                String string = TextFormatter.clearLineBreaks(sqlStatementData.getSql());
                return new StyledString(string);
            }
            case COUNT: {
                return new StyledString(Long.toString(sqlStatementData.getCount()));
            }
            case AVERAGE: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getAverage()));
            }
            case MIN: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getMin()));
            }
            case MAX: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getMax()));
            }
            case DURATION: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getDuration()));
            }
            case PREPARED: {
                if (this.rawMode) {
                    return new StyledString(Boolean.toString(sqlStatementData.isPreparedStatement()));
                }
                return this.emptyStyledString;
            }
        }
        return new StyledString("error");
    }

    private StyledString getDatabaseStyledTextForColumn(DatabaseInfoHelper databaseInfoHelper, Column column) {
        switch (column) {
            case DATABASE_URL: {
                return new StyledString(databaseInfoHelper.getDatabaseUrl());
            }
        }
        return this.emptyStyledString;
    }

    @Override
    public int getExpandLevel() {
        return -1;
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(sqlStatementData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        if (object instanceof DatabaseInfoHelper) {
            DatabaseInfoHelper databaseInfoHelper = (DatabaseInfoHelper)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n3 = 0;
            while (n3 < n) {
                Column column = columnArray[n3];
                stringBuilder.append(this.getDatabaseStyledTextForColumn(databaseInfoHelper, column).toString());
                stringBuilder.append('\t');
                ++n3;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(sqlStatementData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        if (object instanceof DatabaseInfoHelper) {
            DatabaseInfoHelper databaseInfoHelper = (DatabaseInfoHelper)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n3 = 0;
            while (n3 < n) {
                Column column = columnArray[n3];
                arrayList.add(this.getDatabaseStyledTextForColumn(databaseInfoHelper, column).toString());
                ++n3;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        return this.sqlStatementDataList.toArray();
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.SLAVE;
    }

    private static enum Column {
        TIMESTAMP("Timestamp", 130, "/icons/eclipse/dates.gif", false, true, (IDataComparator<? super SqlStatementData>)DefaultDataComparatorEnum.TIMESTAMP),
        DATABASE_URL("Database URL", 120, null, true, true, null),
        STATEMENT("Statement", 600, "/icons/fugue/database-sql.png", true, true, (IDataComparator<? super SqlStatementData>)SqlStatementDataComparatorEnum.SQL_AND_PARAMETERS),
        COUNT("Count", 80, null, true, false, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.COUNT),
        AVERAGE("Avg (ms)", 80, null, true, false, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.AVERAGE),
        MIN("Min (ms)", 80, null, true, false, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.MIN),
        MAX("Max (ms)", 80, null, true, false, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.MAX),
        DURATION("Duration (ms)", 80, null, true, true, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.DURATION),
        PREPARED("Prepared?", 60, null, false, true, (IDataComparator<? super SqlStatementData>)SqlStatementDataComparatorEnum.IS_PREPARED_STATEMENT);

        private String name;
        private int width;
        private Image image;
        private boolean showInAggregatedMode;
        private boolean showInRawMode;
        private IDataComparator<? super SqlStatementData> dataComparator;

        private Column(String string2, int n2, String string3, boolean bl, boolean bl2, IDataComparator<? super SqlStatementData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.showInAggregatedMode = bl;
            this.showInRawMode = bl2;
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class SqlInvocContentProvider
    implements ITreeContentProvider {
        private SqlInvocContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            if (CollectionUtils.isEmpty((Collection)list)) {
                return new Object[0];
            }
            if (list.get(0) instanceof InvocationSequenceData) {
                SqlInvocInputController.this.sqlStatementDataList = this.getRawInputList(list, new ArrayList<SqlStatementData>());
            } else {
                SqlInvocInputController.this.sqlStatementDataList = list;
            }
            if (!SqlInvocInputController.this.rawMode) {
                AggregationPerformer aggregationPerformer = new AggregationPerformer((IAggregator)new SqlStatementDataAggregator());
                aggregationPerformer.processCollection((Collection)SqlInvocInputController.this.sqlStatementDataList);
                SqlInvocInputController.this.sqlStatementDataList = aggregationPerformer.getResultList();
                SqlInvocInputController.this.databaseSqlMap = this.createInputMap(SqlInvocInputController.this.sqlStatementDataList);
                return SqlInvocInputController.this.databaseSqlMap.keySet().toArray();
            }
            Collections.sort(SqlInvocInputController.this.sqlStatementDataList, new Comparator<SqlStatementData>(){

                @Override
                public int compare(SqlStatementData sqlStatementData, SqlStatementData sqlStatementData2) {
                    return sqlStatementData.getTimeStamp().compareTo(sqlStatementData2.getTimeStamp());
                }
            });
            return SqlInvocInputController.this.sqlStatementDataList.toArray();
        }

        private Map<DatabaseInfoHelper, List<SqlStatementData>> createInputMap(List<SqlStatementData> list) {
            HashMap<DatabaseInfoHelper, List<SqlStatementData>> hashMap = new HashMap<DatabaseInfoHelper, List<SqlStatementData>>();
            for (SqlStatementData sqlStatementData : list) {
                DatabaseInfoHelper databaseInfoHelper = new DatabaseInfoHelper(sqlStatementData);
                ArrayList<SqlStatementData> arrayList = (ArrayList<SqlStatementData>)hashMap.get(databaseInfoHelper);
                if (arrayList == null) {
                    arrayList = new ArrayList<SqlStatementData>();
                    hashMap.put(databaseInfoHelper, arrayList);
                }
                arrayList.add(sqlStatementData);
            }
            return hashMap;
        }

        private List<SqlStatementData> getRawInputList(List<InvocationSequenceData> list, List<SqlStatementData> list2) {
            for (InvocationSequenceData invocationSequenceData : list) {
                if (invocationSequenceData.getSqlStatementData() != null) {
                    list2.add(invocationSequenceData.getSqlStatementData());
                }
                if (invocationSequenceData.getNestedSequences() == null || invocationSequenceData.getNestedSequences().isEmpty()) continue;
                this.getRawInputList(invocationSequenceData.getNestedSequences(), list2);
            }
            return list2;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object object) {
            List list;
            if (object instanceof DatabaseInfoHelper && CollectionUtils.isNotEmpty((Collection)(list = (List)SqlInvocInputController.this.databaseSqlMap.get(object)))) {
                return list.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (!SqlInvocInputController.this.rawMode && object instanceof SqlStatementData) {
                return new DatabaseInfoHelper((SqlStatementData)object);
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return object instanceof DatabaseInfoHelper;
        }
    }

    private final class SqlInvocLabelProvider
    extends StyledCellIndexLabelProvider {
        private SqlInvocLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            Column column = Column.fromOrd(n);
            if (object instanceof SqlStatementData) {
                return SqlInvocInputController.this.getStyledTextForColumn((SqlStatementData)object, column);
            }
            if (object instanceof DatabaseInfoHelper) {
                return SqlInvocInputController.this.getDatabaseStyledTextForColumn((DatabaseInfoHelper)object, column);
            }
            return SqlInvocInputController.this.emptyStyledString;
        }

        @Override
        public String getToolTipText(Object object, int n) {
            if (object instanceof DatabaseInfoHelper) {
                DatabaseInfoHelper databaseInfoHelper = (DatabaseInfoHelper)object;
                return databaseInfoHelper.getLongText();
            }
            return super.getToolTipText(object, n);
        }
    }
}

