/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree.input;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.ISqlDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.InvocationAwareDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.comparator.SqlStatementDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.TimerDataComparatorEnum;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.SqlStatementInputDefinitionExtra;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.text.input.SqlStatementTextInputController;
import info.novatec.inspectit.rcp.editor.tree.input.AbstractTreeInputController;
import info.novatec.inspectit.rcp.editor.tree.util.DatabaseSqlTreeComparator;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.util.data.DatabaseInfoHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SqlInputController
extends AbstractTreeInputController {
    public static final String ID = "inspectit.subview.tree.sql";
    private static final StyledString EMPTY_STYLED_STRING = new StyledString("");
    private SqlStatementData template;
    private Map<DatabaseInfoHelper, List<SqlStatementData>> inputMap = new HashMap<DatabaseInfoHelper, List<SqlStatementData>>();
    private ISqlDataAccessService dataAccessService;
    private ICachedDataService cachedDataService;
    private Date fromDate = null;
    private Date toDate = null;
    private boolean autoUpdate = false;
    private int timeDecimalPlaces = PreferencesUtils.getIntValue("DECIMAL_PLACES");

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new SqlStatementData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setId(-1L);
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.SQL_STATEMENT_EXTRAS_MARKER)) {
            SqlStatementInputDefinitionExtra sqlStatementInputDefinitionExtra = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.SQL_STATEMENT_EXTRAS_MARKER);
            this.template.setSql(sqlStatementInputDefinitionExtra.getSql());
        }
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getSqlDataAccessService();
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TreeViewer treeViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
            treeViewerColumn.getColumn().setMoveable(true);
            treeViewerColumn.getColumn().setResizable(true);
            treeViewerColumn.getColumn().setText(column.name);
            treeViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                treeViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTreeViewerColumn(column, treeViewerColumn);
            ++n2;
        }
    }

    @Override
    public Object getTreeInput() {
        return this.inputMap.keySet();
    }

    @Override
    public IContentProvider getContentProvider() {
        return new SqlContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new SqlLabelProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        DatabaseSqlTreeComparator databaseSqlTreeComparator = new DatabaseSqlTreeComparator();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            if (column.dataComparator != null) {
                ResultComparator resultComparator = new ResultComparator(column.dataComparator, this.cachedDataService);
                databaseSqlTreeComparator.addColumn(this.getMappedTreeViewerColumn(column).getColumn(), resultComparator);
            }
            ++n2;
        }
        return databaseSqlTreeComparator;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.TIME_RESOLUTION);
        enumSet.add(PreferenceId.TIMELINE);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case TIMELINE: {
                if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                    this.fromDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.FROM_DATE_ID);
                }
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.TO_DATE_ID)) break;
                this.toDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.TO_DATE_ID);
                break;
            }
            case LIVEMODE: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.LiveMode.BUTTON_LIVE_ID)) break;
                this.autoUpdate = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
                break;
            }
            case TIME_RESOLUTION: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID)) break;
                this.timeDecimalPlaces = (Integer)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID);
                break;
            }
        }
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list != null) {
            for (DefaultData defaultData : list) {
                if (defaultData instanceof SqlStatementData) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, final IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Getting SQL information", -1);
        List list = this.autoUpdate ? this.dataAccessService.getAggregatedSqlStatements(this.template) : this.dataAccessService.getAggregatedSqlStatements(this.template, this.fromDate, this.toDate);
        this.inputMap.clear();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.inputMap.putAll(this.createInputMap(list));
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (iRootEditor != null) {
                    iRootEditor.setDataInput(Collections.emptyList());
                }
            }
        });
        iProgressMonitor.done();
    }

    private Map<DatabaseInfoHelper, List<SqlStatementData>> createInputMap(List<SqlStatementData> list) {
        HashMap<DatabaseInfoHelper, List<SqlStatementData>> hashMap = new HashMap<DatabaseInfoHelper, List<SqlStatementData>>();
        for (SqlStatementData sqlStatementData : list) {
            DatabaseInfoHelper databaseInfoHelper = new DatabaseInfoHelper(sqlStatementData);
            ArrayList<SqlStatementData> arrayList = (ArrayList<SqlStatementData>)hashMap.get(databaseInfoHelper);
            if (arrayList == null) {
                arrayList = new ArrayList<SqlStatementData>();
                hashMap.put(databaseInfoHelper, arrayList);
            }
            arrayList.add(sqlStatementData);
        }
        return hashMap;
    }

    @Override
    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        final StructuredSelection structuredSelection = (StructuredSelection)doubleClickEvent.getSelection();
        if (!structuredSelection.isEmpty() && structuredSelection.getFirstElement() instanceof SqlStatementData) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        boolean bl;
                        iProgressMonitor.beginTask("Retrieving Parameter Aggregated SQLs", -1);
                        SqlStatementData sqlStatementData = (SqlStatementData)structuredSelection.getFirstElement();
                        List list = Collections.emptyList();
                        boolean bl2 = bl = !sqlStatementData.isPreparedStatement();
                        if (sqlStatementData.isPreparedStatement() && (list = SqlInputController.this.dataAccessService.getParameterAggregatedSqlStatements(sqlStatementData, SqlInputController.this.fromDate, SqlInputController.this.toDate)).size() == 1 && CollectionUtils.isEmpty((Collection)((SqlStatementData)list.get(0)).getParameterValues())) {
                            bl = true;
                        }
                        if (bl) {
                            final SqlStatementTextInputController.SqlHolderHelper sqlHolderHelper = new SqlStatementTextInputController.SqlHolderHelper(Collections.emptyList(), true);
                            final SqlStatementTextInputController.SqlHolderHelper sqlHolderHelper2 = new SqlStatementTextInputController.SqlHolderHelper(Collections.singletonList(sqlStatementData), false);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                                    IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                                    if (iRootEditor != null) {
                                        iRootEditor.setDataInput(Collections.singletonList(sqlHolderHelper));
                                        iRootEditor.setDataInput(Collections.singletonList(sqlHolderHelper2));
                                    }
                                }
                            });
                        } else {
                            final SqlStatementTextInputController.SqlHolderHelper sqlHolderHelper = new SqlStatementTextInputController.SqlHolderHelper(list, true);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                                    IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                                    if (iRootEditor != null) {
                                        iRootEditor.setDataInput(Collections.singletonList(sqlHolderHelper));
                                    }
                                }
                            });
                        }
                        iProgressMonitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Error", (String)invocationTargetException.getCause().toString());
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Cancelled", (String)interruptedException.getCause().toString());
            }
        }
    }

    @Override
    public int getExpandLevel() {
        return -1;
    }

    private StyledString getSqlStyledTextForColumn(SqlStatementData sqlStatementData, Column column) {
        switch (column) {
            case STATEMENT: {
                String string = sqlStatementData.getSql().replaceAll("[\r\n]+", " ");
                return new StyledString(string);
            }
            case INVOCATION_AFFILLIATION: {
                int n = (int)(sqlStatementData.getInvocationAffiliationPercentage() * 100.0);
                int n2 = 0;
                if (sqlStatementData.getInvocationParentsIdSet() != null) {
                    n2 = sqlStatementData.getInvocationParentsIdSet().size();
                }
                return TextFormatter.getInvocationAffilliationPercentageString(n, n2);
            }
            case COUNT: {
                return new StyledString(Long.toString(sqlStatementData.getCount()));
            }
            case AVERAGE: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getAverage(), this.timeDecimalPlaces));
            }
            case MIN: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getMin(), this.timeDecimalPlaces));
            }
            case MAX: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getMax(), this.timeDecimalPlaces));
            }
            case DURATION: {
                return new StyledString(NumberFormatter.formatDouble(sqlStatementData.getDuration(), this.timeDecimalPlaces));
            }
            case PREPARED: {
                if (sqlStatementData.isPreparedStatement()) {
                    return new StyledString("true");
                }
                return new StyledString("false");
            }
        }
        return EMPTY_STYLED_STRING;
    }

    private StyledString getDatabaseStyledTextForColumn(DatabaseInfoHelper databaseInfoHelper, Column column) {
        switch (column) {
            case DATABASE_URL: {
                return new StyledString(databaseInfoHelper.getDatabaseUrl());
            }
        }
        return EMPTY_STYLED_STRING;
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getSqlStyledTextForColumn(sqlStatementData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        if (object instanceof DatabaseInfoHelper) {
            DatabaseInfoHelper databaseInfoHelper = (DatabaseInfoHelper)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n3 = 0;
            while (n3 < n) {
                Column column = columnArray[n3];
                stringBuilder.append(this.getDatabaseStyledTextForColumn(databaseInfoHelper, column).toString());
                stringBuilder.append('\t');
                ++n3;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getSqlStyledTextForColumn(sqlStatementData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        if (object instanceof DatabaseInfoHelper) {
            DatabaseInfoHelper databaseInfoHelper = (DatabaseInfoHelper)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n3 = 0;
            while (n3 < n) {
                Column column = columnArray[n3];
                arrayList.add(this.getDatabaseStyledTextForColumn(databaseInfoHelper, column).toString());
                ++n3;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        ArrayList<SqlStatementData> arrayList = new ArrayList<SqlStatementData>();
        for (List<SqlStatementData> list : this.inputMap.values()) {
            arrayList.addAll(list);
        }
        return arrayList.toArray();
    }

    @Override
    public void dispose() {
        this.inputMap.clear();
    }

    private static enum Column {
        DATABASE_URL("Database URL", 120, null, null),
        STATEMENT("Statement", 600, "/icons/fugue/database-sql.png", (IDataComparator<? super SqlStatementData>)SqlStatementDataComparatorEnum.SQL),
        INVOCATION_AFFILLIATION("In Invocations", 120, "/icons/fugue/arrow-switch.png", (IDataComparator<? super SqlStatementData>)InvocationAwareDataComparatorEnum.INVOCATION_AFFILIATION),
        COUNT("Count", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.COUNT),
        AVERAGE("Avg (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.AVERAGE),
        MIN("Min (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.MIN),
        MAX("Max (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.MAX),
        DURATION("Duration (ms)", 80, null, (IDataComparator<? super SqlStatementData>)TimerDataComparatorEnum.MAX),
        PREPARED("Prepared?", 80, null, (IDataComparator<? super SqlStatementData>)SqlStatementDataComparatorEnum.IS_PREPARED_STATEMENT);

        private String name;
        private int width;
        private Image image;
        private IDataComparator<? super SqlStatementData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super SqlStatementData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class SqlContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private SqlContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof DatabaseInfoHelper) {
                return ((List)SqlInputController.this.inputMap.get(object)).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof SqlStatementData) {
                return new DatabaseInfoHelper((SqlStatementData)object);
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return object instanceof DatabaseInfoHelper;
        }
    }

    private final class SqlLabelProvider
    extends StyledCellIndexLabelProvider {
        private SqlLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            Column column = Column.fromOrd(n);
            if (object instanceof SqlStatementData) {
                return SqlInputController.this.getSqlStyledTextForColumn((SqlStatementData)object, column);
            }
            if (object instanceof DatabaseInfoHelper) {
                return SqlInputController.this.getDatabaseStyledTextForColumn((DatabaseInfoHelper)object, column);
            }
            return EMPTY_STYLED_STRING;
        }

        @Override
        public String getToolTipText(Object object, int n) {
            if (object instanceof DatabaseInfoHelper) {
                DatabaseInfoHelper databaseInfoHelper = (DatabaseInfoHelper)object;
                return databaseInfoHelper.getLongText();
            }
            return super.getToolTipText(object, n);
        }
    }
}

