/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpInfo;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.InvocationSequenceDataHelper;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.tree.input.AbstractTreeInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.ExceptionImageFactory;
import info.novatec.inspectit.rcp.model.ModifiersImageFactory;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class InvocDetailInputController
extends AbstractTreeInputController {
    public static final String ID = "inspectit.subview.tree.invocdetail";
    private double invocationDuration = 0.0;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Set<Class<?>> selectedDataTypes = (Set)PreferencesUtils.getObject("INVOCATION_FILTER_DATA_TYPES");
    private double defaultExclusiveFilterTime = PreferencesUtils.getDoubleValue("INVOCATION_FILTER_EXCLUSIVE_TIME");
    private double defaultTotalFilterTime = PreferencesUtils.getDoubleValue("INVOCATION_FILTER_TOTAL_TIME");
    private ICachedDataService cachedDataService;
    private Object input;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TreeViewer treeViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
            treeViewerColumn.getColumn().setMoveable(true);
            treeViewerColumn.getColumn().setResizable(true);
            treeViewerColumn.getColumn().setText(column.name);
            treeViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                treeViewerColumn.getColumn().setImage(column.image);
            }
            ++n2;
        }
    }

    @Override
    public Object getTreeInput() {
        return this.input;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new InvocDetailContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new InvocDetailLabelProvider();
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        enumSet.add(PreferenceId.FILTERDATATYPE);
        enumSet.add(PreferenceId.INVOCFILTEREXCLUSIVETIME);
        enumSet.add(PreferenceId.INVOCFILTERTOTALTIME);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case FILTERDATATYPE: {
                Class clazz = (Class)preferenceEvent.getPreferenceMap().get(PreferenceId.DataTypeSelection.SENSOR_DATA_SELECTION_ID);
                if (this.selectedDataTypes.contains(clazz)) {
                    this.selectedDataTypes.remove(clazz);
                    break;
                }
                this.selectedDataTypes.add(clazz);
                break;
            }
            case INVOCFILTEREXCLUSIVETIME: {
                this.defaultExclusiveFilterTime = (Double)preferenceEvent.getPreferenceMap().get(PreferenceId.InvocExclusiveTimeSelection.TIME_SELECTION_ID);
                break;
            }
            case INVOCFILTERTOTALTIME: {
                this.defaultTotalFilterTime = (Double)preferenceEvent.getPreferenceMap().get(PreferenceId.InvocTotalTimeSelection.TIME_SELECTION_ID);
                break;
            }
        }
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        if (list.size() != 1) {
            return false;
        }
        if (!(list.get(0) instanceof InvocationSequenceData)) {
            return false;
        }
        this.invocationDuration = ((InvocationSequenceData)list.get(0)).getDuration();
        return true;
    }

    private static StyledString getStyledTextForColumn(InvocationSequenceData invocationSequenceData, MethodIdent methodIdent, Column column) {
        StyledString styledString = null;
        switch (column) {
            case METHOD: {
                return TextFormatter.getStyledMethodString(methodIdent);
            }
            case START_DELTA: {
                InvocationSequenceData invocationSequenceData2 = invocationSequenceData;
                while (!InvocationSequenceDataHelper.isRootElementInSequence((InvocationSequenceData)invocationSequenceData2)) {
                    invocationSequenceData2 = invocationSequenceData2.getParentSequence();
                }
                long l = invocationSequenceData.getTimeStamp().getTime() - invocationSequenceData2.getTimeStamp().getTime();
                return new StyledString(NumberFormatter.formatLong(l));
            }
            case DURATION: {
                styledString = new StyledString();
                double d = InvocationSequenceDataHelper.calculateDuration((InvocationSequenceData)invocationSequenceData);
                if (-1.0 != d) {
                    styledString.append(NumberFormatter.formatDouble(d));
                }
                return styledString;
            }
            case CPUDURATION: {
                styledString = new StyledString();
                if (InvocationSequenceDataHelper.hasTimerData((InvocationSequenceData)invocationSequenceData) && invocationSequenceData.getTimerData().isCpuMetricDataAvailable()) {
                    styledString.append(NumberFormatter.formatDouble(invocationSequenceData.getTimerData().getCpuDuration()));
                }
                return styledString;
            }
            case EXCLUSIVE: {
                styledString = new StyledString();
                double d = InvocationSequenceDataHelper.calculateDuration((InvocationSequenceData)invocationSequenceData);
                if (-1.0 != d) {
                    double d2 = d - InvocationSequenceDataHelper.computeNestedDuration((InvocationSequenceData)invocationSequenceData);
                    styledString.append(NumberFormatter.formatDouble(d2));
                }
                return styledString;
            }
            case SQL: {
                styledString = new StyledString();
                if (InvocationSequenceDataHelper.hasSQLData((InvocationSequenceData)invocationSequenceData)) {
                    styledString.append(TextFormatter.clearLineBreaks(invocationSequenceData.getSqlStatementData().getSqlWithParameterValues()));
                }
                return styledString;
            }
            case PARAMETER: {
                Object object;
                HttpInfo httpInfo;
                styledString = new StyledString();
                if (InvocationSequenceDataHelper.hasHttpTimerData((InvocationSequenceData)invocationSequenceData) && (httpInfo = (object = (HttpTimerData)invocationSequenceData.getTimerData()).getHttpInfo()).getUri() != null) {
                    styledString.append("URI: ");
                    styledString.append(httpInfo.getUri());
                    styledString.append(" | ");
                }
                if (InvocationSequenceDataHelper.hasCapturedParameters((InvocationSequenceData)invocationSequenceData)) {
                    object = InvocationSequenceDataHelper.getCapturedParameters((InvocationSequenceData)invocationSequenceData, (boolean)true);
                    boolean bl = true;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ParameterContentData parameterContentData = (ParameterContentData)iterator.next();
                        if (!bl) {
                            styledString.append(", ");
                        } else {
                            bl = false;
                        }
                        styledString.append("'");
                        styledString.append(parameterContentData.getName());
                        styledString.append("': ");
                        styledString.append(TextFormatter.clearLineBreaks(parameterContentData.getContent()));
                    }
                }
                if (InvocationSequenceDataHelper.hasLoggingData((InvocationSequenceData)invocationSequenceData)) {
                    object = invocationSequenceData.getLoggingData();
                    styledString.append("[" + object.getLevel().toUpperCase() + "] ");
                    styledString.append(object.getMessage());
                }
                return styledString;
            }
        }
        return styledString;
    }

    @Override
    public ViewerFilter[] getFilters() {
        InvocationViewerFilter invocationViewerFilter = new InvocationViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof InvocationSequenceData) {
                    InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object2;
                    if (this.checkIsOnlyInvocation(invocationSequenceData) && this.checkSensorDataTypeForObject(invocationSequenceData)) {
                        return true;
                    }
                    if (this.checkSensorDataTypeForObject(invocationSequenceData.getTimerData())) {
                        return true;
                    }
                    if (this.checkSensorDataTypeForObject(invocationSequenceData.getSqlStatementData())) {
                        return true;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)invocationSequenceData.getExceptionSensorDataObjects())) {
                        return this.checkSensorDataTypeForObject(invocationSequenceData.getExceptionSensorDataObjects().get(0));
                    }
                    return false;
                }
                return true;
            }

            private boolean checkSensorDataTypeForObject(Object object) {
                if (object != null) {
                    return InvocDetailInputController.this.selectedDataTypes.contains(object.getClass());
                }
                return false;
            }

            private boolean checkIsOnlyInvocation(InvocationSequenceData invocationSequenceData) {
                return invocationSequenceData.getTimerData() == null && invocationSequenceData.getSqlStatementData() == null && CollectionUtils.isEmpty((Collection)invocationSequenceData.getExceptionSensorDataObjects());
            }
        };
        InvocationViewerFilter invocationViewerFilter2 = new InvocationViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (Double.isNaN(InvocDetailInputController.this.defaultExclusiveFilterTime)) {
                    return true;
                }
                if (object2 instanceof InvocationSequenceData) {
                    InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object2;
                    double d = Double.NaN;
                    if (InvocationSequenceDataHelper.hasSQLData((InvocationSequenceData)invocationSequenceData)) {
                        d = invocationSequenceData.getSqlStatementData().getDuration();
                    } else if (InvocationSequenceDataHelper.hasTimerData((InvocationSequenceData)invocationSequenceData)) {
                        double d2 = invocationSequenceData.getTimerData().getDuration();
                        d = d2 - InvocationSequenceDataHelper.computeNestedDuration((InvocationSequenceData)invocationSequenceData);
                    } else if (InvocationSequenceDataHelper.isRootElementInSequence((InvocationSequenceData)invocationSequenceData)) {
                        d = invocationSequenceData.getDuration() - InvocationSequenceDataHelper.computeNestedDuration((InvocationSequenceData)invocationSequenceData);
                    }
                    if (!Double.isNaN(d) && d <= InvocDetailInputController.this.defaultExclusiveFilterTime) {
                        return false;
                    }
                }
                return true;
            }
        };
        InvocationViewerFilter invocationViewerFilter3 = new InvocationViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                InvocationSequenceData invocationSequenceData;
                double d;
                if (Double.isNaN(InvocDetailInputController.this.defaultTotalFilterTime)) {
                    return true;
                }
                return !(object2 instanceof InvocationSequenceData) || (d = InvocationSequenceDataHelper.calculateDuration((InvocationSequenceData)(invocationSequenceData = (InvocationSequenceData)object2))) == -1.0 || !(d <= InvocDetailInputController.this.defaultTotalFilterTime);
            }
        };
        return new ViewerFilter[]{invocationViewerFilter, invocationViewerFilter2, invocationViewerFilter3};
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof InvocationSequenceData) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            StringBuilder stringBuilder = new StringBuilder();
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(InvocDetailInputController.getStyledTextForColumn(invocationSequenceData, methodIdent, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof InvocationSequenceData) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(InvocDetailInputController.getStyledTextForColumn(invocationSequenceData, methodIdent, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        List list = (List)object;
        if (!list.isEmpty()) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)list.get(0);
            ArrayList<InvocationSequenceData> arrayList = new ArrayList<InvocationSequenceData>((int)invocationSequenceData.getChildCount());
            this.extractAllChildren(arrayList, invocationSequenceData);
            return arrayList.toArray();
        }
        return new Object[0];
    }

    private void extractAllChildren(List<InvocationSequenceData> list, InvocationSequenceData invocationSequenceData) {
        list.add(invocationSequenceData);
        for (InvocationSequenceData invocationSequenceData2 : invocationSequenceData.getNestedSequences()) {
            this.extractAllChildren(list, invocationSequenceData2);
        }
    }

    @Override
    public void dispose() {
        this.resourceManager.dispose();
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.SLAVE;
    }

    private static enum Column {
        METHOD("Method", 700, "/icons/eclipse/call_hierarchy.gif"),
        DURATION("Duration (ms)", 100, "/icons/eclipse/time.gif"),
        EXCLUSIVE("Exc. duration (ms)", 100, null),
        CPUDURATION("Cpu Duration (ms)", 100, null),
        START_DELTA("Start Delta (ms)", 100, "/icons/eclipse/time_delta.gif"),
        SQL("SQL", 300, "/icons/fugue/database-sql.png"),
        PARAMETER("Parameter Content", 200, null);

        private String name;
        private int width;
        private Image image;

        private Column(String string2, int n2, String string3) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class InvocDetailContentProvider
    implements ITreeContentProvider {
        private DeferredTreeContentManager manager;

        private InvocDetailContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (this.manager.isDeferredAdapter(object)) {
                Object[] objectArray = this.manager.getChildren(object);
                return objectArray;
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof InvocationSequenceData) {
                InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
                return invocationSequenceData.getParentSequence();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            InvocationSequenceData invocationSequenceData;
            if (object == null) {
                return false;
            }
            return object instanceof InvocationSequenceData && !(invocationSequenceData = (InvocationSequenceData)object).getNestedSequences().isEmpty();
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            return list.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
            InvocDetailInputController.this.input = object2;
        }

        public void dispose() {
        }
    }

    private final class InvocDetailLabelProvider
    extends StyledCellIndexLabelProvider {
        private InvocDetailLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            MethodIdent methodIdent = InvocDetailInputController.this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            Column column = Column.fromOrd(n);
            return InvocDetailInputController.getStyledTextForColumn(invocationSequenceData, methodIdent, column);
        }

        @Override
        public Image getColumnImage(Object object, int n) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            MethodIdent methodIdent = InvocDetailInputController.this.cachedDataService.getMethodIdentForId(invocationSequenceData.getMethodIdent());
            Column column = Column.fromOrd(n);
            switch (column) {
                case METHOD: {
                    ExceptionSensorData exceptionSensorData = null;
                    Image image = ModifiersImageFactory.getImage(methodIdent.getModifiers());
                    if (InvocationSequenceDataHelper.hasExceptionData((InvocationSequenceData)invocationSequenceData)) {
                        exceptionSensorData = (ExceptionSensorData)invocationSequenceData.getExceptionSensorDataObjects().get(invocationSequenceData.getExceptionSensorDataObjects().size() - 1);
                        image = ExceptionImageFactory.decorateImageWithException(image, exceptionSensorData, (ResourceManager)InvocDetailInputController.this.resourceManager);
                    }
                    return image;
                }
                case DURATION: {
                    return null;
                }
                case CPUDURATION: {
                    return null;
                }
                case EXCLUSIVE: {
                    return null;
                }
                case SQL: {
                    return null;
                }
                case PARAMETER: {
                    return null;
                }
            }
            return null;
        }

        @Override
        protected Color getBackground(Object object, int n) {
            InvocationSequenceData invocationSequenceData = (InvocationSequenceData)object;
            double d = InvocationSequenceDataHelper.calculateDuration((InvocationSequenceData)invocationSequenceData);
            if (-1.0 != d) {
                double d2 = d - InvocationSequenceDataHelper.computeNestedDuration((InvocationSequenceData)invocationSequenceData);
                int n2 = 255 - (int)(d2 / InvocDetailInputController.this.invocationDuration * 100.0);
                if (n2 > 255 || n2 < 0) {
                    InspectIT.getDefault().createErrorDialog("The computation of the color value for the detail view returned an invalid value: " + n2, null, -1);
                    return null;
                }
                Color color = InvocDetailInputController.this.resourceManager.createColor(new RGB(n2, n2, n2));
                return color;
            }
            return null;
        }
    }

    private abstract class InvocationViewerFilter
    extends ViewerFilter {
        private InvocationViewerFilter() {
        }

        public Object[] filter(Viewer viewer, Object object, Object[] objectArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                InvocationSequenceData invocationSequenceData;
                Object object2 = objectArray2[n2];
                if (this.select(viewer, object, object2)) {
                    arrayList.add(object2);
                } else if (object2 instanceof InvocationSequenceData && (invocationSequenceData = (InvocationSequenceData)object2).getChildCount() > 0L) {
                    arrayList.addAll(Arrays.asList(this.filter(viewer, object, invocationSequenceData.getNestedSequences().toArray())));
                }
                ++n2;
            }
            return arrayList.toArray();
        }
    }
}

