/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.tree.input.AbstractTreeInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.ExceptionImageFactory;
import info.novatec.inspectit.rcp.model.ModifiersImageFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ExceptionTreeInputController
extends AbstractTreeInputController {
    public static final String ID = "inspectit.subview.tree.exceptiontree";
    private List<ExceptionSensorData> exceptionSensorData = new ArrayList<ExceptionSensorData>();
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private ICachedDataService cachedDataService;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public int getExpandLevel() {
        return -1;
    }

    @Override
    public void createColumns(TreeViewer treeViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
            treeViewerColumn.getColumn().setMoveable(true);
            treeViewerColumn.getColumn().setResizable(true);
            treeViewerColumn.getColumn().setText(column.name);
            treeViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                treeViewerColumn.getColumn().setImage(column.image);
            }
            ++n2;
        }
    }

    @Override
    public Object getTreeInput() {
        return this.exceptionSensorData;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new ExceptionTreeContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new ExceptionTreeLabelProvider();
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        return list.get(0) instanceof ExceptionSensorData;
    }

    private static StyledString getStyledTextForColumn(ExceptionSensorData exceptionSensorData, MethodIdent methodIdent, Column column) {
        StyledString styledString = null;
        switch (column) {
            case METHOD_CONSTRUCTOR: {
                return new StyledString(TextFormatter.getMethodWithParameters(methodIdent));
            }
            case EVENT_TYPE: {
                styledString = new StyledString(exceptionSensorData.getExceptionEvent().toString());
                return styledString;
            }
            case ERROR_MESSAGE: {
                styledString = new StyledString();
                if (exceptionSensorData.getErrorMessage() != null) {
                    styledString.append(exceptionSensorData.getErrorMessage());
                }
                return styledString;
            }
            case CAUSE: {
                styledString = new StyledString();
                if (exceptionSensorData.getCause() != null) {
                    styledString.append(exceptionSensorData.getCause().toString());
                }
                return styledString;
            }
        }
        return styledString;
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            StringBuilder stringBuilder = new StringBuilder();
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(ExceptionTreeInputController.getStyledTextForColumn(exceptionSensorData, methodIdent, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(ExceptionTreeInputController.getStyledTextForColumn(exceptionSensorData, methodIdent, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        ArrayList<ExceptionSensorData> arrayList = new ArrayList<ExceptionSensorData>();
        List list = (List)object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ExceptionSensorData exceptionSensorData;
            ExceptionSensorData exceptionSensorData2 = exceptionSensorData = (ExceptionSensorData)iterator.next();
            while (exceptionSensorData2 != null) {
                arrayList.add(exceptionSensorData2);
                exceptionSensorData2 = exceptionSensorData2.getChild();
            }
        }
        return arrayList.toArray();
    }

    @Override
    public void dispose() {
        this.resourceManager.dispose();
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.SLAVE;
    }

    private static enum Column {
        EVENT_TYPE("Event Type", 280, null),
        METHOD_CONSTRUCTOR("Method / Constructor", 500, "/icons/eclipse/method.gif"),
        ERROR_MESSAGE("Error Message", 250, null),
        CAUSE("Cause", 120, null);

        private String name;
        private int width;
        private Image image;

        private Column(String string2, int n2, String string3) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private static final class ExceptionTreeContentProvider
    implements ITreeContentProvider {
        private ExceptionTreeContentProvider() {
        }

        public Object[] getChildren(Object object) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            ArrayList<ExceptionSensorData> arrayList = new ArrayList<ExceptionSensorData>();
            arrayList.add(exceptionSensorData.getChild());
            return arrayList.toArray();
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            ExceptionSensorData exceptionSensorData;
            if (object == null) {
                return false;
            }
            return object instanceof ExceptionSensorData && (exceptionSensorData = (ExceptionSensorData)object).getChild() != null;
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            return list.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private final class ExceptionTreeLabelProvider
    extends StyledCellIndexLabelProvider {
        private ExceptionTreeLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            MethodIdent methodIdent = ExceptionTreeInputController.this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            Column column = Column.fromOrd(n);
            return ExceptionTreeInputController.getStyledTextForColumn(exceptionSensorData, methodIdent, column);
        }

        @Override
        public Image getColumnImage(Object object, int n) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            MethodIdent methodIdent = ExceptionTreeInputController.this.cachedDataService.getMethodIdentForId(exceptionSensorData.getMethodIdent());
            Column column = Column.fromOrd(n);
            switch (column) {
                case METHOD_CONSTRUCTOR: {
                    Image image = ModifiersImageFactory.getImage(methodIdent.getModifiers());
                    image = ExceptionImageFactory.decorateImageWithException(image, exceptionSensorData, (ResourceManager)ExceptionTreeInputController.this.resourceManager);
                    return image;
                }
                case EVENT_TYPE: {
                    return null;
                }
                case ERROR_MESSAGE: {
                    return null;
                }
                case CAUSE: {
                    return null;
                }
            }
            return null;
        }

        @Override
        protected Color getBackground(Object object, int n) {
            return null;
        }
    }
}

