/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree.input;

import info.novatec.inspectit.cmr.service.IExceptionDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.tree.input.AbstractTreeInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class ExceptionMessagesTreeInputController
extends AbstractTreeInputController {
    public static final String ID = "inspectit.subview.tree.exceptionmessagestree";
    private static final int MAX_ERROR_MSG_SIZE = 150;
    private static final String STACK_TRACK_NOT_AVAILABLE = "Stack track not available";
    private static final String NO_ERROR_MESSAGE_PROVIDED = "No Error Message provided";
    private IExceptionDataAccessService dataAccessService;
    private Map<AggregatedExceptionSensorData, List<ExceptionSensorData>> parentChildrenMap;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getExceptionDataAccessService();
    }

    @Override
    public void createColumns(TreeViewer treeViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
            treeViewerColumn.getColumn().setMoveable(true);
            treeViewerColumn.getColumn().setResizable(true);
            treeViewerColumn.getColumn().setText(column.name);
            treeViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                treeViewerColumn.getColumn().setImage(column.image);
            }
            ++n2;
        }
    }

    @Override
    public int getExpandLevel() {
        return 0;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new ExceptionMessagesTreeContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new ExceptionMessagesTreeLabelProvider();
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        return list.get(0) instanceof AggregatedExceptionSensorData;
    }

    private StyledString getStyledTextForColumn(ExceptionSensorData exceptionSensorData, Column column) {
        switch (column) {
            case ERROR_MESSAGE: {
                String[] stringArray;
                String string;
                StyledString styledString = this.parentChildrenMap.containsKey(exceptionSensorData) ? ((string = exceptionSensorData.getErrorMessage()) != null && !"".equals(string) ? new StyledString(TextFormatter.crop(TextFormatter.clearLineBreaks(string), 150)) : new StyledString(NO_ERROR_MESSAGE_PROVIDED)) : ((stringArray = exceptionSensorData.getStackTrace().split("\n")).length > 0 ? new StyledString(stringArray[0]) : new StyledString(STACK_TRACK_NOT_AVAILABLE));
                return styledString;
            }
            case INVOCATION_AFFILLIATION: {
                if (exceptionSensorData instanceof AggregatedExceptionSensorData) {
                    int n = (int)(exceptionSensorData.getInvocationAffiliationPercentage() * 100.0);
                    int n2 = 0;
                    if (exceptionSensorData.getInvocationParentsIdSet() != null) {
                        n2 = exceptionSensorData.getInvocationParentsIdSet().size();
                    }
                    return TextFormatter.getInvocationAffilliationPercentageString(n, n2);
                }
                return new StyledString("");
            }
            case CREATED: {
                if (exceptionSensorData instanceof AggregatedExceptionSensorData && ((AggregatedExceptionSensorData)exceptionSensorData).getCreated() >= 0L) {
                    return new StyledString(String.valueOf(((AggregatedExceptionSensorData)exceptionSensorData).getCreated()));
                }
                return new StyledString("");
            }
            case RETHROWN: {
                if (exceptionSensorData instanceof AggregatedExceptionSensorData && ((AggregatedExceptionSensorData)exceptionSensorData).getPassed() >= 0L) {
                    return new StyledString(String.valueOf(((AggregatedExceptionSensorData)exceptionSensorData).getPassed()));
                }
                return new StyledString("");
            }
            case HANDLED: {
                if (exceptionSensorData instanceof AggregatedExceptionSensorData && ((AggregatedExceptionSensorData)exceptionSensorData).getHandled() >= 0L) {
                    return new StyledString(String.valueOf(((AggregatedExceptionSensorData)exceptionSensorData).getHandled()));
                }
                return new StyledString("");
            }
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof AggregatedExceptionSensorData) {
            AggregatedExceptionSensorData aggregatedExceptionSensorData = (AggregatedExceptionSensorData)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn((ExceptionSensorData)aggregatedExceptionSensorData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof AggregatedExceptionSensorData) {
            AggregatedExceptionSensorData aggregatedExceptionSensorData = (AggregatedExceptionSensorData)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn((ExceptionSensorData)aggregatedExceptionSensorData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = (List)object;
        for (AggregatedExceptionSensorData aggregatedExceptionSensorData : list) {
            arrayList.add(aggregatedExceptionSensorData);
            List<ExceptionSensorData> list2 = this.parentChildrenMap.get(aggregatedExceptionSensorData);
            if (list2 == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList.toArray();
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.SLAVE;
    }

    private static enum Column {
        ERROR_MESSAGE("Error Message with Stack Trace", 450, "/icons/eclipse/class_obj.gif"),
        INVOCATION_AFFILLIATION("In Invocations", 120, "/icons/fugue/arrow-switch.png"),
        CREATED("Created", 70, null),
        RETHROWN("Rethrown", 70, null),
        HANDLED("Handled", 70, null);

        private String name;
        private int width;
        private Image image;

        private Column(String string2, int n2, String string3) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class ExceptionMessagesTreeContentProvider
    implements ITreeContentProvider {
        private ExceptionMessagesTreeContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            return list.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            List list = (List)object2;
            if (list != null && !list.isEmpty()) {
                ExceptionSensorData exceptionSensorData = (ExceptionSensorData)list.get(0);
                List list2 = ExceptionMessagesTreeInputController.this.dataAccessService.getStackTraceMessagesForThrowableType(exceptionSensorData);
                ExceptionMessagesTreeInputController.this.parentChildrenMap = new HashMap();
                int n = 1;
                for (AggregatedExceptionSensorData aggregatedExceptionSensorData : list) {
                    aggregatedExceptionSensorData.setId((long)n++);
                    ArrayList<ExceptionSensorData> arrayList = new ArrayList<ExceptionSensorData>();
                    for (ExceptionSensorData exceptionSensorData2 : list2) {
                        if (!ObjectUtils.equals((Object)exceptionSensorData2.getErrorMessage(), (Object)aggregatedExceptionSensorData.getErrorMessage())) continue;
                        arrayList.add(exceptionSensorData2);
                    }
                    ExceptionMessagesTreeInputController.this.parentChildrenMap.put(aggregatedExceptionSensorData, arrayList);
                }
            }
        }

        public Object[] getChildren(Object object) {
            if (object instanceof AggregatedExceptionSensorData && ExceptionMessagesTreeInputController.this.parentChildrenMap.containsKey(object)) {
                return ((List)ExceptionMessagesTreeInputController.this.parentChildrenMap.get(object)).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return object instanceof AggregatedExceptionSensorData && ExceptionMessagesTreeInputController.this.parentChildrenMap.containsKey(object);
        }

        public void dispose() {
        }
    }

    private final class ExceptionMessagesTreeLabelProvider
    extends StyledCellIndexLabelProvider {
        private ExceptionMessagesTreeLabelProvider() {
        }

        @Override
        protected StyledString getStyledText(Object object, int n) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)object;
            Column column = Column.fromOrd(n);
            return ExceptionMessagesTreeInputController.this.getStyledTextForColumn(exceptionSensorData, column);
        }
    }
}

