/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class DeferredTreeViewer
extends TreeViewer {
    private Map<Widget, Integer> parentWidgets = Collections.synchronizedMap(new HashMap());
    private Set<Object> objectsToBeExpanded = Collections.synchronizedSet(new HashSet());
    private AtomicReference<Object> objectToSelect = new AtomicReference();

    public DeferredTreeViewer(Composite composite) {
        super(composite);
    }

    public DeferredTreeViewer(Tree tree) {
        super(tree);
    }

    public DeferredTreeViewer(Composite composite, int n) {
        super(composite, n);
    }

    protected void internalAdd(Widget widget, Object object, Object[] objectArray) {
        Object object2;
        int n;
        Object[] objectArray2;
        Object object3;
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n2 = 0;
        while (n2 < viewerFilterArray.length) {
            object3 = viewerFilterArray[n2];
            objectArray = object3.filter((Viewer)this, object, objectArray);
            ++n2;
        }
        super.internalAdd(widget, object, objectArray);
        if (this.parentWidgets.containsKey(widget)) {
            objectArray2 = objectArray;
            n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object object4 = objectArray2[n3];
                if (super.isExpandable(object4)) {
                    Integer n4 = this.parentWidgets.get(widget);
                    if (n4 == -1) {
                        super.expandToLevel(object4, -1);
                    } else {
                        super.expandToLevel(object4, n4 - 1);
                    }
                }
                ++n3;
            }
        }
        if (this.objectsToBeExpanded != null && !this.objectsToBeExpanded.isEmpty()) {
            objectArray2 = objectArray;
            n = objectArray.length;
            int n5 = 0;
            while (n5 < n) {
                Object object5 = objectArray2[n5];
                if (this.objectsToBeExpanded.contains(object5) && !this.getExpandedState(object5)) {
                    super.expandToLevel(object5, 1);
                }
                ++n5;
            }
        }
        while ((object2 = this.objectToSelect.get()) != null && (!this.isRootElement(object2) || this.getExpandedState(this.getParentElement(object2)))) {
            object3 = new ArrayList();
            Widget widget2 = this.internalGetWidgetToSelect(object2);
            if (widget2 == null) break;
            if (!this.objectToSelect.compareAndSet(object2, null)) continue;
            object3.add(widget2);
            this.setSelection((List)object3);
            break;
        }
    }

    protected void internalExpandToLevel(Widget widget, int n) {
        Object object;
        if (!(n <= 1 && -1 != n || (object = widget.getData()) instanceof PendingUpdateAdapter)) {
            this.parentWidgets.put(widget, n);
        }
        if ((object = widget.getData()) != null && this.objectsToBeExpanded.contains(object)) {
            this.objectsToBeExpanded.remove(object);
        }
        super.internalExpandToLevel(widget, n);
    }

    protected void internalRemove(Object[] objectArray) {
        Widget widget;
        Item item;
        Widget[] widgetArray;
        Object object;
        if (1 == objectArray.length && (object = objectArray[0]) instanceof PendingUpdateAdapter && (widgetArray = this.findItems(object)) != null && widgetArray.length > 0 && this.parentWidgets.containsKey(item = this.getParentItem((Item)(widget = widgetArray[0])))) {
            this.parentWidgets.remove(item);
        }
        super.internalRemove(objectArray);
    }

    public void expandToObjectAndSelect(Object object, int n) {
        if (this.checkBusy()) {
            return;
        }
        Object object2 = this.getParentElement(object);
        if (object2 != null && this.getExpandedState(object2) || this.isRootElement(object)) {
            Widget widget = this.internalGetWidgetToSelect(object);
            if (widget != null) {
                ArrayList<Widget> arrayList = new ArrayList<Widget>();
                arrayList.add(widget);
                this.setSelection(arrayList);
                this.objectToSelect.set(null);
            } else {
                this.objectToSelect.set(object);
            }
        } else {
            this.objectToSelect.set(object);
            List<Object> list = this.createObjectList(object2, new ArrayList<Object>());
            if (!list.isEmpty()) {
                this.objectsToBeExpanded.addAll(list);
                Widget widget = this.internalExpand(object, true);
                if (widget != null) {
                    this.internalExpandToLevel(widget, n);
                }
            } else {
                Widget widget = this.internalGetWidgetToSelect(object);
                if (widget != null) {
                    ArrayList<Widget> arrayList = new ArrayList<Widget>();
                    arrayList.add(widget);
                    this.setSelection(arrayList);
                    this.objectToSelect.set(null);
                }
            }
        }
    }

    public void expandObject(Object object, int n) {
        Widget widget;
        if (this.checkBusy()) {
            return;
        }
        Object object2 = this.getParentElement(object);
        if (!(object2 != null && this.getExpandedState(object2) || this.isRootElement(object) || (widget = this.createObjectList(object2, new ArrayList<Object>())).isEmpty())) {
            this.objectsToBeExpanded.addAll((Collection<Object>)widget);
        }
        this.objectsToBeExpanded.add(object);
        widget = this.internalExpand(object, true);
        if (widget != null) {
            this.internalExpandToLevel(widget, n);
        }
    }

    private List<Object> createObjectList(Object object, List<Object> list) {
        Object object2;
        if (this.areFiltersPassed(object) && !this.getExpandedState(object)) {
            if (this.childrenLoaded(object)) {
                this.expandToLevel(object, 1);
            } else {
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(object);
            }
        }
        if ((object2 = this.getParentElement(object)) != null) {
            this.createObjectList(object2, list);
        }
        return list;
    }

    private boolean areFiltersPassed(Object object) {
        ViewerFilter[] viewerFilterArray = this.getFilters();
        if (viewerFilterArray != null) {
            ViewerFilter[] viewerFilterArray2 = viewerFilterArray;
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray2[n2];
                if (!viewerFilter.select((Viewer)this, this.getParentElement(object), object)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean childrenLoaded(Object object) {
        Item[] itemArray = this.getChildren(this.doFindItem(object));
        if (itemArray == null) {
            return false;
        }
        Item[] itemArray2 = itemArray;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray2[n2];
            if (!(item instanceof TreeItem)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isRootElement(Object object) {
        Object object2 = this.getRoot();
        Object[] objectArray = ((ITreeContentProvider)this.getContentProvider()).getElements(object2);
        return ArrayUtils.contains((Object[])objectArray, (Object)object);
    }
}

