/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SqlStatementTextInputController
extends AbstractTextInputController {
    private FormText formText;
    private Composite main;
    private ScrolledComposite scrollComposite;

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.scrollComposite = new ScrolledComposite(composite, 2560);
        this.scrollComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrollComposite.setBackground(formToolkit.getColors().getBackground());
        this.main = formToolkit.createComposite((Composite)this.scrollComposite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        this.main.setLayout((Layout)gridLayout);
        Label label = formToolkit.createLabel(this.main, null, 0);
        label.setImage(InspectIT.getDefault().getImage("/icons/fugue/database-sql.png"));
        label.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        this.formText = formToolkit.createFormText(this.main, false);
        this.formText.setLayoutData((Object)new GridData(4, 128, true, true));
        this.scrollComposite.setContent((Control)this.main);
        this.scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                SqlStatementTextInputController.this.fitSizeOfScrolledContent();
            }
        });
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).marginHeight = 0;
            ((GridLayout)layout).marginWidth = 0;
        }
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        SqlHolderHelper sqlHolderHelper;
        DefaultData defaultData;
        if (list != null && !list.isEmpty() && (defaultData = list.get(0)) instanceof SqlHolderHelper && !(sqlHolderHelper = (SqlHolderHelper)defaultData).isMaster() && !sqlHolderHelper.getSqlStatementDataList().isEmpty()) {
            this.updateRepresentation(sqlHolderHelper.getSqlStatementDataList().get(0));
            return;
        }
        this.updateRepresentation(null);
    }

    private void updateRepresentation(SqlStatementData sqlStatementData) {
        if (sqlStatementData != null) {
            String string = StringUtils.replaceEach((String)sqlStatementData.getSql(), (String[])new String[]{"?", "<", ">", "&"}, (String[])new String[]{"<b>?</b>", "&lt;", "&gt;", "&amp;"});
            if (CollectionUtils.isNotEmpty((Collection)sqlStatementData.getParameterValues())) {
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder(string.length());
                int n2 = 0;
                while (n2 < string.length()) {
                    char c = string.charAt(n2);
                    if ('?' == c) {
                        String string2 = (String)sqlStatementData.getParameterValues().get(n);
                        if (string2 == null || "".equals(string2.trim())) {
                            stringBuilder.append(c);
                        } else {
                            stringBuilder.append(string2);
                        }
                        ++n;
                    } else {
                        stringBuilder.append(c);
                    }
                    ++n2;
                }
                string = stringBuilder.toString();
            }
            this.formText.setText("<form><p>" + string + "</p></form>", true, false);
        } else {
            this.formText.setText("", false, false);
        }
        this.main.layout();
        this.fitSizeOfScrolledContent();
    }

    private void fitSizeOfScrolledContent() {
        Point point = this.scrollComposite.getSize();
        this.main.setSize(this.main.computeSize(point.x, -1));
    }

    public static class SqlHolderHelper
    extends DefaultData {
        private static final long serialVersionUID = 3529538348986684584L;
        private final boolean master;
        private final List<SqlStatementData> sqlStatementDataList;

        public SqlHolderHelper(List<SqlStatementData> list, boolean bl) {
            this.sqlStatementDataList = list;
            this.master = bl;
        }

        public List<SqlStatementData> getSqlStatementDataList() {
            return this.sqlStatementDataList;
        }

        public boolean isMaster() {
            return this.master;
        }
    }
}

