/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.editor.AbstractSubView;
import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.text.input.TextInputController;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextSubView
extends AbstractSubView {
    private Composite composite;
    private TextInputController textInputController;
    private volatile boolean jobInSchedule = false;

    public TextSubView(TextInputController textInputController) {
        Assert.isNotNull((Object)textInputController);
        this.textInputController = textInputController;
    }

    @Override
    public void init() {
        this.textInputController.setInputDefinition(this.getRootEditor().getInputDefinition());
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.composite = formToolkit.createComposite(composite);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.textInputController.createPartControl(this.composite, formToolkit);
    }

    @Override
    public void doRefresh() {
        if (this.checkDisposed()) {
            return;
        }
        if (!this.jobInSchedule) {
            this.jobInSchedule = true;
            Job job = new Job(this.getDataLoadingJobName()){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    try {
                        TextSubView.this.textInputController.doRefresh();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("Unknown exception occurred trying to refresh the view.", throwable);
                    }
                    finally {
                        TextSubView.this.jobInSchedule = false;
                    }
                }
            };
            job.schedule();
        }
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public TextInputController getTextInputController() {
        return this.textInputController;
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        if (this.checkDisposed()) {
            return;
        }
        this.textInputController.setDataInput(list);
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        return Collections.emptySet();
    }

    @Override
    public ISubView getSubViewWithInputController(Class<?> clazz) {
        if (Objects.equals(clazz, this.textInputController.getClass())) {
            return this;
        }
        return null;
    }

    private boolean checkDisposed() {
        return this.composite.isDisposed();
    }

    @Override
    public void dispose() {
        this.textInputController.dispose();
    }
}

