/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.MethodSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.TimerDataComparatorEnum;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.AggregationPerformer;
import info.novatec.inspectit.indexing.aggregation.impl.TimerDataAggregator;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.SubViewClassificationController;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.viewers.RawAggregatedResultComparator;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.handlers.ShowHideColumnsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

public class MethodInvocInputController
extends AbstractTableInputController {
    private ICachedDataService cachedDataService;
    private final StyledString emptyStyledString = new StyledString();
    private List<TimerData> timerDataList;
    private boolean rawMode = false;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            if (column.showInAggregatedMode) {
                tableViewerColumn.getColumn().setWidth(column.width);
            } else {
                tableViewerColumn.getColumn().setWidth(0);
            }
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public boolean canAlterColumnWidth(TableColumn tableColumn) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            if (Objects.equals(this.getMappedTableViewerColumn(column).getColumn(), tableColumn)) {
                return column.showInRawMode && this.rawMode || column.showInAggregatedMode && !this.rawMode;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        enumSet.add(PreferenceId.INVOCATION_SUBVIEW_MODE);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        Map<IPreferenceGroup, Object> map;
        if (PreferenceId.INVOCATION_SUBVIEW_MODE.equals((Object)preferenceEvent.getPreferenceId()) && (map = preferenceEvent.getPreferenceMap()) != null && map.containsKey(PreferenceId.InvocationSubviewMode.RAW)) {
            Boolean bl = (Boolean)map.get(PreferenceId.InvocationSubviewMode.RAW);
            this.handleRawAggregatedColumnVisibility(bl);
            this.rawMode = bl;
        }
    }

    private void handleRawAggregatedColumnVisibility(boolean bl) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer n3;
            Column column = columnArray[n2];
            if (bl) {
                if (column.showInRawMode && !column.showInAggregatedMode && !ShowHideColumnsHandler.isColumnHidden(this.getClass(), column.name)) {
                    n3 = ShowHideColumnsHandler.getRememberedColumnWidth(this.getClass(), column.name);
                    this.getMappedTableViewerColumn(column).getColumn().setWidth(n3 != null ? n3 : column.width);
                } else if (!column.showInRawMode && column.showInAggregatedMode) {
                    this.getMappedTableViewerColumn(column).getColumn().setWidth(0);
                }
            } else if (!column.showInRawMode && column.showInAggregatedMode && !ShowHideColumnsHandler.isColumnHidden(this.getClass(), column.name)) {
                n3 = ShowHideColumnsHandler.getRememberedColumnWidth(this.getClass(), column.name);
                this.getMappedTableViewerColumn(column).getColumn().setWidth(n3 != null ? n3 : column.width);
            } else if (column.showInRawMode && !column.showInAggregatedMode) {
                this.getMappedTableViewerColumn(column).getColumn().setWidth(0);
            }
            ++n2;
        }
    }

    @Override
    public IContentProvider getContentProvider() {
        return new MethodInvocContentProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        TableViewerComparator<TimerData> tableViewerComparator = new TableViewerComparator<TimerData>();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            RawAggregatedResultComparator<TimerData> rawAggregatedResultComparator = new RawAggregatedResultComparator<TimerData>(column.dataComparator, this.cachedDataService, column.showInRawMode, column.showInAggregatedMode){

                @Override
                protected boolean isRawMode() {
                    return MethodInvocInputController.this.rawMode;
                }
            };
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), rawAggregatedResultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new MethodInvocLabelProvider();
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        return list.get(0) instanceof InvocationSequenceData;
    }

    private StyledString getStyledTextForColumn(TimerData timerData, MethodIdent methodIdent, Column column) {
        switch (column) {
            case TIMESTAMP: {
                if (this.rawMode) {
                    return new StyledString(NumberFormatter.formatTimeWithMillis(timerData.getTimeStamp()));
                }
                return this.emptyStyledString;
            }
            case PACKAGE: {
                if (methodIdent.getPackageName() != null && !methodIdent.getPackageName().equals("")) {
                    return new StyledString(methodIdent.getPackageName());
                }
                return new StyledString("(default)");
            }
            case CLASS: {
                return new StyledString(methodIdent.getClassName());
            }
            case METHOD: {
                return new StyledString(TextFormatter.getMethodWithParameters(methodIdent));
            }
            case COUNT: {
                return new StyledString(String.valueOf(timerData.getCount()));
            }
            case AVERAGE: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getAverage()));
                }
                return this.emptyStyledString;
            }
            case MIN: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getMin()));
                }
                return this.emptyStyledString;
            }
            case MAX: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getMax()));
                }
                return this.emptyStyledString;
            }
            case DURATION: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getDuration()));
                }
                return this.emptyStyledString;
            }
            case CPUAVERAGE: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuAverage()));
                }
                return this.emptyStyledString;
            }
            case CPUMIN: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuMin()));
                }
                return this.emptyStyledString;
            }
            case CPUMAX: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuMax()));
                }
                return this.emptyStyledString;
            }
            case CPUDURATION: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuDuration()));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVESUM: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveDuration()));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEAVERAGE: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveAverage()));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEMIN: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveMin()));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEMAX: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveMax()));
                }
                return this.emptyStyledString;
            }
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof TimerData) {
            TimerData timerData = (TimerData)object;
            StringBuilder stringBuilder = new StringBuilder();
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(timerData, methodIdent, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof TimerData) {
            TimerData timerData = (TimerData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(timerData, methodIdent, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    @Override
    public Object[] getObjectsToSearch(Object object) {
        return this.timerDataList.toArray();
    }

    @Override
    public SubViewClassificationController.SubViewClassification getSubViewClassification() {
        return SubViewClassificationController.SubViewClassification.SLAVE;
    }

    private static enum Column {
        TIMESTAMP("Timestamp", 130, "/icons/eclipse/dates.gif", false, true, (IDataComparator<? super TimerData>)DefaultDataComparatorEnum.TIMESTAMP),
        PACKAGE("Package", 200, "/icons/eclipse/package_obj.gif", true, true, (IDataComparator<? super TimerData>)MethodSensorDataComparatorEnum.PACKAGE),
        CLASS("Class", 200, "/icons/eclipse/class_obj.gif", true, true, (IDataComparator<? super TimerData>)MethodSensorDataComparatorEnum.CLASS),
        METHOD("Method", 300, "/icons/eclipse/method.gif", true, true, (IDataComparator<? super TimerData>)MethodSensorDataComparatorEnum.METHOD),
        COUNT("Count", 60, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.COUNT),
        AVERAGE("Avg (ms)", 60, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.AVERAGE),
        MIN("Min (ms)", 60, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.MIN),
        MAX("Max (ms)", 60, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.MAX),
        DURATION("Duration (ms)", 70, null, true, true, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.DURATION),
        EXCLUSIVEAVERAGE("Exc. Avg (ms)", 80, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEAVERAGE),
        EXCLUSIVEMIN("Exc. Min (ms)", 80, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEMIN),
        EXCLUSIVEMAX("Exc. Max (ms)", 80, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEMAX),
        EXCLUSIVESUM("Exc. duration (ms)", 80, null, true, true, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEDURATION),
        CPUAVERAGE("Cpu Avg (ms)", 60, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUAVERAGE),
        CPUMIN("Cpu Min (ms)", 60, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUMIN),
        CPUMAX("Cpu Max (ms)", 60, null, true, false, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUMAX),
        CPUDURATION("Cpu Duration (ms)", 70, null, true, true, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUDURATION);

        private String name;
        private int width;
        private Image image;
        private boolean showInAggregatedMode;
        private boolean showInRawMode;
        private IDataComparator<? super TimerData> dataComparator;

        private Column(String string2, int n2, String string3, boolean bl, boolean bl2, IDataComparator<? super TimerData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.showInAggregatedMode = bl;
            this.showInRawMode = bl2;
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private final class MethodInvocContentProvider
    implements IStructuredContentProvider {
        private MethodInvocContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            MethodInvocInputController.this.timerDataList = this.getRawInputList(list, new ArrayList<TimerData>());
            if (!MethodInvocInputController.this.rawMode) {
                AggregationPerformer aggregationPerformer = new AggregationPerformer((IAggregator)new TimerDataAggregator());
                aggregationPerformer.processCollection((Collection)MethodInvocInputController.this.timerDataList);
                MethodInvocInputController.this.timerDataList = aggregationPerformer.getResultList();
            } else {
                Collections.sort(MethodInvocInputController.this.timerDataList, new Comparator<TimerData>(){

                    @Override
                    public int compare(TimerData timerData, TimerData timerData2) {
                        return timerData.getTimeStamp().compareTo(timerData2.getTimeStamp());
                    }
                });
            }
            return MethodInvocInputController.this.timerDataList.toArray();
        }

        public List<TimerData> getRawInputList(List<InvocationSequenceData> list, List<TimerData> list2) {
            for (InvocationSequenceData invocationSequenceData : list) {
                TimerData timerData = this.getTimerData(invocationSequenceData);
                if (timerData != null) {
                    list2.add(timerData);
                }
                this.getRawInputList(invocationSequenceData.getNestedSequences(), list2);
            }
            return list2;
        }

        private TimerData getTimerData(InvocationSequenceData invocationSequenceData) {
            TimerData timerData = null;
            if (invocationSequenceData.getTimerData() != null) {
                timerData = invocationSequenceData.getTimerData();
            } else if (invocationSequenceData.getSqlStatementData() != null) {
                timerData = invocationSequenceData.getSqlStatementData();
            } else if (invocationSequenceData.getParentSequence() == null) {
                timerData = this.createTimerDataForRootInvocation(invocationSequenceData);
            }
            return timerData;
        }

        private TimerData createTimerDataForRootInvocation(InvocationSequenceData invocationSequenceData) {
            TimerData timerData = new TimerData();
            timerData.setPlatformIdent(invocationSequenceData.getPlatformIdent());
            timerData.setMethodIdent(invocationSequenceData.getMethodIdent());
            timerData.setTimeStamp(invocationSequenceData.getTimeStamp());
            timerData.setDuration(invocationSequenceData.getDuration());
            timerData.calculateMax(invocationSequenceData.getDuration());
            timerData.calculateMin(invocationSequenceData.getDuration());
            timerData.increaseCount();
            double d = invocationSequenceData.getDuration() - this.computeNestedDuration(invocationSequenceData);
            timerData.setExclusiveDuration(d);
            timerData.calculateExclusiveMax(d);
            timerData.calculateExclusiveMin(d);
            timerData.increaseExclusiveCount();
            timerData.finalizeData();
            return timerData;
        }

        private double computeNestedDuration(InvocationSequenceData invocationSequenceData) {
            if (invocationSequenceData.getNestedSequences().isEmpty()) {
                return 0.0;
            }
            double d = 0.0;
            boolean bl = false;
            for (InvocationSequenceData invocationSequenceData2 : invocationSequenceData.getNestedSequences()) {
                if (invocationSequenceData2.getParentSequence() == null) {
                    d += invocationSequenceData2.getDuration();
                    bl = true;
                } else if (invocationSequenceData2.getTimerData() != null) {
                    d += invocationSequenceData2.getTimerData().getDuration();
                    bl = true;
                } else if (invocationSequenceData2.getSqlStatementData() != null && 1L == invocationSequenceData2.getSqlStatementData().getCount()) {
                    d += invocationSequenceData2.getSqlStatementData().getDuration();
                    bl = true;
                }
                if (!bl && !invocationSequenceData2.getNestedSequences().isEmpty()) {
                    d += this.computeNestedDuration(invocationSequenceData2);
                }
                bl = false;
            }
            return d;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private final class MethodInvocLabelProvider
    extends StyledCellIndexLabelProvider {
        private MethodInvocLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            TimerData timerData = (TimerData)object;
            MethodIdent methodIdent = MethodInvocInputController.this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
            Column column = Column.fromOrd(n);
            return MethodInvocInputController.this.getStyledTextForColumn(timerData, methodIdent, column);
        }
    }
}

