/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.search;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.search.ISearchExecutor;
import info.novatec.inspectit.rcp.editor.search.OpenedSearchControlCache;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchCriteria;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchResult;
import info.novatec.inspectit.util.ObjectUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchControl {
    private ISearchExecutor searchExecutor;
    private Composite mainComposite;
    private Text searchTextBox;
    private ToolItem caseSensitiveButton;
    private ToolItem closeButton;
    private Shell shell;
    private ToolItem next;
    private ToolItem previous;
    private SearchResult lastSearchResult;

    public SearchControl(ISearchExecutor iSearchExecutor, Shell shell, Control control, IEditorPart iEditorPart) {
        this.searchExecutor = iSearchExecutor;
        this.createSearchShell(shell, control, iEditorPart);
    }

    private void createSearchShell(Shell shell, final Control control, final IEditorPart iEditorPart) {
        Control control2;
        Display display = Display.getDefault();
        FormColors formColors = new FormColors(display);
        FormToolkit formToolkit = new FormToolkit(formColors);
        this.shell = new Shell(shell, 2052);
        this.mainComposite = formToolkit.createComposite((Composite)this.shell);
        GridLayout gridLayout = new GridLayout(3, false);
        this.mainComposite.setLayout((Layout)gridLayout);
        this.mainComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.searchTextBox = formToolkit.createText(this.mainComposite, null, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.minimumWidth = 200;
        this.searchTextBox.setLayoutData((Object)gridData);
        this.searchTextBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    SearchControl.this.executeSearch();
                }
            }
        });
        this.searchTextBox.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (SearchControl.this.lastSearchResult != null) {
                    String string = String.valueOf(SearchControl.this.lastSearchResult.getCurrentOccurence()) + " of " + SearchControl.this.lastSearchResult.getTotalOccurrences();
                    if (SearchControl.this.lastSearchResult.getTotalOccurrences() > 0) {
                        this.paintString(paintEvent, string, Display.getDefault().getSystemColor(15));
                    } else {
                        this.paintString(paintEvent, string, Display.getDefault().getSystemColor(3));
                    }
                }
            }

            private void paintString(PaintEvent paintEvent, String string, Color color) {
                Point point = SearchControl.this.searchTextBox.getSize();
                FontMetrics fontMetrics = paintEvent.gc.getFontMetrics();
                int n = fontMetrics.getAverageCharWidth() * string.length();
                int n2 = fontMetrics.getHeight();
                paintEvent.gc.setForeground(color);
                paintEvent.gc.drawString(string, point.x - n - SearchControl.this.searchTextBox.getBorderWidth() - 2, (point.y - n2 - SearchControl.this.searchTextBox.getBorderWidth() * 2) / 2, true);
            }
        });
        ToolBar toolBar = new ToolBar(this.mainComposite, 0x800000);
        toolBar.setBackground(formColors.getBackground());
        this.previous = new ToolItem(toolBar, 262152);
        this.previous.setImage(InspectIT.getDefault().getImage("/icons/eclipse/prev_nav.gif"));
        this.previous.setEnabled(false);
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchControl.this.executePrevious();
            }
        });
        this.next = new ToolItem(toolBar, 262152);
        this.next.setImage(InspectIT.getDefault().getImage("/icons/eclipse/next_nav.gif"));
        this.next.setEnabled(false);
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchControl.this.executeNext();
            }
        });
        this.caseSensitiveButton = new ToolItem(toolBar, 262176);
        this.caseSensitiveButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/font.gif"));
        this.caseSensitiveButton.setToolTipText("Case sensitive");
        this.caseSensitiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchControl.this.executeSearch();
            }
        });
        Composite composite = formToolkit.createComposite(this.mainComposite);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.minimumWidth = 0;
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        composite.setLayoutData((Object)gridData);
        this.closeButton = new ToolItem(toolBar, 262152);
        this.closeButton.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_co.gif"));
        this.closeButton.setToolTipText("Close");
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchControl.this.searchExecutor.clearSearch();
                SearchControl.this.closeControl();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 27) {
                    SearchControl.this.searchExecutor.clearSearch();
                    SearchControl.this.closeControl();
                }
            }
        };
        this.mainComposite.addKeyListener((KeyListener)keyAdapter);
        Control[] controlArray = this.mainComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control2 = controlArray[n2];
            control2.addKeyListener((KeyListener)keyAdapter);
            ++n2;
        }
        this.searchTextBox.forceFocus();
        this.mainComposite.pack();
        this.mainComposite.setSize(this.mainComposite.computeSize(-1, -1));
        control2 = this.shell.computeSize(-1, -1);
        Point point = control.toDisplay(0, 0);
        Point point2 = control.getSize();
        int n3 = point.x + point2.x - control2.x - control.getBorderWidth();
        int n4 = point.y + point2.y - control2.y - control.getBorderWidth();
        this.shell.setLocation(n3, n4);
        this.shell.setSize((Point)control2);
        this.shell.open();
        control.addControlListener((ControlListener)new ControlAdapter((Point)control2){
            private final /* synthetic */ Point val$shellSize;
            {
                this.val$shellSize = point;
            }

            public void controlResized(ControlEvent controlEvent) {
                if (!SearchControl.this.shell.isDisposed()) {
                    Point point = control.toDisplay(0, 0);
                    Point point2 = control.getSize();
                    int n = point.x + point2.x - this.val$shellSize.x - control.getBorderWidth();
                    int n2 = point.y + point2.y - this.val$shellSize.y - control.getBorderWidth();
                    SearchControl.this.shell.setLocation(n, n2);
                }
            }
        });
        iEditorPart.getSite().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart iWorkbenchPart) {
            }

            public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
                if (ObjectUtils.equals((Object)iEditorPart, (Object)iWorkbenchPart)) {
                    SearchControl.this.closeControl();
                }
            }

            public void partClosed(IWorkbenchPart iWorkbenchPart) {
                if (ObjectUtils.equals((Object)iEditorPart, (Object)iWorkbenchPart)) {
                    SearchControl.this.closeControl();
                }
            }

            public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            }

            public void partActivated(IWorkbenchPart iWorkbenchPart) {
            }
        });
        OpenedSearchControlCache.register(this.searchExecutor, this);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                SearchControl.this.searchExecutor.clearSearch();
                OpenedSearchControlCache.unregister(SearchControl.this.searchExecutor);
            }
        });
        formToolkit.dispose();
    }

    public final void closeControl() {
        if (!this.shell.isDisposed()) {
            this.shell.close();
        }
    }

    private void executeSearch() {
        String string = this.searchTextBox.getText().trim();
        if (!string.isEmpty()) {
            SearchCriteria searchCriteria = new SearchCriteria(string, this.caseSensitiveButton.getSelection());
            this.lastSearchResult = this.searchExecutor.executeSearch(searchCriteria);
            this.processSearchResult(this.lastSearchResult);
        } else {
            this.searchExecutor.clearSearch();
            this.lastSearchResult = null;
            this.searchTextBox.redraw();
        }
    }

    private void executeNext() {
        this.lastSearchResult = this.searchExecutor.next();
        this.processSearchResult(this.lastSearchResult);
    }

    private void executePrevious() {
        this.lastSearchResult = this.searchExecutor.previous();
        this.processSearchResult(this.lastSearchResult);
    }

    private void processSearchResult(SearchResult searchResult) {
        this.searchTextBox.redraw();
        if (searchResult != null) {
            this.next.setEnabled(searchResult.isCanShowNext());
            this.previous.setEnabled(searchResult.isCanShowPrevious());
        }
    }
}

