/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.preferences.control;

import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.IPreferencePanel;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.preferences.control.AbstractPreferenceControl;
import info.novatec.inspectit.rcp.editor.preferences.control.IPreferenceControl;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class TimeLineControl
extends AbstractPreferenceControl
implements IPreferenceControl,
PreferenceEventCallback {
    private CDateTime fromDateTime;
    private CDateTime toDateTime;
    private Date oldToDate;
    private Date oldFromDate;
    private Composite mainComposite;

    public TimeLineControl(IPreferencePanel iPreferencePanel) {
        super(iPreferencePanel);
    }

    @Override
    public PreferenceId getControlGroupId() {
        return PreferenceId.TIMELINE;
    }

    @Override
    public Composite createControls(Composite composite, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(composite, 256);
        section.setText("Time Range");
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        this.mainComposite = formToolkit.createComposite((Composite)section);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        section.setClient((Control)this.mainComposite);
        Composite composite2 = formToolkit.createComposite(this.mainComposite);
        composite2.setLayout((Layout)new GridLayout(14, false));
        composite2.setLayoutData((Object)new GridData(4, 4, false, false));
        formToolkit.createLabel(composite2, "Last: ");
        this.createTimeHyperlink(composite2, formToolkit, "15 minutes", 900000L);
        formToolkit.createLabel(composite2, " | ");
        this.createTimeHyperlink(composite2, formToolkit, "1 hour", 3600000L);
        formToolkit.createLabel(composite2, " | ");
        this.createTimeHyperlink(composite2, formToolkit, "6 hours", 21600000L);
        formToolkit.createLabel(composite2, " | ");
        this.createTimeHyperlink(composite2, formToolkit, "12 hours", 43200000L);
        formToolkit.createLabel(composite2, " | ");
        this.createTimeHyperlink(composite2, formToolkit, "1 day", 86400000L);
        formToolkit.createLabel(composite2, " | ");
        this.createTimeHyperlink(composite2, formToolkit, "7 days", 604800000L);
        formToolkit.createLabel(composite2, " | ");
        this.createTimeHyperlink(composite2, formToolkit, "30 days", 2592000000L);
        Composite composite3 = formToolkit.createComposite(this.mainComposite);
        composite3.setLayout((Layout)new GridLayout(4, false));
        composite3.setLayoutData((Object)new GridData(4, 4, false, false));
        Date date = new Date();
        Date date2 = new Date(date.getTime() - 600000L);
        formToolkit.createLabel(composite3, "From: ");
        this.fromDateTime = new CDateTime(composite3, 3);
        this.fromDateTime.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fromDateTime.setFormat(0x900000);
        this.fromDateTime.setSelection(date2);
        formToolkit.createLabel(composite3, "To: ");
        this.toDateTime = new CDateTime(composite3, 3);
        this.toDateTime.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toDateTime.setFormat(0x900000);
        this.toDateTime.setSelection(date);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimeLineControl.this.getPreferencePanel().update();
            }
        };
        this.fromDateTime.addSelectionListener((SelectionListener)selectionAdapter);
        this.toDateTime.addSelectionListener((SelectionListener)selectionAdapter);
        this.getPreferencePanel().registerCallback(this);
        return this.mainComposite;
    }

    @Override
    public Map<IPreferenceGroup, Object> eventFired() {
        HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
        Date date = this.toDateTime.getSelection();
        Date date2 = this.fromDateTime.getSelection();
        if (this.oldToDate == null || this.oldToDate.getTime() != date.getTime()) {
            hashMap.put(PreferenceId.TimeLine.TO_DATE_ID, date);
            this.oldToDate = new Date(date.getTime());
        }
        if (this.oldFromDate == null || this.oldFromDate.getTime() != date2.getTime()) {
            hashMap.put(PreferenceId.TimeLine.FROM_DATE_ID, date2);
            this.oldFromDate = new Date(date2.getTime());
        }
        return hashMap;
    }

    @Override
    public void dispose() {
        this.getPreferencePanel().removeCallback(this);
    }

    private Hyperlink createTimeHyperlink(Composite composite, FormToolkit formToolkit, String string, final long l) {
        Hyperlink hyperlink = formToolkit.createHyperlink(composite, string, 0);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                Date date = new Date();
                Date date2 = new Date(date.getTime() - l);
                TimeLineControl.this.toDateTime.setSelection(date);
                TimeLineControl.this.fromDateTime.setSelection(date2);
                TimeLineControl.this.getPreferencePanel().update();
            }
        });
        return hyperlink;
    }

    private void setEnabled(boolean bl) {
        this.fromDateTime.setEnabled(bl);
        this.toDateTime.setEnabled(bl);
    }

    @Override
    public void eventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        if (PreferenceId.LIVEMODE.equals((Object)preferenceEvent.getPreferenceId())) {
            Boolean bl = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
            if (bl != null && bl.booleanValue()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        } else if (PreferenceId.TIMELINE.equals((Object)preferenceEvent.getPreferenceId())) {
            if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                this.fromDateTime.setSelection((Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.FROM_DATE_ID));
            }
            if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.TO_DATE_ID)) {
                this.toDateTime.setSelection((Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.TO_DATE_ID));
            }
        }
    }
}

