/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.inputdefinition;

import com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;

public class EditorPropertiesData {
    private PartType partNameFlag = PartType.VIEW;
    private PartType partImageFlag = PartType.SENSOR;
    private Image sensorImage;
    private String sensorName = "";
    private Image viewImage;
    private String viewName = "";

    public String getPartName() {
        switch (this.partNameFlag) {
            case SENSOR: {
                return this.sensorName;
            }
        }
        return this.viewName;
    }

    public void setPartNameFlag(PartType partType) {
        this.partNameFlag = partType;
    }

    public Image getPartImage() {
        switch (this.partImageFlag) {
            case VIEW: {
                return this.viewImage;
            }
        }
        return this.sensorImage;
    }

    public void setPartImageFlag(PartType partType) {
        this.partImageFlag = partType;
    }

    public String getPartTooltip() {
        StringBuilder stringBuilder = new StringBuilder(this.sensorName);
        if (StringUtils.isNotEmpty((String)this.viewName)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" > ");
            }
            stringBuilder.append(this.viewName);
        }
        return stringBuilder.toString();
    }

    public Image getSensorImage() {
        return this.sensorImage;
    }

    public void setSensorImage(Image image) {
        this.sensorImage = image;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public void setSensorName(String string) {
        this.sensorName = string;
    }

    public Image getViewImage() {
        return this.viewImage;
    }

    public void setViewImage(Image image) {
        this.viewImage = image;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partImageFlag, this.partNameFlag, this.sensorImage, this.sensorName, this.viewImage, this.viewName});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EditorPropertiesData editorPropertiesData = (EditorPropertiesData)object;
        return Objects.equal((Object)((Object)this.partImageFlag), (Object)((Object)editorPropertiesData.partImageFlag)) && Objects.equal((Object)((Object)this.partNameFlag), (Object)((Object)editorPropertiesData.partNameFlag)) && Objects.equal((Object)this.sensorImage, (Object)editorPropertiesData.sensorImage) && Objects.equal((Object)this.sensorName, (Object)editorPropertiesData.sensorName) && Objects.equal((Object)this.viewImage, (Object)editorPropertiesData.viewImage) && Objects.equal((Object)this.viewName, (Object)editorPropertiesData.viewName);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("group/sensor image", (Object)this.sensorImage).add("group/sensor", (Object)this.sensorName).add("viewName", (Object)this.viewImage).add("viewName", (Object)this.viewName).toString();
    }

    public static enum PartType {
        SENSOR,
        VIEW;

    }
}

