/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot.datasolver.impl;

import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.AbstractPlotDataSolver;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.RangeType;

public class MemoryDataSolver
extends AbstractPlotDataSolver {
    private static final double MEGABYTE_BYTE_COUNT = 1048576.0;

    MemoryDataSolver() {
    }

    @Override
    public NumberAxis getAxis() {
        NumberAxis numberAxis = new NumberAxis("Memory (MB)");
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setLowerBound(0.0);
        numberAxis.setRangeType(RangeType.POSITIVE);
        numberAxis.setAutoRange(true);
        return numberAxis;
    }

    @Override
    public double valueConvert(double d) {
        return d / 1048576.0;
    }

    @Override
    protected String valueToHumanReadableImpl(double d) {
        return NumberFormatter.humanReadableByteCount((long)(d * 1048576.0));
    }

    @Override
    public boolean isAggregatable() {
        return true;
    }
}

