/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.dialog;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.util.ObjectUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditNameDescriptionDialog
extends TitleAreaDialog {
    private static final String DEFAULT_MESSAGE = "Enter new name and/or description";
    private static final String DEFAULT_TITLE = "Edit Data";
    private Text nameBox;
    private Text descriptionBox;
    private Control okButton;
    private String oldName;
    private String oldDescription;
    private String newDescription;
    private String newName;
    private String dialogTitle = "Edit Data";
    private String dialogMessage = "Enter new name and/or description";

    public EditNameDescriptionDialog(Shell shell, String string, String string2) {
        super(shell);
        this.oldName = string;
        this.oldDescription = string2;
    }

    public EditNameDescriptionDialog(Shell shell, String string, String string2, String string3, String string4) {
        this(shell, string, string2);
        Assert.isNotNull((Object)string3);
        Assert.isNotNull((Object)string4);
        this.dialogTitle = string3;
        this.dialogMessage = string4;
    }

    public void create() {
        super.create();
        this.setTitle(this.dialogTitle);
        this.setMessage(this.dialogMessage, 1);
        this.setTitleImage(InspectIT.getDefault().getImage("/icons/eclipse/wizban/edit_wiz.png"));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DEFAULT_TITLE);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText("New name:");
        this.nameBox = new Text(composite2, 2048);
        this.nameBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameBox.setText(this.oldName);
        this.nameBox.selectAll();
        Label label2 = new Label(composite2, 16384);
        label2.setText("New description:");
        label2.setLayoutData((Object)new GridData(4, 128, false, false));
        this.descriptionBox = new Text(composite2, 2626);
        this.descriptionBox.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.oldDescription != null) {
            this.descriptionBox.setText(this.oldDescription);
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (EditNameDescriptionDialog.this.isInputValid()) {
                    EditNameDescriptionDialog.this.okButton.setEnabled(true);
                } else {
                    EditNameDescriptionDialog.this.okButton.setEnabled(false);
                }
            }
        };
        this.nameBox.addModifyListener(modifyListener);
        this.descriptionBox.addModifyListener(modifyListener);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1, IDialogConstants.CLOSE_LABEL, false);
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.newName = this.nameBox.getText().trim();
            if (!this.descriptionBox.getText().trim().isEmpty()) {
                this.newDescription = this.descriptionBox.getText().trim();
            }
        }
        super.buttonPressed(n);
    }

    public String getName() {
        return this.newName;
    }

    public String getDescription() {
        return this.newDescription;
    }

    private boolean isInputValid() {
        if (ObjectUtils.equals((Object)this.oldName, (Object)this.nameBox.getText().trim()) && ObjectUtils.equals((Object)this.oldDescription, (Object)this.descriptionBox.getText().trim())) {
            return false;
        }
        return !this.nameBox.getText().isEmpty();
    }
}

