/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.dialog;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.TechnicalException;
import info.novatec.inspectit.rcp.InspectIT;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BusinessExceptionDialog
extends TitleAreaDialog {
    private String dialogTitle = "Business exception occurred";
    private BusinessException exception;

    public BusinessExceptionDialog(Shell shell, BusinessException businessException) {
        super(shell);
        Assert.isNotNull((Object)((Object)businessException), (String)"Exception to show in the dialog must not be null.");
        this.exception = businessException;
        if (businessException instanceof TechnicalException) {
            this.dialogTitle = "Technical exception occurred";
        }
    }

    public void create() {
        super.create();
        this.setTitle(this.dialogTitle);
        this.setTitleImage(InspectIT.getDefault().getImage("/icons/eclipse/wizban/error_wiz.png"));
        if (this.exception.getErrorCode() != null) {
            this.setMessage(this.exception.getErrorCode().getName());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1, IDialogConstants.CLOSE_LABEL, true).setFocus();
    }

    protected Control createDialogArea(Composite composite) {
        String string;
        int n;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        FormToolkit formToolkit = new FormToolkit(composite.getDisplay());
        Composite composite2 = formToolkit.createComposite(composite);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        composite2.setLayoutData((Object)gridData);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 0;
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.bottomMargin = 0;
        tableWrapLayout.rightMargin = 0;
        composite2.setLayout((Layout)tableWrapLayout);
        Composite composite3 = formToolkit.createCompositeSeparator(composite2);
        TableWrapData tableWrapData = new TableWrapData(256);
        tableWrapData.heightHint = 2;
        composite3.setLayoutData((Object)tableWrapData);
        Composite composite4 = formToolkit.createComposite(composite2);
        composite4.setLayout((Layout)new TableWrapLayout());
        composite4.setLayoutData((Object)new TableWrapData(256));
        FormText formText = formToolkit.createFormText(composite4, false);
        StringBuilder stringBuilder = new StringBuilder("<form><p>");
        if (this.exception.getActionPerformed() != null) {
            stringBuilder.append("An exception occurred while executing the action <span color=\"headingColor\">" + this.exception.getActionPerformed() + "</span><br/><br/>");
        }
        if (this.exception.getServiceMethodSignature() != null) {
            stringBuilder.append("The exception occurred while invoking the service method <span color=\"headingColor\">" + this.exception.getServiceMethodSignature() + "</span><br/><br/>");
        }
        stringBuilder.append("Following error code was reported:</p></form>");
        formText.setText(stringBuilder.toString(), true, false);
        formText.setLayoutData((Object)new TableWrapData(128));
        formText.setColor("headingColor", formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        IErrorCode iErrorCode = this.exception.getErrorCode();
        Composite composite5 = formToolkit.createComposite(composite4);
        composite5.setLayout((Layout)new GridLayout(1, true));
        composite5.setLayoutData((Object)new TableWrapData(128));
        FormText formText2 = formToolkit.createFormText(composite5, false);
        formText2.setText("<form><p><span color=\"headingColor\">" + iErrorCode.getName() + "</span></p></form>", true, false);
        formText2.setColor("headingColor", this.getShell().getDisplay().getSystemColor(3));
        formText2.setFont(JFaceResources.getFont((String)"org.eclipse.jface.headerfont"));
        gridData = new GridData(0x1000000, 4, true, false);
        formText2.setLayoutData((Object)gridData);
        FormText formText3 = formToolkit.createFormText(composite4, false);
        StringBuilder stringBuilder2 = new StringBuilder("<form><p>");
        stringBuilder2.append("<span color=\"headingColor\" font=\"headingFont\">Description</span><br/>");
        if (iErrorCode.getDescription() != null) {
            stringBuilder2.append(iErrorCode.getDescription());
            stringBuilder2.append("<br/><br/>");
        } else {
            stringBuilder2.append("-<br/><br/>");
        }
        stringBuilder2.append("<span color=\"headingColor\" font=\"headingFont\">Possible causes</span><br/>");
        if (iErrorCode.getPossibleCause() != null) {
            stringArray = stringArray2 = iErrorCode.getPossibleCause().split("\n");
            n2 = stringArray2.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                stringBuilder2.append(string);
                stringBuilder2.append("<br/>");
                ++n;
            }
            stringBuilder2.append("<br/>");
        } else {
            stringBuilder2.append("-<br/><br/>");
        }
        stringBuilder2.append("<span color=\"headingColor\" font=\"headingFont\">Possible solutions</span><br/>");
        if (iErrorCode.getPossibleSolution() != null) {
            stringArray = stringArray2 = iErrorCode.getPossibleSolution().split("\n");
            n2 = stringArray2.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                stringBuilder2.append(string);
                stringBuilder2.append("<br/>");
                ++n;
            }
            stringBuilder2.append("<br/>");
        } else {
            stringBuilder2.append("-<br/><br/>");
        }
        stringBuilder2.append("</p></form>");
        formText3.setColor("headingColor", this.getShell().getDisplay().getSystemColor(3));
        formText3.setFont("headingFont", JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        formText3.setText(stringBuilder2.toString(), true, false);
        formText3.setLayoutData((Object)new TableWrapData(128));
        return composite2;
    }
}

